/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.s3;

import java.util.Optional;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.conn.UnsupportedSchemeException;
import org.conqat.lib.commons.error.ExceptionUtils;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;

public class S3Exception
extends Exception {
    private static final long serialVersionUID = 1L;

    S3Exception(String message, Throwable cause) {
        super(message, cause);
    }

    S3Exception(SdkException cause, String bucket) {
        super("Connection to S3 bucket '" + bucket + "' failed: " + S3Exception.extractDetailedErrorMessage(cause), cause);
    }

    public boolean isNotFoundError() {
        Throwable throwable = this.getCause();
        if (throwable instanceof AwsServiceException) {
            AwsServiceException amazonS3Exception = (AwsServiceException)throwable;
            return amazonS3Exception.statusCode() == 404;
        }
        return this.getMessage().contains("Status Code: 404;");
    }

    private static String extractDetailedErrorMessage(SdkException cause) {
        if (cause instanceof AwsServiceException) {
            AwsServiceException amazonS3Exception = (AwsServiceException)cause;
            return S3Exception.getDescriptionForAmazonS3Exception(amazonS3Exception);
        }
        if (cause.getCause() instanceof ClientProtocolException) {
            Optional message = ExceptionUtils.getFirstNonNullCauseMessage((Throwable)cause.getCause());
            if (message.isPresent()) {
                return (String)message.get();
            }
        } else {
            Throwable throwable = cause.getCause();
            if (throwable instanceof UnsupportedSchemeException) {
                UnsupportedSchemeException unsupportedSchemeException = (UnsupportedSchemeException)throwable;
                return unsupportedSchemeException.getMessage();
            }
            throwable = cause.getCause();
            if (throwable instanceof SdkClientException) {
                SdkClientException sdkClientException = (SdkClientException)throwable;
                return sdkClientException.getMessage();
            }
        }
        return "Could not determine a useful message. Please provide the stacktrace to the Teamscale support team to improve the error messages in the future: " + ExceptionUtils.getStacktraceAsString((Throwable)cause);
    }

    private static String getDescriptionForAmazonS3Exception(AwsServiceException amazonS3Exception) {
        int statusCode = amazonS3Exception.statusCode();
        return switch (statusCode) {
            case 403 -> "The user may not have access to the bucket or doesn't have sufficient permissions.\n Details from S3:";
            case 404 -> "Bucket does not exist.\n Details from S3:";
            default -> "Error code %s.".formatted(statusCode);
        };
    }
}

