/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.s3;

import com.teamscale.index.s3.S3Exception;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.NonNull;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;

class S3MultiPartOutputStream
extends OutputStream {
    private static final String CONTENT_TYPE = "application/zip";
    private final String uploadId;
    private final List<CompletedPart> completedParts = new ArrayList<CompletedPart>();
    private final S3Client s3;
    private final String bucket;
    private final String key;
    private int currentPart = 1;

    private S3MultiPartOutputStream(S3Client s3, String bucket, String key, CreateMultipartUploadResponse initiateMultipartUploadResult) {
        this.s3 = s3;
        this.bucket = bucket;
        this.key = key;
        this.uploadId = initiateMultipartUploadResult.uploadId();
    }

    public static OutputStream init(S3Client client, String bucket, String key) {
        return new S3MultiPartOutputStream(client, bucket, key, client.createMultipartUpload(S3MultiPartOutputStream.createInitiateRequest(bucket, key)));
    }

    @Override
    public void write(int b) {
        throw new UnsupportedOperationException("Expecting BufferedOutputStream to only call write(byte[], int, int)");
    }

    @Override
    public void write(byte @NonNull [] data, int offset, int length) throws IOException {
        try {
            UploadPartResponse result = this.uploadPart(this.bucket, this.key, this.uploadId, this.currentPart, data, offset, length);
            this.completedParts.add((CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(this.currentPart)).eTag(result.eTag()).build());
            ++this.currentPart;
        }
        catch (S3Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            CompleteMultipartUploadRequest request = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(this.bucket).key(this.key).uploadId(this.uploadId).multipartUpload(b -> b.parts(this.completedParts)).build();
            this.s3.completeMultipartUpload(request);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private UploadPartResponse uploadPart(String bucket, String key, String uploadId, int partNumber, byte @NonNull [] data, int offset, long length) throws S3Exception {
        UploadPartRequest request = (UploadPartRequest)UploadPartRequest.builder().bucket(bucket).key(key).uploadId(uploadId).partNumber(Integer.valueOf(partNumber)).contentLength(Long.valueOf(length)).build();
        try {
            return this.s3.uploadPart(request, RequestBody.fromInputStream((InputStream)new ByteArrayInputStream(data, offset, (int)length), (long)length));
        }
        catch (SdkException e) {
            throw new S3Exception(e, bucket);
        }
    }

    private static CreateMultipartUploadRequest createInitiateRequest(String bucket, String key) {
        return (CreateMultipartUploadRequest)CreateMultipartUploadRequest.builder().bucket(bucket).key(key).contentType(CONTENT_TYPE).build();
    }
}

