/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.analysis;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.option.NumericThresholds;
import com.teamscale.core.findings.FindingsIndex;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.index.configuration.SimulinkAnalysisConfigurationBase;
import com.teamscale.index.dependencies.simulink.LazyModelLoader;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.ContentIndexInputAnalysisStepBase;
import com.teamscale.index.simulink.analysis.SimulinkFindingAnalysisBase;
import com.teamscale.index.simulink.analysis.SimulinkMetricAnalysisBase;
import com.teamscale.index.simulink.analysis.finding.ThresholdFindingAnalysisBase;
import com.teamscale.index.simulink.content.SimulinkFileSynchronizer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class SimulinkAnalysisRunner
extends ContentIndexInputAnalysisStepBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FINDINGS_PARTITION = "simulink-checks";
    public static final String METRIC_CLASS_PARAMETER = "metric.class";
    public static final String METRIC_VALUE_TYPE_PARAMETER = "metric.valueType";
    public static final String FINDING_CLASS_PARAMETER = "finding.class";
    @StepParameter(value="metric.class", optional=true)
    private final List<String> metricClasses = new ArrayList<String>();
    @StepParameter(value="metric.valueType", optional=true)
    private final List<EMetricValueType> valueTypes = new ArrayList<EMetricValueType>();
    private final PairList<String, SimulinkMetricAnalysisBase> metrics = new PairList();
    private final PairList<String, SimulinkFindingAnalysisBase> findings = new PairList();
    @StepParameter(value="finding.class", optional=true)
    private final List<String> findingClasses = new ArrayList<String>();
    @IndexAccess(indexName="metrics", value=EIndexAccessMode.READ_WRITE)
    private MetricsIndex metricsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FindingsIndex findingsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private FindingsSchemaIndex schemaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BinaryElementIndex binaryContentIndex;
    private HashMap<String, NumericThresholds> metricThresholds = new HashMap();
    @StepParameter(value="metricThresholds.serializedThresholds", optional=true)
    private String metricThresholdsSerialized = null;

    private static Class<?> loadClass(String className) throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(className);
    }

    protected SimulinkFindingAnalysisBase configureSimulinkFindingAnalysis(SimulinkFindingAnalysisBase analysisInstance) throws ConQATException {
        return analysisInstance;
    }

    public void execute() throws StorageException {
        try {
            this.initParameters();
        }
        catch (ConQATException e) {
            LOGGER.error("Error initializing parameters: " + e.toString(), (Throwable)e);
        }
        List deletedKeys = this.contentDelta.getDeletedKeysAsStrings();
        if (!deletedKeys.isEmpty()) {
            this.metricsIndex.removeEntries((Collection)deletedKeys, (Collection)this.metrics.extractFirstList());
            this.findingsIndex.removeFindingsForPartitionsAndPaths(this.getFindingsPartition(), deletedKeys);
        }
        List<PairList<String, Serializable>> allMetricValues = this.prepareMetricValuesContainer();
        PairList allFindings = new PairList();
        this.addEmptyValuesForNonSimulinkPaths(CollectionUtils.filter((Collection)this.contentDelta.getAddedOrChangedKeysAsStrings(), path -> !SimulinkUtils.isSimulinkModelPath((String)path)), allMetricValues);
        List<String> uniformPaths = SimulinkFileSynchronizer.filterSimulinkModels(this.contentDelta.getAddedOrChangedKeysAsStrings());
        LazyModelLoader modelLoader = new LazyModelLoader(this.binaryContentIndex);
        modelLoader.preloadModels(uniformPaths);
        for (String uniformPath : uniformPaths) {
            Optional<SimulinkModel> model = modelLoader.getModelByUniformPath(uniformPath);
            if (!model.isPresent()) continue;
            this.calculateMetrics(uniformPath, model.get(), allMetricValues);
            this.calculateFindings(uniformPath, model.get(), (PairList<String, ArrayList<IndexFinding>>)allFindings);
        }
        this.findingsIndex.setFindings(this.getFindingsPartition(), allFindings, this.schemaIndex.getFindingsSchema());
        this.metricsIndex.setMetricValues(allMetricValues, this.metrics.extractFirstList());
    }

    private void initParameters() throws ConQATException {
        Class<Object> clazz;
        if (!StringUtils.isEmpty((String)this.metricThresholdsSerialized)) {
            this.metricThresholds = (HashMap)StorageUtils.deserialize((byte[])Base64.getDecoder().decode(this.metricThresholdsSerialized));
        }
        for (String metricClass : this.metricClasses) {
            try {
                clazz = SimulinkAnalysisRunner.loadClass(metricClass).asSubclass(SimulinkMetricAnalysisBase.class);
                this.metrics.add((Object)SimulinkAnalysisConfigurationBase.getMetricAnalysisAnnotation(clazz).internalName(), (Object)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                throw new ConQATException("Failed to configure analysis runner with metric " + metricClass, (Throwable)e);
            }
        }
        for (String findingClass : this.findingClasses) {
            try {
                clazz = SimulinkAnalysisRunner.loadClass(findingClass).asSubclass(SimulinkFindingAnalysisBase.class);
                this.findings.add((Object)SimulinkAnalysisConfigurationBase.getFindingAnalysisAnnotation(clazz).name(), (Object)((SimulinkFindingAnalysisBase)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                throw new ConQATException("Failed to configure analysis runner with finding " + findingClass, (Throwable)e);
            }
        }
        for (Pair finding : this.findings) {
            try {
                this.configureSimulinkFindingAnalysis((SimulinkFindingAnalysisBase)finding.getSecond());
            }
            catch (ConQATException e) {
                throw new ConQATException(e.toString(), (Throwable)e);
            }
        }
    }

    private void addEmptyValuesForNonSimulinkPaths(List<String> paths, List<PairList<String, Serializable>> allMetricValues) {
        for (String path : paths) {
            for (int i = 0; i < this.metrics.size(); ++i) {
                allMetricValues.get(i).add((Object)path, (Object)((Serializable)this.valueTypes.get(i).getDefaultValue()));
            }
        }
    }

    protected String getFindingsPartition() {
        return FINDINGS_PARTITION;
    }

    private List<PairList<String, Serializable>> prepareMetricValuesContainer() {
        ArrayList<PairList<String, Serializable>> allMetricValues = new ArrayList<PairList<String, Serializable>>();
        for (int i = 0; i < this.metrics.size(); ++i) {
            allMetricValues.add((PairList<String, Serializable>)new PairList());
        }
        return allMetricValues;
    }

    private void calculateMetrics(String uniformPath, SimulinkModel model, List<PairList<String, Serializable>> allMetricValues) {
        for (int i = 0; i < this.metrics.size(); ++i) {
            Double value = ((SimulinkMetricAnalysisBase)this.metrics.getSecond(i)).calculateMetricValue(model);
            allMetricValues.get(i).add((Object)uniformPath, (Object)value);
        }
    }

    private void calculateFindings(String uniformPath, SimulinkModel model, PairList<String, ArrayList<IndexFinding>> allFindings) {
        ArrayList findingsFound = new ArrayList();
        for (int i = 0; i < this.findings.size(); ++i) {
            SimulinkFindingAnalysisBase analyzer = (SimulinkFindingAnalysisBase)this.findings.getSecond(i);
            if (analyzer instanceof ThresholdFindingAnalysisBase) {
                String analyzerSimpleName = analyzer.getClass().getSimpleName();
                if (this.metricThresholds.containsKey(analyzerSimpleName)) {
                    ((ThresholdFindingAnalysisBase)analyzer).setThresholds(this.metricThresholds.get(analyzerSimpleName));
                } else {
                    LOGGER.warn("No metric thresholds given for " + analyzerSimpleName + ". Skipping this analysis.");
                    continue;
                }
            }
            try {
                analyzer.runAnalysis(uniformPath, model, findingsFound::add);
                continue;
            }
            catch (ConQATException e) {
                LOGGER.error("Findings calculation for " + (String)this.findings.getFirst(i) + " failed for model " + uniformPath + ": " + e.getMessage(), (Throwable)e);
            }
        }
        allFindings.add((Object)uniformPath, findingsFound);
    }
}

