/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.signal_type;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.teamscale.index.dependencies.simulink.DataDictionaryLoader;
import com.teamscale.index.simulink.signal_type.SimulinkDataTypeAnalyserInPlace;
import com.teamscale.index.simulink.signal_type.SimulinkDataTypeResolverFromInput;
import com.teamscale.index.simulink.signal_type.SimulinkDataTypeUpdater;
import com.teamscale.index.simulink.signal_type.SimulinkLibraryLoader;
import com.teamscale.index.simulink.signal_type.SimulinkTypeLink;
import com.teamscale.index.simulink.signal_type.SimulinkTypeLinkExtractor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

class SimulinkDataTypeResolver {
    private final SimulinkResolvedDataTypes resolvedDataTypes;
    private final SimulinkLibraryLoader libraryLoader;
    private final DataDictionaryLoader dictionaryLoader;
    private final SimulinkModel model;
    private final Map<String, SimulinkDataTypeResolver> resolvedDataTypesForEmbeddedModels;
    private final Map<String, String> resolvedOutPortDataTypes = new HashMap<String, String>();
    private final SimulinkDataTypeUpdater updater;
    private final ImmutableMultimap<SimulinkBlock, SimulinkTypeLink> typeLinks;

    public SimulinkDataTypeResolver(SimulinkModel model, SimulinkLibraryLoader libraryLoader, DataDictionaryLoader dictionaryLoader, SimulinkResolvedDataTypes resolvedDataTypes, Map<String, SimulinkDataTypeResolver> resolvedDataTypesForEmbeddedModels) throws StorageException {
        this.model = model;
        this.libraryLoader = libraryLoader;
        this.dictionaryLoader = dictionaryLoader;
        this.resolvedDataTypes = resolvedDataTypes;
        this.resolvedDataTypesForEmbeddedModels = resolvedDataTypesForEmbeddedModels;
        this.typeLinks = ImmutableMultimap.copyOf(new SimulinkTypeLinkExtractor((SimulinkBlock)model).extractInheritAutoTypeLinks());
        this.updater = new SimulinkDataTypeUpdater(resolvedDataTypes, (Multimap<SimulinkBlock, SimulinkTypeLink>)this.typeLinks, dictionaryLoader.getReferencedDataDictionariesSorted(model));
    }

    public Map<String, SimulinkResolvedDataTypes> resolveOutputDataTypes(SimulinkBlock rootBlock, Map<Pair<SimulinkBlock, String>, String> initialOutputDataTypes) throws StorageException {
        List<SimulinkDataDictionary> dictionaries = this.dictionaryLoader.getReferencedDataDictionariesSorted(this.model);
        new SimulinkDataTypeAnalyserInPlace(this.resolvedDataTypes, (Multimap<SimulinkBlock, SimulinkTypeLink>)this.typeLinks).resolveDataTypes(this.model, dictionaries);
        SimulinkDataTypeResolverFromInput inputAnalyser = new SimulinkDataTypeResolverFromInput(this.libraryLoader, this.dictionaryLoader, this.resolvedDataTypes, (Multimap<SimulinkBlock, SimulinkTypeLink>)this.typeLinks, this.resolvedDataTypesForEmbeddedModels, dictionaries);
        for (Map.Entry<Pair<SimulinkBlock, String>, String> inputDataType : initialOutputDataTypes.entrySet()) {
            SimulinkBlock block = (SimulinkBlock)inputDataType.getKey().getFirst();
            String index = (String)inputDataType.getKey().getSecond();
            String type = inputDataType.getValue();
            this.updater.updateInformation(block, index, type);
        }
        Map<String, SimulinkDataTypeResolver> dataTypes = inputAnalyser.resolveOutputDataTypesBelowBlock(this.model, rootBlock);
        this.resolvedDataTypesForEmbeddedModels.putAll(dataTypes);
        this.setResolvedOutPortDataTypes(rootBlock);
        return this.fetchResult();
    }

    public Map<String, String> getResolvedOutPortDataTypes() {
        return this.resolvedOutPortDataTypes;
    }

    public boolean hasUnresolvedInPortDataTypes(SimulinkBlock referencedBlock) {
        HashSet<String> inportIndexes = new HashSet<String>();
        for (SimulinkInPort inport : referencedBlock.getInPorts()) {
            inportIndexes.add(inport.getIndex());
        }
        for (SimulinkBlock inportBlock : SimulinkUtils.getAllInportPortBlocks((SimulinkBlock)referencedBlock)) {
            Set types = this.resolvedDataTypes.getInputDataTypes(inportBlock);
            if (types == null || types.stream().allMatch(type -> type.equals("Unknown") || type.equals("NOT_CONNECTED"))) {
                return true;
            }
            String portBlockIndex = inportBlock.getParameter("Port");
            inportIndexes.remove(portBlockIndex);
            if (!inportIndexes.isEmpty()) continue;
            return false;
        }
        return !inportIndexes.isEmpty();
    }

    private void setResolvedOutPortDataTypes(SimulinkBlock rootBlock) {
        for (SimulinkBlock block : rootBlock.getSubBlocks()) {
            if (!SimulinkUtils.isOutport((SimulinkBlock)block)) continue;
            String portNumber = block.getParameter("Port");
            this.resolvedOutPortDataTypes.put(portNumber, SimulinkDataTypeUtils.selectDataTypeWithLargestRange((Set)this.resolvedDataTypes.getResolvedDataTypesForAllOutports(block)));
            String typesOutPort = SimulinkDataTypeUtils.selectDataTypeWithLargestRange((Set)this.resolvedDataTypes.getResolvedDataTypesForAllOutports(block));
            this.updater.updateInformation(block.getParent(), portNumber, typesOutPort);
        }
    }

    private Map<String, SimulinkResolvedDataTypes> fetchResult() {
        HashMap<String, SimulinkResolvedDataTypes> results = new HashMap<String, SimulinkResolvedDataTypes>();
        results.put(this.model.getUniformPath(), this.resolvedDataTypes);
        this.resolvedDataTypesForEmbeddedModels.forEach((uniformPathChildren, analysis) -> results.put((String)uniformPathChildren, analysis.resolvedDataTypes));
        return results;
    }

    public SimulinkResolvedDataTypes getResolvedDataTypes() {
        return this.resolvedDataTypes;
    }
}

