/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.signal_type;

import com.google.common.collect.Multimap;
import com.teamscale.index.dependencies.simulink.DataDictionaryLoader;
import com.teamscale.index.simulink.signal_type.SimulinkDataTypeResolver;
import com.teamscale.index.simulink.signal_type.SimulinkDataTypeUpdater;
import com.teamscale.index.simulink.signal_type.SimulinkLibraryLoader;
import com.teamscale.index.simulink.signal_type.SimulinkNavigationUtils;
import com.teamscale.index.simulink.signal_type.SimulinkPropagationUtils;
import com.teamscale.index.simulink.signal_type.SimulinkTypeLink;
import eu.cqse.check.simulink.stateflow_data_typing.StateflowVariableTypeExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.EnumUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.builder.SimulinkBus;
import org.conqat.lib.simulink.builder.SimulinkBusElement;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowDeclContainerBase;
import org.conqat.lib.simulink.types.ENumericDataType;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkBusUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jspecify.annotations.NonNull;

class SimulinkDataTypeResolverFromInput {
    private static final String DEFAULT_DATA_TYPE = "double";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> BUS_OUTPUT_SUPPORTED_BLOCKS = Set.of("Assignment", "BusAssignment", "BusCreator", "BusSelector", "Constant", "DataStoreRead", "Delay", "Ground", "From", "FromFile", "SignalSpecification", "FromWorkspace", "FunctionCaller", "InitialCondition", "Inport", "Switch", "MATLABFcn", "MATLABSystem", "Memory", "Merge", "PermuteDimensions", "PreLookup", "RateTransition", "Reshape", "Selector", "SignalConversion", "SignalEditor", "SubSystem", "ManualSwitch", "UnitDelay", "Concatenate", "ZeroOrderHold");
    private final SimulinkLibraryLoader libraryLoader;
    private final DataDictionaryLoader dataDictionaryLoader;
    private final SimulinkDataTypeUpdater updater;
    private final Multimap<SimulinkBlock, SimulinkTypeLink> typeLinks;
    private final List<SimulinkDataDictionary> dictionaries;
    private final SimulinkResolvedDataTypes resolvedDataTypes;
    private final Set<SimulinkBlock> visitedBlocks = new HashSet<SimulinkBlock>();
    private final Map<String, SimulinkDataTypeResolver> resolvedDataTypesForEmbeddedModels;
    private final Map<String, String> signalNameToDataType = new HashMap<String, String>();

    public SimulinkDataTypeResolverFromInput(SimulinkLibraryLoader libraryLoader, DataDictionaryLoader dataDictionaryLoader, SimulinkResolvedDataTypes resolvedDataTypes, Multimap<SimulinkBlock, SimulinkTypeLink> typeLinks, Map<String, SimulinkDataTypeResolver> resolvedDataTypesForEmbeddedModels, List<SimulinkDataDictionary> dictionaries) {
        this.libraryLoader = libraryLoader;
        this.dataDictionaryLoader = dataDictionaryLoader;
        this.resolvedDataTypes = resolvedDataTypes;
        this.typeLinks = typeLinks;
        this.resolvedDataTypesForEmbeddedModels = resolvedDataTypesForEmbeddedModels;
        this.dictionaries = dictionaries;
        this.updater = new SimulinkDataTypeUpdater(resolvedDataTypes, typeLinks, dictionaries);
    }

    public Map<String, SimulinkDataTypeResolver> resolveOutputDataTypesBelowBlock(SimulinkModel model, SimulinkBlock rootBlock) throws StorageException {
        List blocks = SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)rootBlock, (boolean)true, (boolean)true);
        this.visitedBlocks.add((SimulinkBlock)model);
        this.resolveOutputDataTypes(blocks);
        this.setDefaultForUnresolvedInheritAuto(blocks);
        this.resolveOutputDataTypes(blocks);
        return this.resolvedDataTypesForEmbeddedModels;
    }

    private void resolveOutputDataTypes(List<SimulinkBlock> blocks) throws StorageException {
        do {
            LOGGER.debug("Start new loop");
            this.updater.setBlocksUpdated(false);
            this.resolveDataTypesFromInput(blocks);
            this.backpropagateOutputDataTypes(blocks);
            this.updateTypeLinks();
            this.visitedBlocks.clear();
        } while (this.updater.hasBeenUpdated());
    }

    private void updateTypeLinks() {
        for (SimulinkBlock block : this.typeLinks.keySet()) {
            if (!SimulinkUtils.isInport((SimulinkBlock)block) || this.resolvedDataTypes.getResolvedOutputDataTypesForBlock(block, "1") != null) continue;
            this.determineDataTypeFromSuccessors(block);
        }
    }

    private void backpropagateOutputDataTypes(List<SimulinkBlock> blocks) {
        for (SimulinkBlock block : blocks) {
            this.backpropagateOutputDataTypes(block);
        }
    }

    private void backpropagateOutputDataTypes(SimulinkBlock block) {
        Set dataTypes = this.resolvedDataTypes.getResolvedDataTypesForAllOutports(block);
        if (dataTypes.size() != 1) {
            return;
        }
        String dataType = dataTypes.stream().findFirst().orElse(null);
        for (SimulinkLine line : block.getInLines()) {
            String type;
            SimulinkOutPort srcPort = line.getSrcPort();
            if (srcPort == null || !SimulinkDataTypeUtils.isPortWithBackPropagation((SimulinkInPort)line.getDstPort()) || (type = this.resolvedDataTypes.getResolvedOutputDataTypesForBlock(srcPort.getBlock(), srcPort.getIndex())) != null || block.isOfType("SubSystem") || block.isOfType("Reference")) continue;
            this.updater.updateInformation(srcPort.getBlock(), srcPort.getIndex(), dataType);
        }
    }

    private void resolveDataTypesFromInput(List<SimulinkBlock> blocks) throws StorageException {
        for (SimulinkBlock block : blocks) {
            this.resolveDataTypesFromInput(block);
        }
    }

    private void resolveDataTypesFromInput(SimulinkBlock block) throws StorageException {
        if (!this.needsUpdate(block)) {
            return;
        }
        if (block.isOfType("SubSystem") && !SimulinkUtils.isSubsystemReferenceBlock((SimulinkBlock)block)) {
            return;
        }
        this.visitedBlocks.add(block);
        this.resolveDatatypeByBlockTypeOrInheritanceRule(block);
    }

    private void resolveDatatypeByBlockTypeOrInheritanceRule(SimulinkBlock block) throws StorageException {
        String dataType = SimulinkDataTypeUtils.getUnresolvedOutputDataType((SimulinkBlock)block);
        if (SimulinkUtils.referencesCustomLibrary((SimulinkBlock)block)) {
            LOGGER.debug("Resolve Input for {}", (Object)block);
            this.resolveDataTypesForLibrary(block);
        } else if (SimulinkUtils.isSubsystemReferenceBlock((SimulinkBlock)block)) {
            this.resolveDataTypesForSubsystemReferenceBlock(block);
        } else if ("BusCreator".equals(block.getType())) {
            this.resolveDataTypeForBusCreator(block, dataType);
        } else if (block.isOfType("BusSelector") && dataType == null) {
            this.determineDataTypeFromDataDictionaryBus(block);
        } else if (block.isOfType("S-Function")) {
            this.determineDataTypeFromStateflow(block);
        } else if (block.isOfType("Interpolation_n-D")) {
            int tableDataIndex = block.getInPorts().size();
            this.determineDataTypeFromInput(block, Integer.toString(tableDataIndex));
        } else if (dataType == null || "Inherit: Same as first input".equals(dataType) || "Inherit: Same as input".equals(dataType) || "Inherit: All ports same datatype".equals(dataType)) {
            this.determineDataTypeFromInput(block, "1");
        } else if ("Inherit: Same as second input".equals(dataType)) {
            this.determineDataTypeFromInput(block, "2");
        } else if ("Inherit: Inherit via internal rule".equals(dataType)) {
            this.determineDataTypeFromInternalRule(block);
        } else if ("Inherit: Inherit via back propagation".equals(dataType)) {
            this.determineDataTypeFromBackPropagation(block);
        } else if ("Inherit: Keep MSB".equals(dataType)) {
            this.determineDataTypeFromMSB(block);
        } else if ("Inherit: Keep LSB".equals(dataType)) {
            this.determineDataTypeFromLSB(block);
        } else if ("Inherit: Match scaling".equals(dataType)) {
            this.determineDataTypeMatchScaling(block);
        } else if (dataType.startsWith("Bus")) {
            this.updater.updateInformation(block, dataType);
        } else if (block.isOfType("Outport") && "Inherit: auto".equals(dataType)) {
            this.determineDataTypeFromInheritAutoOutPort(block);
        }
    }

    private void resolveDataTypeForBusCreator(SimulinkBlock block, String type) throws StorageException {
        if (type != null && type.startsWith("Bus: ")) {
            this.determineInputSignalsDataTypeFromDataDictionary(block, type);
            this.updater.updateInformation(block, type);
        } else {
            this.determineSignalDataTypeFromBusCreator(block);
            this.updater.updateInformation(block, "Bus");
        }
    }

    private void determineInputSignalsDataTypeFromDataDictionary(SimulinkBlock busCreatorBlock, String busType) {
        if (!busType.startsWith("Bus: ")) {
            return;
        }
        String busName = StringUtils.stripPrefix((String)busType, (String)"Bus: ");
        Optional potentialInputBus = SimulinkUtils.findDataDictionaryEntry(this.dictionaries, (String)busName, SimulinkBus.class);
        if (potentialInputBus.isEmpty()) {
            return;
        }
        for (SimulinkInPort inPort : busCreatorBlock.getInPorts()) {
            Optional optionalSignalName = inPort.getSignalName();
            if (optionalSignalName.isEmpty()) continue;
            SimulinkOutPort outPort = SimulinkUtils.getConnectedOutPort((SimulinkInPort)inPort);
            SimulinkBlock outBlock = SimulinkUtils.getConnectedBlock((SimulinkInPort)inPort);
            if (outPort == null || outBlock == null) continue;
            Optional busElement = SimulinkBusUtils.determineBusElement((String)((String)optionalSignalName.get()), (SimulinkBus)((SimulinkBus)potentialInputBus.get()), this.dictionaries);
            busElement.ifPresent(simulinkBusElement -> this.updater.updateInformation(outBlock, outPort.getIndex(), simulinkBusElement.getDataType()));
        }
    }

    private void determineSignalDataTypeFromBusCreator(SimulinkBlock block) throws StorageException {
        this.checkPredecessorPrecondition(block);
        for (SimulinkInPort inPort : block.getInPorts()) {
            Optional optionalSignalName = inPort.getSignalName();
            String signalName = "signal";
            String dataType = this.resolvedDataTypes.getInputDataType(block, inPort.getIndex());
            signalName = optionalSignalName.isEmpty() ? SimulinkDataTypeResolverFromInput.retrieveSignalNameFromOutBlockOrPort(inPort, signalName) : (String)optionalSignalName.get();
            this.signalNameToDataType.put(signalName, dataType);
        }
    }

    private static String retrieveSignalNameFromOutBlockOrPort(SimulinkInPort inPort, String defaultSignalName) {
        SimulinkOutPort outPort = SimulinkUtils.getConnectedOutPort((SimulinkInPort)inPort);
        SimulinkBlock outBlock = SimulinkUtils.getConnectedBlock((SimulinkInPort)inPort);
        if (outPort == null || outBlock == null) {
            return defaultSignalName;
        }
        if (outBlock.isOfType("SubSystem")) {
            List<SimulinkBlock> outPortBlocks = outBlock.getSubBlocks().stream().filter(blk -> blk.getType().equals("Outport")).toList();
            if (outPortBlocks.size() > 1) {
                outPortBlocks = outPortBlocks.stream().filter(blk -> Objects.equals(blk.getParameter("Port"), outPort.getIndex())).toList();
            }
            if (outPortBlocks.size() == 1) {
                return outPortBlocks.get(0).getName();
            }
        } else {
            return outBlock.getName();
        }
        return defaultSignalName;
    }

    private void determineDataTypeFromDataDictionaryBus(SimulinkBlock block) throws StorageException {
        this.checkPredecessorPrecondition(block);
        String inputDataType = this.resolvedDataTypes.getInputDataType(block, "1");
        if (inputDataType == null) {
            return;
        }
        List busElements = SimulinkBusUtils.determineAllBusElementsInOutputSignals((SimulinkBlock)block, (String)inputDataType, this.dictionaries);
        List outputSignalNames = SimulinkBusUtils.getOutputSignalNames((SimulinkBlock)block);
        if (busElements.isEmpty()) {
            this.updateDatatypeFromSignalMap(block, outputSignalNames);
        } else {
            String busName = StringUtils.stripPrefix((String)inputDataType, (String)"Bus: ");
            for (int i = 0; i < outputSignalNames.size(); ++i) {
                Optional busElement = (Optional)busElements.get(i);
                String portIndex = String.valueOf(i + 1);
                if (busElement.isPresent()) {
                    this.updater.updateInformation(block, portIndex, ((SimulinkBusElement)busElement.get()).getDataType());
                    continue;
                }
                this.updater.updateInformation(block, portIndex, "Unknown");
                String message = String.format("Found unknown bus element %s of bus %s in block %s in model %s. Signal data type information may be incomplete.", outputSignalNames.get(i), busName, block.buildQualifiedName(), block.getModel().getUniformPath());
                LOGGER.warn(message);
            }
        }
    }

    private void updateDatatypeFromSignalMap(SimulinkBlock block, List<String> busElementNames) {
        for (int i = 0; i < busElementNames.size(); ++i) {
            String portIndex = String.valueOf(i + 1);
            String busElementName = busElementNames.get(i);
            String dataType = this.signalNameToDataType.get(busElementName);
            this.updater.updateInformation(block, portIndex, Objects.requireNonNullElse(dataType, "Unknown"));
        }
    }

    private boolean needsUpdate(SimulinkBlock block) throws StorageException {
        block6: {
            block5: {
                if (this.visitedBlocks.contains(block)) {
                    return false;
                }
                if (block.getOutPorts().isEmpty()) {
                    return !this.resolvedDataTypes.contains(block);
                }
                if (!SimulinkUtils.referencesCustomLibrary((SimulinkBlock)block)) break block5;
                List<SimulinkModel> libraryModels = this.libraryLoader.loadLibraryFromReferenceBlock(block);
                for (SimulinkModel libraryModel : libraryModels) {
                    SimulinkBlock referencedLibraryBlock;
                    SimulinkDataTypeResolver typeResolver = this.resolvedDataTypesForEmbeddedModels.get(libraryModel.getUniformPath());
                    if (typeResolver == null || !typeResolver.hasUnresolvedInPortDataTypes(referencedLibraryBlock = SimulinkPropagationUtils.extractReferencedBlock(libraryModel, block.getSourceBlockName()))) continue;
                    return true;
                }
                break block6;
            }
            if (!SimulinkUtils.isSubsystemReferenceBlock((SimulinkBlock)block)) break block6;
            List<SimulinkModel> targetModels = this.libraryLoader.loadReferencedModelFromSubsystemReferenceBlock(block);
            for (SimulinkModel targetModel : targetModels) {
                SimulinkDataTypeResolver typeResolver = this.resolvedDataTypesForEmbeddedModels.get(targetModel.getUniformPath());
                if (typeResolver == null) {
                    return true;
                }
                if (!typeResolver.hasUnresolvedInPortDataTypes((SimulinkBlock)targetModel)) continue;
                return true;
            }
        }
        return !block.getOutPorts().stream().map(SimulinkPortBase::getIndex).allMatch(index -> this.resolvedDataTypes.contains(block, index));
    }

    private void resolveDataTypesForLibrary(SimulinkBlock referenceBlock) throws StorageException {
        this.checkPredecessorPrecondition(referenceBlock);
        List<SimulinkModel> libraryModels = this.libraryLoader.loadLibraryFromReferenceBlock(referenceBlock);
        if (libraryModels.isEmpty()) {
            LOGGER.debug("Empty model {}", (Object)referenceBlock);
            this.updater.updateInformation(referenceBlock, DEFAULT_DATA_TYPE);
            return;
        }
        for (SimulinkModel libraryModel : libraryModels) {
            SimulinkResolvedDataTypes alreadyResolvedDataTypes = this.getAlreadyResolvedDataTypes(libraryModel);
            SimulinkDataTypeResolver libraryDataTypeAnalyser = new SimulinkDataTypeResolver(libraryModel, this.libraryLoader, this.dataDictionaryLoader, alreadyResolvedDataTypes, this.resolvedDataTypesForEmbeddedModels);
            SimulinkBlock referencedLibraryBlock = SimulinkPropagationUtils.extractReferencedBlock(libraryModel, referenceBlock.getSourceBlockName());
            Map<Pair<SimulinkBlock, String>, String> inputDataTypes = this.createInputTypesMap(referenceBlock, referencedLibraryBlock);
            libraryDataTypeAnalyser.resolveOutputDataTypes(referencedLibraryBlock, inputDataTypes);
            this.fetchInformationFromOutPortsOfLibrary(referenceBlock, libraryDataTypeAnalyser);
            this.resolvedDataTypesForEmbeddedModels.put(libraryModel.getUniformPath(), libraryDataTypeAnalyser);
        }
    }

    private void resolveDataTypesForSubsystemReferenceBlock(SimulinkBlock subsystemReferenceBlock) throws StorageException {
        this.checkPredecessorPrecondition(subsystemReferenceBlock);
        List<SimulinkModel> targetModels = this.libraryLoader.loadReferencedModelFromSubsystemReferenceBlock(subsystemReferenceBlock);
        if (targetModels.isEmpty()) {
            LOGGER.debug("Unresolved subsystem reference {}", (Object)subsystemReferenceBlock);
            this.updater.updateInformation(subsystemReferenceBlock, DEFAULT_DATA_TYPE);
            return;
        }
        for (SimulinkModel targetModel : targetModels) {
            SimulinkResolvedDataTypes alreadyResolvedDataTypes = this.getAlreadyResolvedDataTypes(targetModel);
            SimulinkDataTypeResolver libraryDataTypeAnalyser = new SimulinkDataTypeResolver(targetModel, this.libraryLoader, this.dataDictionaryLoader, alreadyResolvedDataTypes, this.resolvedDataTypesForEmbeddedModels);
            Map<Pair<SimulinkBlock, String>, String> inputDataTypes = this.createInputTypesMap(subsystemReferenceBlock, (SimulinkBlock)targetModel);
            libraryDataTypeAnalyser.resolveOutputDataTypes((SimulinkBlock)targetModel, inputDataTypes);
            this.fetchInformationFromOutPortsOfLibrary(subsystemReferenceBlock, libraryDataTypeAnalyser);
            this.resolvedDataTypesForEmbeddedModels.put(targetModel.getUniformPath(), libraryDataTypeAnalyser);
        }
    }

    private Map<Pair<SimulinkBlock, String>, String> createInputTypesMap(SimulinkBlock referenceBlock, SimulinkBlock referencedLibrarySubsystem) {
        HashMap<Pair<SimulinkBlock, String>, String> inputDataTypes = new HashMap<Pair<SimulinkBlock, String>, String>();
        for (SimulinkBlock inportBlock : SimulinkUtils.getAllInportPortBlocks((SimulinkBlock)referencedLibrarySubsystem)) {
            String index = Objects.requireNonNullElse(inportBlock.getParameter("Port"), "1");
            String resolvedDataType = this.resolvedDataTypes.getInputDataType(referenceBlock, index);
            if (resolvedDataType == null) {
                inputDataTypes.put((Pair<SimulinkBlock, String>)Pair.createPair((Object)inportBlock, (Object)"1"), "Unknown");
                continue;
            }
            inputDataTypes.put((Pair<SimulinkBlock, String>)Pair.createPair((Object)inportBlock, (Object)"1"), resolvedDataType);
        }
        return inputDataTypes;
    }

    private SimulinkResolvedDataTypes getAlreadyResolvedDataTypes(SimulinkModel libraryModel) {
        SimulinkDataTypeResolver simulinkDataTypeResolver = this.resolvedDataTypesForEmbeddedModels.get(libraryModel.getUniformPath());
        if (simulinkDataTypeResolver == null) {
            return new SimulinkResolvedDataTypes();
        }
        return simulinkDataTypeResolver.getResolvedDataTypes();
    }

    private void fetchInformationFromOutPortsOfLibrary(SimulinkBlock libraryBlock, SimulinkDataTypeResolver libraryDataTypeAnalyser) {
        Map<String, String> outputDataTypesOfLibrary = libraryDataTypeAnalyser.getResolvedOutPortDataTypes();
        for (Map.Entry<String, String> entry : outputDataTypesOfLibrary.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.updater.updateInformation(libraryBlock, key, value);
        }
        LOGGER.debug("Updated for {} ({})", (Object)libraryBlock, (Object)this.updater.hasBeenUpdated());
    }

    private void determineDataTypeFromInput(SimulinkBlock block, String portIndex) throws StorageException {
        this.checkPredecessorPrecondition(block);
        Optional<SimulinkBlock> predecessor = SimulinkNavigationUtils.getPredecessorBlockFromInputPort(block, portIndex);
        String dataType = DEFAULT_DATA_TYPE;
        if (predecessor.isPresent()) {
            dataType = this.resolvedDataTypes.getInputDataType(block, portIndex);
        }
        if (dataType != null) {
            if (block.getOutPorts().isEmpty()) {
                this.updater.updateInformation(block, dataType);
                this.propagateTypeToPredecessor(block, dataType);
            }
            for (SimulinkOutPort port : block.getOutPorts()) {
                this.updater.updateInformation(block, port.getIndex(), dataType);
                this.propagateTypeToPredecessor(block, dataType);
            }
        }
    }

    private void determineDataTypeFromInternalRule(SimulinkBlock block) throws StorageException {
        this.checkPredecessorPrecondition(block);
        if (block.isOfType("Switch") || block.isOfType("MultiPortSwitch")) {
            this.processSwitchBlock(block);
            return;
        }
        if (block.isOfType("Find")) {
            this.updater.updateInformation(block, "Bus");
            return;
        }
        if (block.isOfType("PreLookup")) {
            this.processPrelookupBlock(block);
            return;
        }
        Set inputDataTypes = this.resolvedDataTypes.getInputDataTypes(block);
        if (inputDataTypes.isEmpty()) {
            return;
        }
        if (SimulinkDataTypeResolverFromInput.isBlockWithDiscreteBlockInternalRuleTypeResolution(block)) {
            if (inputDataTypes.contains("single")) {
                this.updater.updateInformation(block, "single");
            } else if (inputDataTypes.contains(DEFAULT_DATA_TYPE)) {
                this.updater.updateInformation(block, DEFAULT_DATA_TYPE);
            } else {
                this.updater.updateInformation(block, "fixdt");
            }
            return;
        }
        if (block.isOfType("MinMax")) {
            if (!inputDataTypes.isEmpty()) {
                this.updater.updateInformation(block, (String)CollectionUtils.getAny((Iterable)inputDataTypes));
            }
            return;
        }
        if (block.isOfType("Reference") && block.isOfSourceType("Difference")) {
            if (inputDataTypes.contains("boolean")) {
                this.updater.updateInformation(block, "uint8");
            } else if (!inputDataTypes.isEmpty()) {
                this.updater.updateInformation(block, (String)CollectionUtils.getAny((Iterable)inputDataTypes));
            }
            return;
        }
        if (this.setNonNumericDatatypeIfPresent(block, inputDataTypes)) {
            return;
        }
        if (this.determineDataTypeFromBlockSpecificRules(block, inputDataTypes)) {
            return;
        }
        LOGGER.warn("Simulink output data type " + MarkupUtils.formatAsSourceCode((String)"Inherit: Inherit via internal rule") + " is not supported for block type " + MarkupUtils.formatAsSourceCode((String)block.getType()) + " in Simulink Model " + block.getModel().getUniformPath());
    }

    private boolean determineDataTypeFromBlockSpecificRules(SimulinkBlock block, Set<String> inputDataTypes) {
        if (block.isOfType("Sqrt")) {
            String outputDataType = SimulinkDataTypeUtils.selectDataTypeWithLargestRange(inputDataTypes);
            this.updater.updateInformation(block, outputDataType);
            return true;
        }
        if (block.isOfType("Gain")) {
            Set integerDataTypes = SimulinkDataTypeUtils.createEIntegerDataTypeSet(inputDataTypes);
            if (integerDataTypes.isEmpty()) {
                return true;
            }
            String gainType = SimulinkDataTypeUtils.normalizeDataType((String)block.getParameter("ParamDataTypeStr"));
            if (!EnumUtils.isValidEnumIgnoreCase(ENumericDataType.class, (String)gainType)) {
                this.updater.updateInformation(block, "fixdt");
                return true;
            }
            integerDataTypes.add(ENumericDataType.valueOf((String)gainType.toUpperCase(Locale.ROOT)));
            inputDataTypes.add(gainType);
            String largestDataType = SimulinkDataTypeUtils.selectDataTypeWithLargestRange(inputDataTypes);
            Optional<String> nextLargerIntType = SimulinkDataTypeResolverFromInput.selectNextLargerIntTypeForGainBlock(largestDataType);
            if (nextLargerIntType.isPresent()) {
                this.updater.updateInformation(block, nextLargerIntType.get());
                return true;
            }
            ENumericDataType containingDataType = SimulinkDataTypeUtils.getContainingDataType((Set)integerDataTypes);
            this.updater.updateInformation(block, containingDataType.name().toLowerCase());
            return true;
        }
        if (block.isOfType("Product")) {
            this.updater.updateInformation(block, SimulinkDataTypeUtils.determineProductBlockOutputType(inputDataTypes));
            return true;
        }
        if (block.isOfType("Abs")) {
            this.processAbsBlock(block, inputDataTypes);
            return true;
        }
        if (block.isOfType("Sum")) {
            this.updater.updateInformation(block, SimulinkDataTypeUtils.determineSumBlockOutputType(inputDataTypes));
            return true;
        }
        return false;
    }

    private static Optional<String> selectNextLargerIntTypeForGainBlock(String largestDataType) {
        if ("int8".equals(largestDataType)) {
            return Optional.of("int16");
        }
        if ("uint8".equals(largestDataType)) {
            return Optional.of("uint16");
        }
        if ("int16".equals(largestDataType)) {
            return Optional.of("int32");
        }
        if ("uint16".equals(largestDataType)) {
            return Optional.of("uint32");
        }
        if ("int32".equals(largestDataType)) {
            return Optional.of("int32");
        }
        if ("uint32".equals(largestDataType)) {
            return Optional.of("uint64");
        }
        if ("int64".equals(largestDataType) || "uint64".equals(largestDataType)) {
            return Optional.of(largestDataType);
        }
        return Optional.empty();
    }

    private void processSwitchBlock(SimulinkBlock block) {
        String outputDataType = SimulinkDataTypeResolverFromInput.determineSwitchOutputTypeFromInputTypes(this.resolvedDataTypes.getInputDataTypes(block, SimulinkDataTypeUtils.getInputDataPortNumbers((SimulinkBlock)block)));
        if (block.isOfType("Switch")) {
            String port3Type = this.resolvedDataTypes.getInputDataType(block, "3");
            if ("uint8".equals(outputDataType) && "boolean".equals(port3Type)) {
                outputDataType = port3Type;
            }
        }
        this.updater.updateInformation(block, outputDataType);
    }

    public static @NonNull String determineSwitchOutputTypeFromInputTypes(Set<String> types) {
        if (types.isEmpty()) {
            return "NOT_CONNECTED";
        }
        if (types.contains("fixdt")) {
            return "fixdt";
        }
        if (types.contains("enum")) {
            return "enum";
        }
        Set busTypes = CollectionUtils.filterToSet(types, type -> type.startsWith("Bus"));
        if (!busTypes.isEmpty()) {
            if (busTypes.size() == 1) {
                return (String)busTypes.stream().findAny().get();
            }
            return "Bus";
        }
        if (types.contains(DEFAULT_DATA_TYPE)) {
            return DEFAULT_DATA_TYPE;
        }
        if (types.contains("Unknown")) {
            return "Unknown";
        }
        if (types.stream().allMatch(type -> type.equals("NOT_CONNECTED"))) {
            return "NOT_CONNECTED";
        }
        return types.stream().filter(type -> !type.equals("NOT_CONNECTED")).reduce((prevType, nextType) -> {
            if (SimulinkDataTypeUtils.compareRangeOfNumericDataTypes((String)prevType, (String)nextType) >= 0) {
                return prevType;
            }
            return nextType;
        }).orElse(DEFAULT_DATA_TYPE);
    }

    private void processPrelookupBlock(SimulinkBlock block) {
        String dataType = this.resolvedDataTypes.getInputDataType(block, "2");
        if (!StringUtils.isEmpty((String)dataType)) {
            this.updater.updateInformation(block, "2", dataType);
        }
    }

    private void processAbsBlock(SimulinkBlock block, Set<String> inputDataTypes) {
        if (inputDataTypes.contains("int8") || inputDataTypes.contains("uint8")) {
            this.updater.updateInformation(block, "uint8");
            this.propagateTypeToPredecessor(block, "uint8");
        } else if (inputDataTypes.contains("int16") || inputDataTypes.contains("uint16")) {
            this.updater.updateInformation(block, "uint16");
            this.propagateTypeToPredecessor(block, "uint16");
        } else if (inputDataTypes.contains("int32") || inputDataTypes.contains("uint32")) {
            this.updater.updateInformation(block, "uint32");
            this.propagateTypeToPredecessor(block, "uint32");
        } else if (inputDataTypes.contains("int64") || inputDataTypes.contains("uint64")) {
            this.updater.updateInformation(block, "uint64");
            this.propagateTypeToPredecessor(block, "uint64");
        } else {
            String outputDataType = SimulinkDataTypeUtils.selectDataTypeWithLargestRange(inputDataTypes);
            this.updater.updateInformation(block, outputDataType);
            this.propagateTypeToPredecessor(block, outputDataType);
        }
        LOGGER.warn("Simulink output data type " + MarkupUtils.formatAsSourceCode((String)"Inherit: Inherit via internal rule") + " is not supported for block type " + MarkupUtils.formatAsSourceCode((String)block.getType()) + " in Simulink Model " + block.getModel().getUniformPath());
    }

    private boolean setNonNumericDatatypeIfPresent(SimulinkBlock block, Set<String> inputDataTypes) {
        if (inputDataTypes.contains("Unknown")) {
            this.updater.updateInformation(block, "Unknown");
            return true;
        }
        if (inputDataTypes.stream().anyMatch(type -> type.startsWith("Bus"))) {
            if (BUS_OUTPUT_SUPPORTED_BLOCKS.contains(block.getType())) {
                this.updater.updateInformation(block, "Bus");
            } else {
                this.updater.updateInformation(block, DEFAULT_DATA_TYPE);
            }
            return true;
        }
        Optional possibleOutputDataType = SimulinkDataTypeUtils.selectFloatingPointDataTypeWithLargestRange(inputDataTypes);
        if (possibleOutputDataType.isPresent()) {
            this.updater.updateInformation(block, (String)possibleOutputDataType.get());
            return true;
        }
        if (SimulinkDataTypeUtils.containsFixedPointDataTypes(inputDataTypes)) {
            this.updater.updateInformation(block, "fixdt");
            return true;
        }
        return false;
    }

    public static boolean isBlockWithDiscreteBlockInternalRuleTypeResolution(SimulinkBlock block) {
        if (Set.of("DiscreteIntegrator", "DiscreteTransferFcn", "DiscreteFilter").contains(block.getType())) {
            return true;
        }
        if ("Reference".equals(block.getType())) {
            String sourceType = block.getSourceType();
            return "Discrete Derivative".equals(sourceType);
        }
        return false;
    }

    private void determineDataTypeFromBackPropagation(SimulinkBlock block) throws StorageException {
        this.checkSuccessorPrecondition(block);
        Set<SimulinkBlock> successorsWithBackPropagation = SimulinkNavigationUtils.getSuccessorsWithBackPropagation(block);
        if (successorsWithBackPropagation.isEmpty()) {
            this.determineDataTypeFromInternalRule(block);
        }
        HashSet possibleDataTypes = new HashSet();
        successorsWithBackPropagation.forEach(successor -> possibleDataTypes.addAll(this.resolvedDataTypes.getResolvedDataTypesForAllOutports(successor)));
        SimulinkNavigationUtils.getNonSubsystemSuccessorBlocks(block).forEach(successor -> {
            Set inputDataPortNumbers = SimulinkDataTypeUtils.getInputDataPortNumbers((SimulinkBlock)successor);
            possibleDataTypes.addAll(this.resolvedDataTypes.getInputDataTypes(successor, inputDataPortNumbers));
        });
        String resolvedDataType = SimulinkDataTypeUtils.selectDataTypeWithLargestRange(possibleDataTypes);
        this.updater.updateInformation(block, resolvedDataType);
    }

    private void determineDataTypeFromMSB(SimulinkBlock block) throws StorageException {
        boolean isBooleanOrInt8;
        this.checkPredecessorPrecondition(block);
        Set inputDataTypes = this.resolvedDataTypes.getInputDataTypes(block);
        if (this.setNonNumericDatatypeIfPresent(block, inputDataTypes)) {
            return;
        }
        String largestInputDataType = SimulinkDataTypeUtils.selectDataTypeWithLargestRange((Set)inputDataTypes);
        String resolvedDataType = SimulinkDataTypeUtils.isFloatingPointDataType((String)largestInputDataType) ? largestInputDataType : (inputDataTypes.size() == 1 ? SimulinkDataTypeUtils.getDataTypeWithLargerRange((String)largestInputDataType) : ((isBooleanOrInt8 = inputDataTypes.stream().allMatch(e -> e.equals("int8") || e.equals("boolean"))) ? "int16" : "fixdt"));
        this.updater.updateInformation(block, resolvedDataType);
    }

    private void determineDataTypeFromLSB(SimulinkBlock block) throws StorageException {
        boolean isBooleanOrInt8;
        this.checkPredecessorPrecondition(block);
        Set inputDataTypes = this.resolvedDataTypes.getInputDataTypes(block);
        if (this.setNonNumericDatatypeIfPresent(block, inputDataTypes)) {
            return;
        }
        String largestInputDataType = SimulinkDataTypeUtils.selectDataTypeWithLargestRange((Set)inputDataTypes);
        String resolvedDataType = SimulinkDataTypeUtils.isFloatingPointDataType((String)largestInputDataType) ? largestInputDataType : (inputDataTypes.size() == 1 ? SimulinkDataTypeUtils.getDataTypeWithLargerRange((String)largestInputDataType) : (inputDataTypes.stream().allMatch(s -> "uint8".equals(s) || "int8".equals(s)) ? "int8" : (inputDataTypes.stream().allMatch(s -> "uint16".equals(s) || "int16".equals(s)) ? "int16" : (inputDataTypes.stream().allMatch(s -> "uint32".equals(s) || "int32".equals(s)) ? "int32" : (inputDataTypes.stream().allMatch(s -> "uint64".equals(s) || "int64".equals(s)) ? "int64" : ((isBooleanOrInt8 = inputDataTypes.stream().allMatch(e -> e.equals("int8") || e.equals("boolean"))) ? "int16" : "fixdt"))))));
        this.updater.updateInformation(block, resolvedDataType);
    }

    private void determineDataTypeMatchScaling(SimulinkBlock block) throws StorageException {
        this.checkPredecessorPrecondition(block);
        Set inputDataTypes = this.resolvedDataTypes.getInputDataTypes(block);
        if (this.setNonNumericDatatypeIfPresent(block, inputDataTypes)) {
            return;
        }
        String largestInputDataType = SimulinkDataTypeUtils.selectDataTypeWithLargestRange((Set)inputDataTypes);
        String resolvedDataType = SimulinkDataTypeUtils.isFloatingPointDataType((String)largestInputDataType) ? largestInputDataType : "fixdt";
        this.updater.updateInformation(block, resolvedDataType);
    }

    private void determineDataTypeFromInheritAutoOutPort(SimulinkBlock block) {
        Set inputDataTypes = this.resolvedDataTypes.getInputDataTypes(block);
        if (inputDataTypes.size() != 1) {
            return;
        }
        this.updater.updateInformation(block, (String)inputDataTypes.stream().findFirst().get());
    }

    private void setDefaultForUnresolvedInheritAuto(List<SimulinkBlock> blocks) {
        for (SimulinkBlock block : blocks) {
            if (!SimulinkDataTypeUtils.usesInheritAuto((SimulinkBlock)block) || !this.resolvedDataTypes.getResolvedDataTypesForAllOutports(block).isEmpty()) continue;
            this.updater.updateInformation(block, DEFAULT_DATA_TYPE);
        }
    }

    private void determineDataTypeFromSuccessors(SimulinkBlock block) {
        if (SimulinkNavigationUtils.getNonSubsystemSuccessorBlocks(block).isEmpty()) {
            this.updater.updateInformation(block, DEFAULT_DATA_TYPE);
            return;
        }
        HashSet possibleDataTypes = new HashSet();
        for (SimulinkBlock successor : SimulinkNavigationUtils.getSuccessorsWithBackPropagation(block)) {
            Set types = this.resolvedDataTypes.getResolvedDataTypesForAllOutports(successor);
            if (types.isEmpty()) {
                return;
            }
            possibleDataTypes.addAll(types);
        }
        if (!possibleDataTypes.isEmpty()) {
            String resolvedDataType = SimulinkDataTypeUtils.selectDataTypeWithLargestRange(possibleDataTypes);
            this.updater.updateInformation(block, resolvedDataType);
            this.propagateTypeToPredecessor(block, resolvedDataType);
        }
    }

    private void checkPredecessorPrecondition(SimulinkBlock block) throws StorageException {
        List<SimulinkBlock> predecessors = SimulinkNavigationUtils.getPredecessorAndSiblingsBlocks(block);
        for (SimulinkBlock predecessor : predecessors) {
            LOGGER.debug("Predecessor {} of block {} gets analyzed", (Object)predecessor, (Object)block);
            if (predecessor == null || !this.resolvedDataTypes.getResolvedDataTypesForAllOutports(predecessor).isEmpty()) continue;
            this.resolveDataTypesFromInput(predecessor);
        }
    }

    private void checkSuccessorPrecondition(SimulinkBlock block) throws StorageException {
        List<SimulinkBlock> successors = SimulinkNavigationUtils.getNonSubsystemSuccessorBlocks(block);
        for (SimulinkBlock successor : successors) {
            LOGGER.debug("Successor {} of block {} gets analyzed", (Object)successor, (Object)block);
            if (successor == null || !this.resolvedDataTypes.getResolvedDataTypesForAllOutports(successor).isEmpty()) continue;
            this.resolveDataTypesFromInput(successor);
        }
    }

    private void propagateTypeToPredecessor(SimulinkBlock block, String dataType) {
        ArrayList<SimulinkBlock> blocksToUpdate = new ArrayList<SimulinkBlock>();
        if (SimulinkUtils.isInport((SimulinkBlock)block)) {
            String port = block.getParameter("Port");
            Optional<SimulinkBlock> parentPredecessor = SimulinkNavigationUtils.getPredecessorBlockFromInputPort(block.getParent(), port);
            parentPredecessor.ifPresent(blocksToUpdate::add);
        } else {
            blocksToUpdate.addAll(SimulinkNavigationUtils.getResolvablePredecessors(block));
        }
        for (SimulinkBlock predecessor : blocksToUpdate) {
            if (!SimulinkDataTypeUtils.usesInheritAuto((SimulinkBlock)predecessor)) continue;
            Set currentDataTypes = this.resolvedDataTypes.getResolvedDataTypesForAllOutports(predecessor);
            currentDataTypes.add(dataType);
            String newDatatype = SimulinkDataTypeUtils.selectDataTypeWithLargestRange((Set)currentDataTypes);
            this.updater.updateInformation(predecessor, newDatatype);
        }
    }

    private void determineDataTypeFromStateflow(SimulinkBlock block) {
        if (!(block.getParent() instanceof StateflowBlock)) {
            String message = String.format("Found S-Function block %s with SID %s in model %s which is not inside a Stateflow Block.", block.getName(), block.getParameter("SID"), block.getModel().getUniformPath());
            LOGGER.warn(message);
            return;
        }
        StateflowChart stateflowBlock = ((StateflowBlock)block.getParent()).getChart();
        StateflowVariableTypeExtractor extractor = new StateflowVariableTypeExtractor(this.resolvedDataTypes);
        for (SimulinkOutPort outPort : block.getOutPorts()) {
            String stateflowType;
            String portName = outPort.getParameter("Name");
            if (portName == null || portName.isEmpty() || (stateflowType = extractor.determineType(portName, (StateflowDeclContainerBase)stateflowBlock)) == null) continue;
            String realStateflowType = SimulinkDataTypeUtils.getRealDataTypeOfFixedDataType((String)stateflowType, (boolean)false);
            if (realStateflowType.startsWith("fixdt")) {
                this.updater.updateInformation(block, outPort.getIndex(), "fixdt");
                continue;
            }
            if (realStateflowType.startsWith("enum")) {
                this.updater.updateInformation(block, outPort.getIndex(), "enum");
                continue;
            }
            if (!EnumUtils.isValidEnum(ENumericDataType.class, (String)realStateflowType.toUpperCase(Locale.ROOT)) && !realStateflowType.startsWith("Bus") && !realStateflowType.equals("Unknown") && !realStateflowType.equals("NOT_CONNECTED")) continue;
            this.updater.updateInformation(block, outPort.getIndex(), realStateflowType);
        }
    }
}

