/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.signal_type.signal_labels;

import com.google.common.collect.Multimap;
import com.teamscale.index.simulink.signal_type.SimulinkLibraryLoader;
import com.teamscale.index.simulink.signal_type.SimulinkPropagationUtils;
import com.teamscale.index.simulink.signal_type.SimulinkTypeLink;
import com.teamscale.index.simulink.signal_type.SimulinkTypeLinkExtractor;
import com.teamscale.index.simulink.signal_type.signal_labels.SimulinkSignalLabelResolverFromInput;
import com.teamscale.index.simulink.signal_type.signal_labels.SimulinkSignalLabelUpdater;
import java.util.HashMap;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkPropagatedSignalLabels;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

public class SimulinkSignalLabelResolver {
    private final @NonNull SimulinkPropagatedSignalLabels propagatedSignalLabels;
    private final SimulinkLibraryLoader libraryLoader;
    private final SimulinkModel model;
    private final Map<String, SimulinkSignalLabelResolver> signalLabelsForEmbeddedModels;
    private final Map<String, String> resolvedInportSignalLabels = new HashMap<String, String>();
    private final @NonNull SimulinkBlock referencedBlock;
    private final Map<String, String> resolvedOutPortSignalLabels = new HashMap<String, String>();
    private final SimulinkSignalLabelUpdater updater;
    private final Multimap<SimulinkBlock, SimulinkTypeLink> typeLinks;

    @VisibleForTesting
    public SimulinkSignalLabelResolver(SimulinkModel model, SimulinkLibraryLoader libraryLoader) {
        this(model, libraryLoader, new SimulinkPropagatedSignalLabels(), new HashMap<String, SimulinkSignalLabelResolver>());
    }

    public SimulinkSignalLabelResolver(SimulinkModel model, SimulinkLibraryLoader libraryLoader, @NonNull SimulinkPropagatedSignalLabels propagatedSignalLabels) {
        this(model, libraryLoader, propagatedSignalLabels, new HashMap<String, SimulinkSignalLabelResolver>());
    }

    public SimulinkSignalLabelResolver(SimulinkModel model, SimulinkLibraryLoader libraryLoader, @NonNull SimulinkPropagatedSignalLabels propagatedSignalLabels, Map<String, SimulinkSignalLabelResolver> signalLabelsForEmbeddedModels) {
        this(model, libraryLoader, propagatedSignalLabels, signalLabelsForEmbeddedModels, SimulinkPropagationUtils.extractReferencedBlock(model, null));
    }

    public SimulinkSignalLabelResolver(SimulinkModel model, SimulinkLibraryLoader libraryLoader, @NonNull SimulinkPropagatedSignalLabels propagatedSignalLabels, Map<String, SimulinkSignalLabelResolver> signalLabelsForEmbeddedModels, @NonNull SimulinkBlock analysisRootBlock) {
        this.model = model;
        this.libraryLoader = libraryLoader;
        this.propagatedSignalLabels = propagatedSignalLabels;
        this.signalLabelsForEmbeddedModels = signalLabelsForEmbeddedModels;
        this.referencedBlock = analysisRootBlock;
        this.typeLinks = new SimulinkTypeLinkExtractor(this.referencedBlock).extractSignalLabelTypeLinks();
        this.updater = new SimulinkSignalLabelUpdater(propagatedSignalLabels, this.typeLinks);
    }

    public Map<String, SimulinkPropagatedSignalLabels> resolveSignalLabels() throws StorageException {
        SimulinkSignalLabelResolverFromInput inputAnalyser = new SimulinkSignalLabelResolverFromInput(this.libraryLoader, this.propagatedSignalLabels, this.typeLinks, this.signalLabelsForEmbeddedModels);
        this.initializeInPortSignalLabels();
        inputAnalyser.resolveSignalLabels(this.model);
        this.setResolvedOutPortSignalLabels();
        return this.fetchResult();
    }

    private void initializeInPortSignalLabels() {
        if (this.resolvedInportSignalLabels.isEmpty()) {
            return;
        }
        for (SimulinkBlock subBlock : this.referencedBlock.getSubBlocks()) {
            String port;
            if (!SimulinkUtils.isInport((SimulinkBlock)subBlock) || !this.resolvedInportSignalLabels.containsKey(port = subBlock.getParameter("Port"))) continue;
            this.updater.updateInformation(subBlock, this.resolvedInportSignalLabels.get(port));
        }
    }

    private void setResolvedOutPortSignalLabels() {
        for (SimulinkBlock block : this.referencedBlock.getSubBlocks()) {
            if (!SimulinkUtils.isOutport((SimulinkBlock)block)) continue;
            String portNumber = block.getParameter("Port");
            String signalLabel = this.propagatedSignalLabels.getPropagatedOutputSignalLabelsForBlock(block, portNumber);
            this.resolvedOutPortSignalLabels.put(portNumber, signalLabel);
            this.updater.updateInformation(block.getParent(), portNumber, signalLabel);
        }
    }

    public Map<String, String> getResolvedOutPortSignalLabels() {
        return this.resolvedOutPortSignalLabels;
    }

    public void addResolvedInportSignalLabels(String portIndex, String resolvedSignalLabel) {
        this.resolvedInportSignalLabels.put(portIndex, resolvedSignalLabel);
    }

    private Map<String, SimulinkPropagatedSignalLabels> fetchResult() {
        HashMap<String, SimulinkPropagatedSignalLabels> results = new HashMap<String, SimulinkPropagatedSignalLabels>();
        results.put(this.model.getUniformPath(), this.propagatedSignalLabels);
        this.signalLabelsForEmbeddedModels.forEach((uniformPathChildren, analysis) -> results.put((String)uniformPathChildren, analysis.propagatedSignalLabels));
        return results;
    }

    public @NonNull SimulinkPropagatedSignalLabels getPropagatedSignalLabels() {
        return this.propagatedSignalLabels;
    }
}

