/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.stacktrace.parser.state.cs;

import com.teamscale.index.stacktrace.component.Location;
import com.teamscale.index.stacktrace.component.StackFrame;
import com.teamscale.index.stacktrace.component.Stacktrace;
import com.teamscale.index.stacktrace.parser.IStacktraceParserState;
import com.teamscale.index.stacktrace.parser.state.cs.CsFoundAtLeastOneStackFrameState;
import com.teamscale.index.stacktrace.tokenizer.EStacktraceTokenType;
import com.teamscale.index.stacktrace.tokenizer.token.IStacktraceToken;
import com.teamscale.index.stacktrace.tokenizer.token.cs.CsStackFrameToken;
import java.util.EnumSet;

public class CsWaitingForStackFrameState
implements IStacktraceParserState {
    @Override
    public EnumSet<EStacktraceTokenType> getValidTokenTypes() {
        return EnumSet.of(EStacktraceTokenType.CS_STACK_FRAME);
    }

    @Override
    public void handleToken(Stacktrace stacktrace, IStacktraceToken token) {
        switch (token.getTokenType()) {
            case CS_STACK_FRAME: {
                CsStackFrameToken stackFrameToken = (CsStackFrameToken)token;
                stacktrace.getLastException().add(StackFrame.withLocation(stackFrameToken.getClassName(), stackFrameToken.getMethodName(), new Location(stackFrameToken.getFileName(), stackFrameToken.getLineNumber())));
                break;
            }
        }
    }

    @Override
    public IStacktraceParserState getNextState(IStacktraceToken token) {
        switch (token.getTokenType()) {
            case CS_STACK_FRAME: {
                return new CsFoundAtLeastOneStackFrameState();
            }
        }
        return null;
    }
}

