/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.task.CodeSnippet;
import com.teamscale.index.task.ETaskResolution;
import com.teamscale.index.task.ETaskStatus;
import com.teamscale.index.task.FindingIdWithBranch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class Task
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String ID_PROPERTY = "id";
    protected static final String SUBJECT_PROPERTY = "subject";
    protected static final String AUTHOR_PROPERTY = "author";
    protected static final String DESCRIPTION_PROPERTY = "description";
    protected static final String ASSIGNEE_PROPERTY = "assignee";
    protected static final String CREATED_PROPERTY = "created";
    protected static final String UPDATED_PROPERTY = "updated";
    protected static final String STATUS_PROPERTY = "status";
    protected static final String RESOLUTION_PROPERTY = "resolution";
    protected static final String FINDINGS_PROPERTY = "findings";
    protected static final String TAGS_PROPERTY = "tags";
    protected static final String LAST_STATUS_UPDATE_PROPERTY = "lastStatusUpdate";
    private static final String UPDATED_BY_PROPERTY = "updatedBy";
    protected static final String CODE_SNIPPETS_PROPERTY = "codeSnippets";
    @JsonProperty(value="id")
    private int id;
    @JsonProperty(value="subject")
    private final String subject;
    @JsonProperty(value="author")
    private @Nullable String author;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="assignee")
    private final @Nullable String assignee;
    @JsonProperty(value="created")
    private long created;
    @JsonProperty(value="updated")
    private long updated;
    @JsonProperty(value="lastStatusUpdate")
    private long lastStatusUpdate;
    @JsonProperty(value="updatedBy")
    private @Nullable String updatedBy;
    @JsonProperty(value="status")
    private @Nullable ETaskStatus status;
    @JsonProperty(value="resolution")
    private @Nullable ETaskResolution resolution;
    @JsonProperty(value="findings")
    private @Nullable List<FindingIdWithBranch> findings;
    @JsonProperty(value="comments")
    private @Nullable List<Comment> comments;
    @JsonProperty(value="tags")
    private @Nullable List<String> tags;
    @JsonProperty(value="codeSnippets")
    private @Nullable List<CodeSnippet> codeSnippets;

    public Task(Task task) {
        this.id = task.id;
        this.subject = task.subject;
        this.author = task.author;
        this.description = task.description;
        this.assignee = task.assignee;
        this.created = task.created;
        this.updated = task.updated;
        this.lastStatusUpdate = task.lastStatusUpdate;
        this.status = task.status;
        this.resolution = task.resolution;
        this.updatedBy = task.updatedBy;
        this.findings = Optional.ofNullable(task.findings).orElse(new ArrayList());
        this.tags = Optional.ofNullable(task.tags).orElse(new ArrayList());
        this.comments = Optional.ofNullable(task.comments).orElse(new ArrayList());
        this.codeSnippets = Optional.ofNullable(task.codeSnippets).orElse(new ArrayList());
    }

    @JsonCreator
    public Task(@JsonProperty(value="id") int id, @JsonProperty(value="subject") String subject, @JsonProperty(value="author") String author, @JsonProperty(value="description") String description, @JsonProperty(value="assignee") String assignee, @JsonProperty(value="created") Long created, @JsonProperty(value="updated") Long updated, @JsonProperty(value="status") ETaskStatus status, @JsonProperty(value="resolution") ETaskResolution resolution, @JsonProperty(value="findings") Collection<FindingIdWithBranch> findings, @JsonProperty(value="tags") Collection<String> tags, @JsonProperty(value="lastStatusUpdate") Long lastStatusUpdate, @JsonProperty(value="codeSnippets") Collection<CodeSnippet> codeSnippets) {
        this.id = id;
        this.subject = subject;
        this.author = author;
        this.description = description;
        this.assignee = assignee;
        if (lastStatusUpdate != null) {
            this.lastStatusUpdate = lastStatusUpdate;
        }
        if (created != null) {
            this.created = created;
        }
        if (updated != null) {
            this.updated = updated;
        }
        this.status = status;
        this.resolution = resolution;
        this.findings = new ArrayList<FindingIdWithBranch>();
        if (findings != null) {
            this.findings = new ArrayList<FindingIdWithBranch>(findings);
        }
        this.tags = new ArrayList<String>();
        if (tags != null) {
            this.tags = new ArrayList<String>(tags);
        }
        this.codeSnippets = new ArrayList<CodeSnippet>();
        if (codeSnippets != null) {
            this.codeSnippets = new ArrayList<CodeSnippet>(codeSnippets);
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public ETaskStatus getStatus() {
        return this.status;
    }

    public ETaskResolution getResolution() {
        return this.resolution;
    }

    public void setResolution(ETaskResolution resolution) {
        this.resolution = resolution;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public long getCreated() {
        return this.created;
    }

    public long getUpdated() {
        return this.updated;
    }

    public void setUpdated(long updated) {
        this.updated = updated;
    }

    public long getLastStatusUpdate() {
        return this.lastStatusUpdate;
    }

    public void setLastStatusUpdate(long lastStatusUpdate) {
        this.lastStatusUpdate = lastStatusUpdate;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setUpdatedBy(String author) {
        this.updatedBy = author;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setStatus(ETaskStatus status) {
        this.status = status;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setFindings(List<FindingIdWithBranch> findings) {
        this.findings = findings == null ? null : new ArrayList<FindingIdWithBranch>(new HashSet<FindingIdWithBranch>(findings));
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public List<Comment> getComments() {
        if (this.comments == null) {
            return Collections.emptyList();
        }
        return CollectionUtils.asUnmodifiable(this.comments);
    }

    public List<FindingIdWithBranch> getFindings() {
        if (this.findings == null) {
            return Collections.emptyList();
        }
        return CollectionUtils.asUnmodifiable(this.findings);
    }

    public List<String> getFindingIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (FindingIdWithBranch findingIdWithBranch : this.getFindings()) {
            result.add(findingIdWithBranch.getFindingId());
        }
        return result;
    }

    public List<String> getTags() {
        if (this.tags == null) {
            return Collections.emptyList();
        }
        return CollectionUtils.asUnmodifiable(this.tags);
    }

    public Comment addComment(String author, long date, String text, boolean changeComment) {
        Comment comment = new Comment(author, date, text, changeComment);
        if (this.comments == null) {
            this.comments = new ArrayList<Comment>();
        }
        this.comments.add(comment);
        this.setUpdatedBy(author);
        this.setUpdated(date);
        return comment;
    }

    public List<CodeSnippet> getCodeSnippets() {
        if (this.codeSnippets == null) {
            return CollectionUtils.emptyList();
        }
        return this.codeSnippets;
    }

    @IndexValueClass(containedInBackup=true)
    public static class Comment
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String AUTHOR_PROPERTY = "author";
        private static final String DATE_PROPERTY = "date";
        private static final String TEXT_PROPERTY = "text";
        private static final String CHANGE_COMMENT_PROPERTY = "changeComment";
        @JsonProperty(value="author")
        String author;
        @JsonProperty(value="date")
        long date;
        @JsonProperty(value="text")
        private final String text;
        @JsonProperty(value="changeComment")
        private final boolean changeComment;

        public Comment(Comment comment) {
            this.author = comment.author;
            this.date = comment.date;
            this.text = comment.text;
            this.changeComment = comment.changeComment;
        }

        @JsonCreator
        public Comment(@JsonProperty(value="author") String author, @JsonProperty(value="date") long date, @JsonProperty(value="text") String text, @JsonProperty(value="changeComment") boolean changeComment) {
            this.author = author;
            this.date = date;
            this.text = text;
            this.changeComment = changeComment;
        }

        public String getAuthor() {
            return this.author;
        }
    }
}

