/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.task;

import com.teamscale.index.task.Task;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;

public class TaskDiff {
    private final Task updatedTask;
    private final Task previousTask;
    private final UnmodifiableMap<String, TrackedFinding> addedTaskFindings;
    private final UnmodifiableMap<String, TrackedFinding> removedTaskFindings;

    public TaskDiff(Task updatedTask, Task previousTask, Collection<TrackedFinding> taskFindings, Collection<TrackedFinding> existingTaskFindings) {
        this.updatedTask = updatedTask;
        this.previousTask = previousTask;
        Map<String, TrackedFinding> taskFindingsMap = TaskDiff.convertTrackedFindingCollectionToMap(taskFindings);
        Map<String, TrackedFinding> existingTaskFindingsMap = TaskDiff.convertTrackedFindingCollectionToMap(existingTaskFindings);
        this.addedTaskFindings = CollectionUtils.asUnmodifiable(TaskDiff.calculateFindingsDiff(taskFindingsMap, existingTaskFindingsMap));
        this.removedTaskFindings = CollectionUtils.asUnmodifiable(TaskDiff.calculateFindingsDiff(existingTaskFindingsMap, taskFindingsMap));
    }

    public Task getUpdatedTask() {
        return this.updatedTask;
    }

    public Task getPreviousTask() {
        return this.previousTask;
    }

    public UnmodifiableMap<String, TrackedFinding> getAddedTaskFindings() {
        return this.addedTaskFindings;
    }

    public UnmodifiableMap<String, TrackedFinding> getRemovedTaskFindings() {
        return this.removedTaskFindings;
    }

    private static Map<String, TrackedFinding> convertTrackedFindingCollectionToMap(Collection<TrackedFinding> trackedFindings) {
        return trackedFindings.stream().collect(Collectors.toMap(TrackedFinding::getId, trackedFinding -> trackedFinding, (finding, duplicateFinding) -> finding));
    }

    private static Map<String, TrackedFinding> calculateFindingsDiff(Map<String, TrackedFinding> firstFindingsMap, Map<String, TrackedFinding> secondFindingsMap) {
        HashMap<String, TrackedFinding> difference = new HashMap<String, TrackedFinding>();
        firstFindingsMap.forEach((id, trackedFinding) -> {
            if (!secondFindingsMap.containsKey(id)) {
                difference.put((String)id, (TrackedFinding)trackedFinding);
            }
        });
        return difference;
    }
}

