/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testcoverage;

import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.TokenElementLineInfoBuilder;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.preprocessor.c.CPreprocessor;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageGroups;
import eu.cqse.check.framework.shallowparser.SubTypeNames;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.CommonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.sourcecode.coverage.volume.CodeBranch;
import org.conqat.engine.sourcecode.coverage.volume.ConditionalStatementSubtypes;
import org.conqat.engine.sourcecode.coverage.volume.condition.Condition;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionParserFactory;
import org.conqat.engine.sourcecode.coverage.volume.condition.IConditionExtractor;
import org.conqat.engine.sourcecode.coverage.volume.condition.SubConditionParserBase;
import org.conqat.engine.sourcecode.shallowparser.preprocessor.ctc.BranchBasedCtcSkipPragmaFilter;
import org.conqat.engine.sourcecode.shallowparser.preprocessor.lcov.LcovExclusionFilter;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class CoverableBranchAnalyzer {
    private static final Logger LOGGER = LogManager.getLogger();

    public static CoverableBranchInfo extractBranchInfo(TokenElementInfo tokenElement) throws ConQATException {
        ELanguage language = tokenElement.getLanguage();
        CCSMAssert.isTrue((ConditionalStatementSubtypes.supportsLanguageForBranchCoverage((ELanguage)language) && ConditionParserFactory.supportsLanguage((ELanguage)language) ? 1 : 0) != 0, (String)("Language " + tokenElement.getLanguage().getReadableName() + " not supported. Element: " + tokenElement.getUniformPath()));
        List<CodeBranch> branches = CoverableBranchAnalyzer.determineAndFilterBranches(tokenElement.getUniformPath(), TokenElementLineInfoBuilder.getShallowEntitiesForLineCoverageCorrection(tokenElement), language, tokenElement.getPreprocessedTokens());
        return new CoverableBranchInfo(branches.size(), branches);
    }

    static List<CodeBranch> determineAndFilterBranches(String uniformPath, List<ShallowEntity> entities, ELanguage language, List<IToken> tokens) {
        IConditionExtractor conditionExtractor = ConditionParserFactory.createConditionExtractor((ELanguage)language);
        SubConditionParserBase subConditionParser = ConditionParserFactory.createSubConditionParser((ELanguage)language);
        List<CodeBranch> branches = CoverableBranchAnalyzer.determineBranches(uniformPath, language, entities, conditionExtractor, subConditionParser);
        return CoverableBranchAnalyzer.filterBranches(language, entities, branches, tokens);
    }

    private static List<CodeBranch> filterBranches(ELanguage language, List<ShallowEntity> entities, List<CodeBranch> branches, List<IToken> tokens) {
        if (LanguageGroups.C_CPP_AND_MS_CLI.contains(language)) {
            BranchBasedCtcSkipPragmaFilter ctcFilter = new BranchBasedCtcSkipPragmaFilter(branches);
            ShallowEntityTraversalUtils.selectEntities(entities, (Predicate)ctcFilter);
            Set retainedCtcBranches = ctcFilter.getRetainedCodeBranches();
            Set retainedLcovBranches = LcovExclusionFilter.computeRetainedCodeBranches(tokens, branches);
            return new ArrayList<CodeBranch>(CollectionUtils.intersectionSet((Collection)retainedCtcBranches, (Collection[])new Collection[]{retainedLcovBranches}));
        }
        return branches;
    }

    private static List<CodeBranch> determineBranches(String uniformPath, ELanguage language, List<ShallowEntity> entities, IConditionExtractor conditionExtractor, SubConditionParserBase subConditionParser) {
        ArrayList<CodeBranch> result = new ArrayList<CodeBranch>();
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType(entities, (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            List methodStatements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)method.getChildren(), (EShallowEntityType)EShallowEntityType.STATEMENT);
            if (!methodStatements.isEmpty() || CoverableBranchAnalyzer.isCppConstructorWithInitializerList(language, method)) {
                result.add(new CodeBranch(method));
            }
            for (ShallowEntity statementEntity : methodStatements) {
                try {
                    CoverableBranchAnalyzer.addBranchesFromStatement(statementEntity, result, conditionExtractor, subConditionParser);
                }
                catch (ConQATException e) {
                    LOGGER.warn(String.format("Coverable branch determination failed for an entity in [%s]. [Skipping entity: %s]", uniformPath, statementEntity), (Throwable)e);
                }
            }
        }
        return result;
    }

    private static boolean isCppConstructorWithInitializerList(ELanguage language, ShallowEntity method) {
        return ShallowParsingUtils.isCppConstructor((ELanguage)language, (ShallowEntity)method) && TokenStreamUtils.firstTokenMatching((List)method.ownStartTokens(), (ITokenMatcher)ETokenType.COLON) != -1;
    }

    private static boolean isExitWhen(ShallowEntity entity) {
        return TokenStreamUtils.startsWith((List)entity.includedTokens(), (ETokenType[])new ETokenType[]{ETokenType.EXIT, ETokenType.WHEN});
    }

    private static void addBranchesFromStatement(ShallowEntity statementEntity, List<CodeBranch> branches, IConditionExtractor conditionExtractor, SubConditionParserBase subConditionParser) throws ConQATException {
        if (statementEntity.isEmpty() || statementEntity.ownStartTokens().stream().anyMatch(CPreprocessor.IS_MACRO_TOKEN)) {
            return;
        }
        String entitySubtype = statementEntity.getSubtype();
        ELanguage language = ((IToken)CollectionUtils.getAny((Iterable)statementEntity.includedTokens())).getLanguage();
        if (ConditionalStatementSubtypes.isConditionalStatement((ShallowEntity)statementEntity) && CoverableBranchAnalyzer.hasNonConstantSubCondition(statementEntity, conditionExtractor, subConditionParser) || language == ELanguage.ADA && CoverableBranchAnalyzer.isExitWhen(statementEntity)) {
            CoverableBranchAnalyzer.handleConditionalBlock(statementEntity, branches);
        } else if (language == ELanguage.ADA && "case".equalsIgnoreCase(entitySubtype)) {
            CoverableBranchAnalyzer.handleAdaCase(statementEntity, branches);
        } else if ((LanguageGroups.C_CPP_AND_MS_CLI.contains(language) || language == ELanguage.CS || language == ELanguage.JAVA) && ("switch".equals(entitySubtype) || "switch expression".equals(entitySubtype))) {
            CoverableBranchAnalyzer.handleClikeSwitch(statementEntity, branches);
        } else if (CommonUtils.isOneOf((Object)language, (Object[])new ELanguage[]{ELanguage.JAVA, ELanguage.CS}) && "catch".equals(entitySubtype)) {
            CoverableBranchAnalyzer.handleCatchBlock(statementEntity, branches);
        }
    }

    private static void handleConditionalBlock(ShallowEntity entity, List<CodeBranch> branches) {
        CodeBranch branchForTrue = new CodeBranch(entity, true);
        branches.add(branchForTrue);
        if (CommonUtils.isOneOf((Object)entity.getSubtype(), (Collection)SubTypeNames.IF_CONDITION_SUB_TYPE_NAMES)) {
            CoverableBranchAnalyzer.handleFalseBranchOfIfConditionStatement(entity, branches, branchForTrue);
        } else if (CommonUtils.isOneOf((Object)entity.getSubtype(), (Collection)SubTypeNames.LOOP_SUB_TYPE_NAMES)) {
            CoverableBranchAnalyzer.handleFalseBranchOfLoopWithCondition(entity, branches, branchForTrue);
        } else if ("exit".equals(entity.getSubtype())) {
            CoverableBranchAnalyzer.handleFalseBranchOfAdaExit(entity, branches, branchForTrue);
        } else {
            LOGGER.error("Incomplete conditional handling! Unsupported sub type: " + entity.getSubtype());
        }
    }

    private static void handleFalseBranchOfAdaExit(ShallowEntity entity, List<CodeBranch> branches, CodeBranch branchForTrue) {
        int endLine;
        int startLine;
        CodeBranch branchForFalse = new CodeBranch(entity, false);
        boolean branchExists = false;
        if (entity.getParent() != null && (startLine = branchForTrue.getEndLine() + 1) <= (endLine = entity.getParent().getEndLine() - 1)) {
            branchForFalse.setStartLine(startLine);
            branchForFalse.setEndLine(endLine);
            branchExists = true;
        }
        if (!branchExists) {
            branchForFalse.markBranchAsNotPresent();
            branchForFalse.setCounterBranch(branchForTrue);
        }
        branches.add(branchForFalse);
    }

    private static void handleFalseBranchOfIfConditionStatement(ShallowEntity entity, List<CodeBranch> branches, CodeBranch branchForTrue) {
        List<ShallowEntity> followingStatements = CoverableBranchAnalyzer.getFollowingStatementsOnSameLevel(entity);
        if ("elsif".equals(entity.getSubtype())) {
            return;
        }
        if (CoverableBranchAnalyzer.getFollowingElseIf(followingStatements) != null) {
            return;
        }
        if (CommonUtils.isOneOf((Object)entity.getSubtype(), (Collection)SubTypeNames.IF_CONDITION_CONDITIONAL_SUB_TYPE_NAMES)) {
            int endLine;
            int startLine;
            CodeBranch branchForFalse = new CodeBranch(entity, false);
            ShallowEntity elseEntity = CoverableBranchAnalyzer.getFollowingElse(followingStatements);
            if (elseEntity == null) {
                branchForFalse.markBranchAsNotPresent();
                endLine = startLine = branchForTrue.getEndLine();
            } else {
                startLine = elseEntity.getStartLine();
                endLine = elseEntity.getEndLine();
            }
            branchForFalse.setStartLine(startLine);
            branchForFalse.setEndLine(endLine);
            branchForFalse.setCounterBranch(branchForTrue);
            branches.add(branchForFalse);
        }
    }

    private static void handleFalseBranchOfLoopWithCondition(ShallowEntity entity, List<CodeBranch> branches, CodeBranch branchForTrue) {
        int line = branchForTrue.getEndLine();
        CodeBranch branchForFalse = new CodeBranch(entity, false);
        branchForFalse.markBranchAsNotPresent();
        branchForFalse.setStartLine(line);
        branchForFalse.setEndLine(line);
        branchForFalse.setCounterBranch(branchForTrue);
        branches.add(branchForFalse);
    }

    private static void handleCatchBlock(ShallowEntity entity, List<CodeBranch> branches) {
        CodeBranch branchForTrue = new CodeBranch(entity, true);
        branchForTrue.setStartLine(entity.getStartLine());
        branchForTrue.setEndLine(entity.getEndLine());
        branches.add(branchForTrue);
    }

    private static List<ShallowEntity> getFollowingStatementsOnSameLevel(ShallowEntity entity) {
        if (entity.getParent() == null) {
            return Collections.emptyList();
        }
        UnmodifiableList statementsOnSameLevel = entity.getParent().getChildren();
        int indexOfEntity = statementsOnSameLevel.indexOf(entity);
        if (indexOfEntity == -1) {
            return statementsOnSameLevel;
        }
        return statementsOnSameLevel.subList(indexOfEntity + 1, statementsOnSameLevel.size());
    }

    private static ShallowEntity getFollowingElseIf(List<ShallowEntity> followingStatements) {
        return CoverableBranchAnalyzer.getFollowingElementOfConditional(followingStatements, "else if");
    }

    private static ShallowEntity getFollowingElse(List<ShallowEntity> followingStatements) {
        return CoverableBranchAnalyzer.getFollowingElementOfConditional(followingStatements, "else");
    }

    private static ShallowEntity getFollowingElementOfConditional(List<ShallowEntity> followingStatements, String subTypeName) {
        for (ShallowEntity entity : followingStatements) {
            if ("if".equals(entity.getSubtype())) {
                return null;
            }
            if (!subTypeName.equals(entity.getSubtype())) continue;
            return entity;
        }
        return null;
    }

    private static boolean hasNonConstantSubCondition(ShallowEntity entity, IConditionExtractor conditionExtractor, SubConditionParserBase subConditionParser) {
        Condition condition = conditionExtractor.extractCondition(entity);
        if (condition == null) {
            return true;
        }
        List subConditions = subConditionParser.getSubConditions(condition);
        return !subConditions.stream().allMatch(Condition::isEmptyOrSingleLiteral);
    }

    private static void handleClikeSwitch(ShallowEntity entity, List<CodeBranch> branches) {
        boolean previousWasCaseOrDefault = false;
        CodeBranch currentBranch = null;
        block7: for (ShallowEntity child : entity.getChildren()) {
            if (child.getType() != EShallowEntityType.META) {
                previousWasCaseOrDefault = false;
                continue;
            }
            if (child.getSubtype().startsWith("#")) continue;
            switch (child.getSubtype()) {
                case "case": 
                case "default": {
                    currentBranch = CoverableBranchAnalyzer.createNewBranchIfNecessary(branches, previousWasCaseOrDefault, currentBranch, child);
                    previousWasCaseOrDefault = true;
                    continue block7;
                }
            }
            previousWasCaseOrDefault = false;
        }
        if (currentBranch != null) {
            currentBranch.setEndLine(entity.getEndLine() - 1);
            branches.add(currentBranch);
        }
    }

    private static CodeBranch createNewBranchIfNecessary(List<CodeBranch> branches, boolean previousWasCaseOrDefault, CodeBranch currentBranch, ShallowEntity child) {
        if (!previousWasCaseOrDefault) {
            if (currentBranch != null) {
                currentBranch.setEndLine(child.getStartLine() - 1);
                branches.add(currentBranch);
            }
            currentBranch = new CodeBranch(child);
        }
        return currentBranch;
    }

    private static void handleAdaCase(ShallowEntity entity, List<CodeBranch> branches) {
        boolean hadWhenOthers = false;
        for (ShallowEntity child : entity.getChildren()) {
            if (child.getType() != EShallowEntityType.STATEMENT || !"when".equalsIgnoreCase(child.getSubtype())) continue;
            branches.add(new CodeBranch(child));
            UnmodifiableList includedTokens = child.includedTokens();
            if (includedTokens.size() <= 1 || ((IToken)includedTokens.get(1)).getType() != ETokenType.OTHERS) continue;
            hadWhenOthers = true;
        }
        if (!hadWhenOthers) {
            branches.add(new CodeBranch(entity, "others"));
        }
    }

    public static final class CoverableBranchInfo {
        private final int volume;
        private final List<CodeBranch> codeBranches;

        public CoverableBranchInfo(int volume, List<CodeBranch> codeBranches) {
            this.volume = volume;
            this.codeBranches = codeBranches;
        }

        public int getVolume() {
            return this.volume;
        }

        public List<CodeBranch> getCodeBranches() {
            return this.codeBranches;
        }
    }
}

