/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testcoverage;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.testcoverage.CoverageMetricSynchronizerBase;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class LineCoverageMetricSynchronizer
extends CoverageMetricSynchronizerBase {
    public static final String ENABLE_LINE_COVERAGE_PARAMETER_NAME = "enable-line-coverage";
    public static final String COVERABLE_LINES_PARTITION = "test-coverable-lines";
    public static final String COVERED_LINES_PARTITION = "test-covered-lines";
    @StepParameter(value="enable-line-coverage")
    private CodeScopeAware<Boolean> enableLineCoverage;

    @Override
    protected void updateCoverageMetrics(CoverageMetricSynchronizerBase.CoveragePartitionGroup partitionGroup, List<String> pathsToUpdate) throws StorageException {
        PairList<String, LineCoverageInfo> coverageInfos = this.getLineCoverageInfosToUpdate(partitionGroup, false, pathsToUpdate);
        PairList coveredLinesData = new PairList();
        PairList coverableLinesData = new PairList();
        for (Pair coverageInfoPair : coverageInfos) {
            LineCoverageInfo coverageInfo = (LineCoverageInfo)coverageInfoPair.getSecond();
            String uniformPath = (String)coverageInfoPair.getFirst();
            coveredLinesData.add((Object)uniformPath, (Object)coverageInfo.getCoveredLineCount());
            coverableLinesData.add((Object)uniformPath, (Object)coverageInfo.getCoverableLines());
        }
        this.storeData((PairList<String, Double>)coverableLinesData, (PairList<String, Double>)coveredLinesData, partitionGroup);
    }

    @Override
    protected String getDefaultCoverablePartitionName() {
        return COVERABLE_LINES_PARTITION;
    }

    @Override
    protected String getDefaultCoveredPartitionName() {
        return COVERED_LINES_PARTITION;
    }

    @Override
    protected CodeScopeAware<Boolean> getCodeScopeAwareCoverageEnablement() {
        return this.enableLineCoverage;
    }
}

