/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testcoverage;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.volume.CodeBranch;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CompactLines;

public class LineCoverageToBranchCoverageConverter {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> SUBTYPES_WITH_CONDITION_IN_FIRST_LINE = CollectionUtils.asHashSet((Object[])new String[]{"if", "else if", "elseif", "for", "while", "exit"});
    private final List<CodeBranch> coverableBranches;
    private final CompactLines fullyCoveredLines;
    private final CompactLines partiallyCoveredLines;
    private final CompactLines uncoveredLines;

    public LineCoverageToBranchCoverageConverter(LineCoverageInfo lineCoverageInfo, List<CodeBranch> coverableBranches) {
        this(lineCoverageInfo.getFullyCoveredLines(), lineCoverageInfo.getPartiallyCoveredLines(), lineCoverageInfo.getUncoveredLines(), coverableBranches);
    }

    public LineCoverageToBranchCoverageConverter(CompactLines fullyCoveredLines, CompactLines partiallyCoveredLines, CompactLines uncoveredLines, List<CodeBranch> coverableBranches) {
        this.coverableBranches = coverableBranches;
        this.fullyCoveredLines = fullyCoveredLines;
        this.partiallyCoveredLines = partiallyCoveredLines;
        this.uncoveredLines = uncoveredLines;
    }

    public int calculateNumberOfCoveredBranches() {
        return CollectionUtils.filter(this.coverableBranches, this::isBranchCovered).size();
    }

    public boolean isBranchCovered(CodeBranch codeBranch) {
        int branchEndLineNumber;
        if (codeBranch.isBranchNotPresent()) {
            return this.isNotPresentBranchCovered(codeBranch);
        }
        if (!this.coverableBranches.isEmpty() && this.fullyCoveredLines.isEmpty() && this.partiallyCoveredLines.isEmpty()) {
            return false;
        }
        CompactLines branchConditionLines = new CompactLines(LineCoverageToBranchCoverageConverter.getConditionLines(codeBranch));
        int branchStartLineNumber = branchConditionLines.getHighestLineNumber().map(x -> x + 1).orElseGet(() -> ((CodeBranch)codeBranch).getStartLine());
        branchStartLineNumber = Math.max(branchStartLineNumber, codeBranch.getStartLine());
        if (branchConditionLines.size() == 1 && ((Integer)branchConditionLines.getHighestLineNumber().get()).intValue() == codeBranch.getStartLine() && codeBranch.getStartLine() == codeBranch.getEndLine()) {
            branchStartLineNumber = codeBranch.getStartLine();
        }
        if (branchStartLineNumber > (branchEndLineNumber = codeBranch.getEndLine())) {
            LOGGER.warn("Encountered branch with start line after end line: " + String.valueOf(codeBranch));
            return false;
        }
        if (this.fullyCoveredLines.containsAny(branchStartLineNumber, branchEndLineNumber) || this.partiallyCoveredLines.containsAny(branchStartLineNumber + 1, branchEndLineNumber)) {
            return true;
        }
        if (this.fullyCoveredLines.containsAll((Iterable)branchConditionLines) && !branchConditionLines.isEmpty()) {
            return true;
        }
        if (this.isCounterBranchFullyCovered(codeBranch)) {
            return true;
        }
        if (this.uncoveredLines.containsAny(branchStartLineNumber, branchEndLineNumber)) {
            return false;
        }
        return !this.uncoveredLines.intersects(branchConditionLines);
    }

    private static List<Integer> getConditionLines(CodeBranch branch) {
        if (branch.getEntity().getType() == EShallowEntityType.METHOD) {
            return Collections.emptyList();
        }
        if ("if".equals(branch.getEntity().getSubtype())) {
            return LineCoverageToBranchCoverageConverter.filteredLineRange((List<IToken>)branch.getEntity().ownStartTokens());
        }
        return Collections.singletonList(branch.getStartLine());
    }

    private static List<Integer> filteredLineRange(List<IToken> tokens) {
        return tokens.stream().filter(LineCoverageToBranchCoverageConverter::isRelevantConditionToken).map(token -> token.getLineNumber() + 1).distinct().collect(Collectors.toList());
    }

    private static boolean isRelevantConditionToken(IToken token) {
        ETokenType.ETokenClass tokenClass = token.getType().getTokenClass();
        return tokenClass == ETokenType.ETokenClass.IDENTIFIER || tokenClass == ETokenType.ETokenClass.LITERAL;
    }

    private boolean isNotPresentBranchCovered(CodeBranch codeBranch) {
        if ("default".equals(codeBranch.getDecision())) {
            return false;
        }
        if (codeBranch.getCounterBranch() == null) {
            return false;
        }
        String existingBranchSubType = codeBranch.getEntity().getSubtype();
        CodeBranch existingBranch = codeBranch.getCounterBranch();
        CCSMAssert.isFalse((boolean)existingBranch.isBranchNotPresent(), (String)"Counter branch does not exist");
        int conditionLine = this.extractConditionLine(existingBranchSubType, existingBranch);
        if (this.fullyCoveredLines.contains(conditionLine)) {
            return true;
        }
        if (this.partiallyCoveredLines.contains(conditionLine)) {
            return !this.isBranchCovered(existingBranch);
        }
        return !this.uncoveredLines.contains(conditionLine) && !this.partiallyCoveredLines.contains(conditionLine);
    }

    private int extractConditionLine(String existingBranchSubType, CodeBranch existingBranch) {
        if (SUBTYPES_WITH_CONDITION_IN_FIRST_LINE.contains(existingBranchSubType)) {
            return existingBranch.getStartLine();
        }
        if ("do".equals(existingBranchSubType)) {
            return existingBranch.getEndLine();
        }
        LOGGER.warn("Unexpected sub type when handling a not present branch: " + existingBranchSubType);
        return existingBranch.getStartLine();
    }

    private boolean isCounterBranchFullyCovered(CodeBranch codeBranch) {
        return codeBranch.getCounterBranch() != null && this.fullyCoveredLines.containsAll(LineCoverageToBranchCoverageConverter.getConditionLines(codeBranch.getCounterBranch()));
    }
}

