/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.teamscale.commons.lang.ToStringHelpers;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.conqat.engine.persistence.index.PartitionIndexBase;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.engine.persistence.store.util.StringAbbreviationDeserializerBase;
import org.conqat.engine.persistence.store.util.StringAbbreviationSerializerBase;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public final class MethodLocation
implements Comparable<MethodLocation>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String UNIFORM_PATH_PROPERTY = "uniformPath";
    @JsonProperty(value="uniformPath")
    private final UniformPath uniformPath;
    @JsonUnwrapped
    private OffsetBasedRegion region;

    public MethodLocation(UniformPath uniformPath, int start, int end) {
        this.uniformPath = uniformPath;
        this.region = new OffsetBasedRegion(start, end);
    }

    @JsonCreator
    public MethodLocation(@JsonProperty(value="uniformPath") UniformPath uniformPath, @JsonUnwrapped OffsetBasedRegion region) {
        this.uniformPath = uniformPath;
        this.region = region;
    }

    @JsonSetter(value="region")
    public void setRegion(OffsetBasedRegion region) {
        if (region.getStart() == 0 && region.getEnd() == 0) {
            return;
        }
        this.region = region;
    }

    public OffsetBasedRegion getRegion() {
        return this.region;
    }

    public UniformPath getUniformPath() {
        return this.uniformPath;
    }

    @Override
    public int compareTo(@NonNull MethodLocation o) {
        return Comparator.nullsFirst(Comparator.comparing(MethodLocation::getUniformPath).thenComparing(MethodLocation::getRegion)).compare(this, o);
    }

    public int hashCode() {
        return Objects.hash(this.region, this.uniformPath);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodLocation) {
            MethodLocation other = (MethodLocation)obj;
            return Objects.equals(this.region, other.region) && Objects.equals(this.uniformPath, other.uniformPath);
        }
        return false;
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }

    public String toIndexKey() {
        return MethodLocation.makeKeyFromPathAndRegion(this.uniformPath, this.region);
    }

    private static String makeKeyFromPathAndRegion(UniformPath uniformPath, OffsetBasedRegion region) {
        return String.valueOf(uniformPath) + "#!#" + region.getStart() + "#!#" + region.getEnd();
    }

    public static MethodLocation fromIndexKey(String key) {
        CCSMAssert.isNotNull((Object)key, (String)"Tried to interpret null as a MethodLocation. This usually happens when you're working with predecessors of MethodInfos, which may contain dummy values with null keys that need to be handled explicitly");
        String[] keyParts = PartitionIndexBase.KEY_SEPARATOR_PATTERN.split(key);
        UniformPath uniformPath = UniformPath.parse((String)keyParts[0]);
        OffsetBasedRegion region = new OffsetBasedRegion(Integer.parseInt(keyParts[1]), Integer.parseInt(keyParts[2]));
        return new MethodLocation(uniformPath, region);
    }

    public static class MethodLocationDeserializer
    extends StringAbbreviationDeserializerBase<MethodLocation> {
        protected MethodLocationDeserializer(StorageStringAbbreviator stringAbbreviator) {
            super(stringAbbreviator);
        }

        protected Collection<Integer> extractUnAbbreviationIds(byte[] data, int offset) {
            return List.of(Integer.valueOf(ByteArrayUtils.getIntFromByteArray((byte[])data, (int)offset)));
        }

        protected MethodLocation deserializeFromByteArrayInternal(byte[] data, int offset, Map<Integer, String> unAbbreviationMap) {
            int uniformPathId = ByteArrayUtils.getIntFromByteArray((byte[])data, (int)offset);
            String uniformPath = unAbbreviationMap.get(uniformPathId);
            int start = ByteArrayUtils.getIntFromByteArray((byte[])data, (int)(offset + 4));
            int end = ByteArrayUtils.getIntFromByteArray((byte[])data, (int)(offset + 8));
            return new MethodLocation(UniformPath.parse((String)uniformPath), start, end);
        }
    }

    public static class MethodLocationSerializer
    extends StringAbbreviationSerializerBase<MethodLocation> {
        public MethodLocationSerializer(StorageStringAbbreviator stringAbbreviator, List<MethodLocation> locations) throws StorageException {
            super(stringAbbreviator, locations);
        }

        public List<String> getStringsToAbbreviate(@Nullable MethodLocation element) {
            if (element == null) {
                return Collections.emptyList();
            }
            return List.of(element.getUniformPath().toStringAsMigrationFrontier());
        }

        protected byte @NonNull [] serializeToByteArrayInternal(MethodLocation element, Map<String, Integer> abbreviationMap) {
            return ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.intToByteArray((int)abbreviationMap.get(element.getUniformPath().toStringAsMigrationFrontier())), ByteArrayUtils.intToByteArray((int)element.region.getStart()), ByteArrayUtils.intToByteArray((int)element.region.getEnd())});
        }
    }
}

