/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.abap;

import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.abap.ScovIdFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

@Index(name="abap-method-mappings", options={EStorageOption.BRANCHED, EStorageOption.COMPRESSED})
public class AbapScovMethodMappingIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "abap-method-mappings";
    private static final String MULTI_VALUE_MARKER = "##";
    private final ValueIndex<String> delegate;
    private final IStore store;

    public AbapScovMethodMappingIndex(IStore store) {
        this.delegate = ValueIndex.forString((IStore)store);
        this.store = store;
    }

    public void putMappings(SetMap<ScovIdFeature, MethodLocation> mappings) throws StorageException {
        PairList keyValues = new PairList();
        for (ScovIdFeature feature : mappings.getKeys()) {
            Set values = (Set)mappings.getCollection((Object)feature);
            String value = values.size() == 1 ? ((MethodLocation)CollectionUtils.getAny((Iterable)values)).toIndexKey() : AbapScovMethodMappingIndex.pack(values);
            keyValues.add((Object)feature.toString(), (Object)value);
        }
        this.delegate.setValues(keyValues);
    }

    public List<Set<MethodLocation>> getMappings(List<String> features) throws StorageException {
        ArrayList<Set<MethodLocation>> sets = new ArrayList<Set<MethodLocation>>();
        for (String value : this.delegate.getValues(features)) {
            if (value == null) {
                sets.add((Set<MethodLocation>)CollectionUtils.emptySet());
                continue;
            }
            if (value.startsWith(MULTI_VALUE_MARKER)) {
                sets.add(AbapScovMethodMappingIndex.unpack(value));
                continue;
            }
            sets.add(Collections.singleton(MethodLocation.fromIndexKey(value)));
        }
        return sets;
    }

    public void removeMappingsByObjectName(String objectName) throws StorageException {
        String prefix = objectName.toUpperCase() + "#";
        this.store.removeByPrefix(StringUtils.stringToBytes((String)prefix));
    }

    private static String pack(Set<MethodLocation> locations) {
        return locations.stream().map(MethodLocation::toIndexKey).sorted().collect(Collectors.joining(MULTI_VALUE_MARKER, MULTI_VALUE_MARKER, ""));
    }

    private static Set<MethodLocation> unpack(String packedValue) {
        String[] unpackedValues = StringUtils.stripPrefix((String)packedValue, (String)MULTI_VALUE_MARKER).split(MULTI_VALUE_MARKER);
        return Stream.of(unpackedValues).map(MethodLocation::fromIndexKey).collect(Collectors.toSet());
    }

    @VisibleForTesting
    PairList<String, String> getAllEntries() throws StorageException {
        return this.delegate.getAllEntries();
    }
}

