/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.abap;

import com.teamscale.index.testgap.UniqueSingleKeyFeatureBase;
import com.teamscale.index.testgap.abap.structure.AbapScovUtils;
import com.teamscale.index.testgap.abap.structure.EProcessingBlockType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.string.StringUtils;

public class ScovIdFeature
extends UniqueSingleKeyFeatureBase {
    private static final String SCOV_AT_SELECTION_SCREEN_NAME = "AT SELECTION-SCREEN";
    public static final char ID_SEPARATOR = '#';

    public ScovIdFeature(String objectName, String localClass, String blockType, String name) {
        super(ScovIdFeature.joinAndCapitalize(objectName, localClass, blockType, ScovIdFeature.removeArtificialSuffix(name)));
    }

    public ScovIdFeature(String objectName, String localClass, EProcessingBlockType blockType, String name) {
        this(objectName, localClass, blockType.name(), name);
    }

    public static ScovIdFeature createFrom(String objectName, ShallowEntity method) throws ConQATException {
        EProcessingBlockType blockType = EProcessingBlockType.fromShallowEntity(method);
        String name = AbapScovUtils.buildSCOVMethodName(method, blockType);
        if (blockType == EProcessingBlockType.ATSS) {
            name = SCOV_AT_SELECTION_SCREEN_NAME;
        }
        String localClass = "";
        if (AbapUtils.hasClassParent((ShallowEntity)method)) {
            localClass = method.getParent().getName();
        }
        return new ScovIdFeature(objectName, localClass, blockType, name);
    }

    public String getObjectName() {
        return StringUtils.getFirstParts((String)this.methodKey, (int)1, (char)'#');
    }

    public String getProcedureType() {
        return this.methodKey.split(Character.toString('#'))[2];
    }

    public String getLocalClass() {
        return this.methodKey.split(Character.toString('#'))[1];
    }

    public String getProcedureName() {
        return StringUtils.getLastPart((String)this.methodKey, (char)'#');
    }

    private static String removeArtificialSuffix(String methodId) {
        return StringUtils.removeLastPart((String)methodId, (char)':');
    }

    private static String joinAndCapitalize(String ... elements) {
        return StringUtils.concat((Object[])elements, (String)String.valueOf('#')).toUpperCase();
    }
}

