/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.query;

import com.teamscale.core.index.ProjectIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public interface ITgaCoverageSourceParameter {
    public static final String USE_ALL_PARTITIONS_PARAMETER_NAME = "all-partitions";
    public static final String CROSS_ANNOTATION_PROJECT_PARAMETER_NAME = "cross-annotation-project-patterns";
    public static final String PARTITIONS_PARAMETER_NAME = "partitions";
    public static final String USE_ALL_PARTITIONS_PARAMETER_DOC = "If this is true, all available test coverage partitions are considered.";
    public static final String CROSS_ANNOTATION_PROJECTS_PARAMETER_DOC = "This parameter may be given multiple times. Specifies further Teamscale projects from which to consider test coverage.";
    public static final String PARTITIONS_PARAMETER_DOC = "This parameter may be given multiple times. Specifies the test coverage partitions to consider.";
    public static final String OPTIONAL_PARTITIONS_PARAMETER_DOC = "This parameter may be given multiple times. Specifies the test coverage partitions to consider. If this parameter is omitted every partition will be taken.";

    public boolean useAllPartitions();

    public List<String> getPartitions();

    public List<String> getCrossAnnotationProjectPatterns();

    default public Set<PublicProjectId> getCrossAnnotationProjects(ProjectIndex projectIndex) throws StorageException {
        return projectIndex.resolvePatterns(this.getCrossAnnotationProjectPatterns());
    }

    default public List<String> getPartitions(Collection<String> allRelevantPartitions) {
        if (this.useAllPartitions()) {
            return new ArrayList<String>(allRelevantPartitions);
        }
        return new ArrayList<String>(CollectionUtils.intersectionSet(this.getPartitions(), (Collection[])new Collection[]{allRelevantPartitions}));
    }
}

