/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public class LineCoverageSourceQueryParameters {
    @JsonProperty(value="allPartitions")
    @QueryParam(value="all-partitions")
    @Parameter(description="If this is true, all available test coverage partitions are considered.")
    @DefaultValue(value="false")
    private boolean allPartitions;
    @JsonProperty(value="partitions")
    @QueryParam(value="partitions")
    @Parameter(description="This parameter may be given multiple times. Specifies the test coverage partitions to consider.")
    private List<String> partitions;

    @JsonCreator
    public LineCoverageSourceQueryParameters() {
    }

    public LineCoverageSourceQueryParameters(@NonNull List<String> partitions, boolean allPartitions) {
        CCSMAssert.isNotNull(partitions);
        this.partitions = partitions;
        this.allPartitions = allPartitions;
    }

    public boolean useAllPartitions() {
        return this.allPartitions;
    }

    public List<String> getPartitions() {
        return this.partitions;
    }

    public List<String> getPartitions(Collection<String> allRelevantPartitions) {
        if (this.useAllPartitions()) {
            return new ArrayList<String>(allRelevantPartitions);
        }
        return new ArrayList<String>(CollectionUtils.intersectionSet(this.getPartitions(), (Collection[])new Collection[]{allRelevantPartitions}));
    }

    public String toString() {
        if (this.useAllPartitions()) {
            return "Coverage is considered from all partitions.";
        }
        return "Coverage is considered from the following partitions: " + StringUtils.concat(this.getPartitions(), (String)",") + ".";
    }
}

