/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.trend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.KeyCollectingCallback;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.io.ByteArrayUtils;

@Index(name="test-delta", options={EStorageOption.ABBREVIATE_STRINGS, EStorageOption.COMMIT_ISOLATED}, valueClasses={byte[].class})
public class TestCoverageDeltaIndex
extends IndexBase
implements IProjectIndex,
IRollbackableIndex {
    public static final String INDEX_NAME = "test-delta";
    private static final byte[] TESTED_MARKER_VALUE = new byte[0];

    public TestCoverageDeltaIndex(IStore store) {
        super(store);
    }

    private static byte[] makeKey(StorageStringAbbreviator abbreviator, CommitDescriptor commit, String partition) throws StorageException {
        byte[] timestampBytes = ByteArrayUtils.longToByteArray((long)commit.getTimestamp());
        return ByteArrayUtils.concat((byte[][])new byte[][]{timestampBytes, ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(commit.getBranchName())), ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(partition))});
    }

    private SetMap<CommitDescriptor, String> collectEntriesInRange(long beginTimestamp, long endTimestamp) throws StorageException {
        SetMap partitionsByCommit = new SetMap();
        byte[] beginKey = ByteArrayUtils.longToByteArray((long)beginTimestamp);
        byte[] endKey = ByteArrayUtils.longToByteArray((long)endTimestamp);
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        ArrayList keys = new ArrayList();
        KeyCollectingCallback callback = new KeyCollectingCallback(keys);
        this.store.scanKeys(beginKey, endKey, (IKeyValueCallback)callback);
        HashSet<Integer> abbreviationIndexesToLookup = new HashSet<Integer>();
        for (byte[] key : keys) {
            TestCoverageDeltaIndex.extractAbbreviationIndexesFromKey(key, abbreviationIndexesToLookup);
        }
        Map lookupMap = abbreviator.buildUnabbreviationMap(abbreviationIndexesToLookup);
        for (byte[] key : keys) {
            Pair<CommitDescriptor, String> decodedKey = TestCoverageDeltaIndex.decodeKey(lookupMap, key);
            String partition = (String)decodedKey.getSecond();
            partitionsByCommit.add((Object)((CommitDescriptor)decodedKey.getFirst()), (Object)partition);
        }
        return partitionsByCommit;
    }

    private static void extractAbbreviationIndexesFromKey(byte[] key, Set<Integer> indexesToLookup) {
        int branchIndex = ByteArrayUtils.getIntFromByteArray((byte[])key, (int)8);
        int partitionIndex = ByteArrayUtils.getIntFromByteArray((byte[])key, (int)12);
        indexesToLookup.add(branchIndex);
        indexesToLookup.add(partitionIndex);
    }

    private static Pair<CommitDescriptor, String> decodeKey(Map<Integer, String> abbrevationIndexToStringLookup, byte[] key) {
        long timestamp = ByteArrayUtils.getLongFromByteArray((byte[])key, (int)0);
        int branchIndex = ByteArrayUtils.getIntFromByteArray((byte[])key, (int)8);
        int partitionIndex = ByteArrayUtils.getIntFromByteArray((byte[])key, (int)12);
        return new Pair((Object)new CommitDescriptor(abbrevationIndexToStringLookup.get(branchIndex), timestamp), (Object)abbrevationIndexToStringLookup.get(partitionIndex));
    }

    public void addPartitionWithCoverage(CommitDescriptor commit, Set<String> partitions) throws StorageException {
        PairList keysValues = new PairList();
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        for (String partition : CollectionUtils.sort(partitions)) {
            keysValues.add((Object)TestCoverageDeltaIndex.makeKey(abbreviator, commit, partition), (Object)TESTED_MARKER_VALUE);
        }
        this.store.put(keysValues);
    }

    public void removeEntry(CommitDescriptor commit) throws StorageException {
        byte[] timestampBytes = ByteArrayUtils.longToByteArray((long)commit.getTimestamp());
        int abbreviatedBranch = this.store.getAbbreviator().abbreviate(commit.getBranchName());
        this.store.removeByPrefix(ByteArrayUtils.concat((byte[][])new byte[][]{timestampBytes, ByteArrayUtils.intToByteArray((int)abbreviatedBranch)}));
    }

    public Map<String, CoverageUploadTimeRange> getCoverageUploadTimeRangesByPartition(long beginTimestamp, long endTimestamp, Collection<String> partitions) throws StorageException {
        Map<String, CoverageUploadTimeRange> result = partitions.stream().collect(Collectors.toMap(partitionName -> partitionName, partitionName -> new CoverageUploadTimeRange()));
        SetMap<CommitDescriptor, String> partitionsByCommit = this.collectEntriesInRange(beginTimestamp, endTimestamp);
        SetMap commitsByPartition = new SetMap();
        for (Map.Entry commitAndPartitionEntry : partitionsByCommit) {
            for (String partition : (Set)commitAndPartitionEntry.getValue()) {
                commitsByPartition.add((Object)partition, (Object)((CommitDescriptor)commitAndPartitionEntry.getKey()));
            }
        }
        for (Map.Entry entry : commitsByPartition) {
            CoverageUploadTimeRange summary = result.get(entry.getKey());
            if (summary == null) continue;
            for (CommitDescriptor commit : (Set)entry.getValue()) {
                summary.addCoverageUploadTimestamp(commit.getTimestamp());
            }
        }
        return result;
    }

    public CoverageUploadTimeRange getCoverageUploadTimeRangesForAllPartitions(long beginTimestamp, long endTimestamp) throws StorageException {
        SetMap<CommitDescriptor, String> partitionsByCommit = this.collectEntriesInRange(beginTimestamp, endTimestamp);
        CoverageUploadTimeRange result = new CoverageUploadTimeRange();
        partitionsByCommit.getKeys().forEach(commit -> result.addCoverageUploadTimestamp(commit.getTimestamp()));
        return result;
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        if (timestampByBranch.isEmpty()) {
            return;
        }
        long beginTimestamp = timestampByBranch.values().stream().min(Long::compare).get();
        byte[] beginKey = ByteArrayUtils.longToByteArray((long)beginTimestamp);
        ConcurrentLinkedQueue keysToDelete = new ConcurrentLinkedQueue();
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        Map abbreviationToBranchMap = CollectionUtils.inverseMap((Map)abbreviator.buildAbbreviationMap(timestampByBranch.keySet()));
        this.store.scanKeys(beginKey, null, (key, value) -> TestCoverageDeltaIndex.fillKeysToDelete(key, abbreviationToBranchMap, timestampByBranch, keysToDelete));
        this.store.remove(new ArrayList(keysToDelete));
    }

    private static void fillKeysToDelete(byte[] key, Map<Integer, String> branchByAbbreviation, Map<String, Long> timestampByBranch, Queue<byte[]> keysToDelete) {
        boolean keyShallBeDeleted;
        int branchIndex = ByteArrayUtils.getIntFromByteArray((byte[])key, (int)8);
        String branch = branchByAbbreviation.get(branchIndex);
        if (branch == null) {
            return;
        }
        long timestamp = ByteArrayUtils.getLongFromByteArray((byte[])key, (int)0);
        boolean bl = keyShallBeDeleted = timestampByBranch.get(branch) < timestamp;
        if (keyShallBeDeleted) {
            keysToDelete.add(key);
        }
    }

    public static class CoverageUploadTimeRange {
        private long oldestUploadTimestamp = -1L;
        private long newestUploadTimestamp = -1L;

        public void addCoverageUploadTimestamp(long timestamp) {
            if (this.oldestUploadTimestamp == -1L || timestamp < this.oldestUploadTimestamp) {
                this.oldestUploadTimestamp = timestamp;
            }
            if (timestamp > this.newestUploadTimestamp) {
                this.newestUploadTimestamp = timestamp;
            }
        }

        public boolean hasNoCoverageUpload() {
            return this.oldestUploadTimestamp == -1L;
        }

        public long getOldestUploadTimestamp() {
            return this.oldestUploadTimestamp;
        }

        public long getNewestUploadTimestamp() {
            return this.newestUploadTimestamp;
        }
    }
}

