/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.trend;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.external.update.ExternalResultsPartitionLastUpdateIndex;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.resource.CodeScopesMappingIndex;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.query.ITgaCoverageSourceParameter;
import com.teamscale.index.testgap.query.TgaFileListRequest;
import com.teamscale.index.testgap.query.TgaPathRequest;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import com.teamscale.index.testgap.trend.ArchitectureTgaTrendAdjuster;
import com.teamscale.index.testgap.trend.CodeScopeTgaTrendAdjuster;
import com.teamscale.index.testgap.trend.ITgaTrendAdjuster;
import com.teamscale.index.testgap.trend.NewlyCoveredMethodsIndex;
import com.teamscale.index.testgap.trend.NoOpTgaTrendAdjuster;
import com.teamscale.index.testgap.trend.TgaTrendDataCache;
import com.teamscale.index.testgap.trend.TouchedFilesCalculator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;

public class TgaTrendComputer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CommitResolvingStorageSystem projectStorageSystem;
    private final IndexLayer indexLayer;
    private final IProjectId projectId;

    public TgaTrendComputer(IndexLayer indexLayer, IProjectId projectId, CommitResolvingStorageSystem projectStorageSystem) {
        this.projectStorageSystem = projectStorageSystem;
        this.indexLayer = indexLayer;
        this.projectId = projectId;
    }

    public List<TgaTrendEntry> processTgaTrendRequest(TimeIntervalBasedServiceQueryOptions timeIntervalParameters, TgaRequestQueryOptions tgaRequestParameters, ITgaCoverageSourceParameter coverageSourceParameters, ETgaAssessmentType assessmentType) throws StorageException {
        RepositoryLogFileIndex logFileIndex = (RepositoryLogFileIndex)this.projectStorageSystem.openProjectIndex(RepositoryLogFileIndex.class, null);
        NewlyCoveredMethodsIndex newlyCoveredMethodsIndex = (NewlyCoveredMethodsIndex)this.projectStorageSystem.openProjectIndex(NewlyCoveredMethodsIndex.class, null);
        TgaPathRequest request = TgaPathRequest.createRequest(coverageSourceParameters, timeIntervalParameters, tgaRequestParameters, assessmentType, this.indexLayer, this.projectId);
        UniformPath sourcePathPrefix = request.getPathPrefix();
        TgaTrendDataCache trendDataCache = new TgaTrendDataCache();
        ITgaTrendAdjuster architectureOrCodeScopeAdjuster = new NoOpTgaTrendAdjuster();
        if (request.isArchitecturePathRequest() || request.isCodeScopePathRequest()) {
            architectureOrCodeScopeAdjuster = this.handleArchitectureOrCodeScopeRequest(sourcePathPrefix, trendDataCache, request);
            sourcePathPrefix = UniformPath.codeRoot();
        }
        TouchedFilesCalculator touchedFilesCalculator = new TouchedFilesCalculator(newlyCoveredMethodsIndex, logFileIndex, request.getPartitions(), sourcePathPrefix, (FunctionWithException<CommitDescriptor, ExternalResultsPartitionLastUpdateIndex, StorageException>)((FunctionWithException)commit -> (ExternalResultsPartitionLastUpdateIndex)this.projectStorageSystem.openProjectIndex(ExternalResultsPartitionLastUpdateIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)commit))));
        return this.gatherAllRelevantCommitsAndBuildTrend(coverageSourceParameters, timeIntervalParameters, tgaRequestParameters, assessmentType, trendDataCache, touchedFilesCalculator, architectureOrCodeScopeAdjuster, request);
    }

    private ITgaTrendAdjuster handleArchitectureOrCodeScopeRequest(UniformPath sourcePathPrefix, TgaTrendDataCache trendDataCache, TgaPathRequest rootRequest) throws StorageException {
        HistoryAccessOption readAccess = HistoryAccessOption.readCommit((CommitDescriptor)rootRequest.getIndexAccessCommit());
        if (rootRequest.isArchitecturePathRequest()) {
            MetricsToArchitectureMetricsMappingIndex architectureMappingIndex = (MetricsToArchitectureMetricsMappingIndex)this.projectStorageSystem.openProjectIndex(MetricsToArchitectureMetricsMappingIndex.class, readAccess);
            return new ArchitectureTgaTrendAdjuster(sourcePathPrefix, architectureMappingIndex, trendDataCache);
        }
        if (rootRequest.isCodeScopePathRequest()) {
            CodeScopesMappingIndex codeScopesMappingIndex = (CodeScopesMappingIndex)this.projectStorageSystem.openProjectIndex(CodeScopesMappingIndex.class, readAccess);
            return new CodeScopeTgaTrendAdjuster(sourcePathPrefix, codeScopesMappingIndex, trendDataCache);
        }
        return new NoOpTgaTrendAdjuster();
    }

    private List<TgaTrendEntry> gatherAllRelevantCommitsAndBuildTrend(ITgaCoverageSourceParameter coverageParameters, TimeIntervalBasedServiceQueryOptions timeIntervalParameters, TgaRequestQueryOptions tgaRequestParameters, ETgaAssessmentType assessmentType, TgaTrendDataCache trendDataCache, TouchedFilesCalculator touchedFilesCalculator, ITgaTrendAdjuster architectureOrCodeScopeAdjuster, TgaPathRequest rootRequest) throws StorageException {
        long endTimestamp = rootRequest.getIndexAccessCommit().getTimestamp();
        String branchName = rootRequest.getIndexAccessCommit().getBranchName();
        if (rootRequest.getIndexAccessCommit().isHeadCommit()) {
            endTimestamp = DateTimeUtils.millisNow();
        }
        PairList<ParentedCommitDescriptor, RepositoryLogEntryAggregate> commitsWithLogEntries = this.getCommitsWithLogEntries(rootRequest.getBaselineTimestamp(), endTimestamp, branchName);
        return this.buildTrend(commitsWithLogEntries, endTimestamp, coverageParameters, timeIntervalParameters, tgaRequestParameters, assessmentType, trendDataCache, touchedFilesCalculator, architectureOrCodeScopeAdjuster, rootRequest);
    }

    private PairList<ParentedCommitDescriptor, RepositoryLogEntryAggregate> getCommitsWithLogEntries(long baselineTimestamp, long endTimestamp, String branchName) throws StorageException {
        CommitDescriptorIndex commitDescriptorIndex = (CommitDescriptorIndex)this.projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null);
        Optional firstCommitResult = commitDescriptorIndex.getFirstActualCommitBeforeOrAt(new CommitDescriptor(branchName, endTimestamp), 0L);
        if (firstCommitResult.isEmpty()) {
            return PairList.emptyPairList();
        }
        List history = commitDescriptorIndex.getCommitHistoryWithFirstParentCommits((CommitDescriptor)firstCommitResult.get(), baselineTimestamp);
        history.removeIf(commit -> commit.getTimestamp() == baselineTimestamp);
        history = CollectionUtils.reverse((Collection)history);
        RepositoryLogIndex logIndex = (RepositoryLogIndex)this.projectStorageSystem.openProjectIndex(RepositoryLogIndex.class, null);
        List logEntries = logIndex.getEntries(history);
        PairList commitsWithLogEntries = new PairList();
        for (int i = 0; i < logEntries.size(); ++i) {
            RepositoryLogEntryAggregate logEntry = (RepositoryLogEntryAggregate)logEntries.get(i);
            if (logEntry != null && logEntry.getCommit() != null) {
                CommitDescriptor commit2 = logEntry.getCommit();
                commitsWithLogEntries.add((Object)commitDescriptorIndex.getCommit(commit2), (Object)logEntry);
                continue;
            }
            LOGGER.error("Did not find log entry for commit: " + String.valueOf(history.get(i)));
        }
        return commitsWithLogEntries;
    }

    private List<TgaTrendEntry> buildTrend(PairList<ParentedCommitDescriptor, RepositoryLogEntryAggregate> commitsWithLogEntries, long endTimestamp, ITgaCoverageSourceParameter coverageParameters, TimeIntervalBasedServiceQueryOptions timeIntervalParameters, TgaRequestQueryOptions tgaRequestParameters, ETgaAssessmentType assessmentType, TgaTrendDataCache trendDataCache, TouchedFilesCalculator touchedFilesCalculator, ITgaTrendAdjuster architectureOrCodeScopeAdjuster, TgaPathRequest rootRequest) throws StorageException {
        String branchName = rootRequest.getIndexAccessCommit().getBranchName();
        if (!commitsWithLogEntries.isEmpty()) {
            branchName = ((ParentedCommitDescriptor)commitsWithLogEntries.getFirst(0)).getBranchName();
        }
        CommitDescriptor baselineCommit = new CommitDescriptor(branchName, rootRequest.getBaselineTimestamp());
        TgaPathRequest baselineRequest = TgaPathRequest.createRequest(baselineCommit, coverageParameters, timeIntervalParameters, tgaRequestParameters, assessmentType, this.indexLayer, this.projectId);
        AssessedTgaData baselineData = baselineRequest.fetchAndAssessData();
        trendDataCache.addData(baselineData);
        ArrayList<TgaTrendEntry> trend = new ArrayList<TgaTrendEntry>();
        TgaTrendComputer.addTrendEntry(trend, rootRequest.getBaselineTimestamp(), trendDataCache, assessmentType);
        List<CommitDescriptor> codeCommits = TgaTrendComputer.getCodeCommits(commitsWithLogEntries);
        touchedFilesCalculator.preloadTouchedFiles(codeCommits);
        List<CommitDescriptor> coverageOrMergeCommits = TgaTrendComputer.getCoverageOrMergeCommits(commitsWithLogEntries);
        touchedFilesCalculator.preloadNewlyCoveredMethods(coverageOrMergeCommits, assessmentType == ETgaAssessmentType.EXECUTION_ONLY);
        for (Pair commitWithLogEntry : commitsWithLogEntries) {
            this.updateCacheWithCommitDelta((Pair<ParentedCommitDescriptor, RepositoryLogEntryAggregate>)commitWithLogEntry, coverageParameters, timeIntervalParameters, assessmentType, tgaRequestParameters, trendDataCache, touchedFilesCalculator, architectureOrCodeScopeAdjuster);
            TgaTrendComputer.addTrendEntry(trend, ((ParentedCommitDescriptor)commitWithLogEntry.getFirst()).getTimestamp(), trendDataCache, assessmentType);
        }
        if (commitsWithLogEntries.isEmpty() || ((ParentedCommitDescriptor)commitsWithLogEntries.getFirst(commitsWithLogEntries.size() - 1)).getTimestamp() < endTimestamp) {
            TgaTrendComputer.addTrendEntry(trend, endTimestamp, trendDataCache, assessmentType);
        }
        return trend;
    }

    private static void addTrendEntry(List<TgaTrendEntry> trend, long timestamp, TgaTrendDataCache trendDataCache, ETgaAssessmentType assessmentType) {
        CounterSet<ETestGapState> states = trendDataCache.countStates();
        LinkedHashMap<ETestGapState, Integer> values = new LinkedHashMap<ETestGapState, Integer>();
        for (ETestGapState state : assessmentType.getTestGapStates()) {
            values.put(state, states.getValue((Object)state));
        }
        trend.add(new TgaTrendEntry(timestamp, values));
    }

    private void updateCacheWithCommitDelta(Pair<ParentedCommitDescriptor, RepositoryLogEntryAggregate> commitWithLogEntry, ITgaCoverageSourceParameter coverageParameters, TimeIntervalBasedServiceQueryOptions timeIntervalParameters, ETgaAssessmentType assessmentType, TgaRequestQueryOptions tgaRequestParameters, TgaTrendDataCache trendDataCache, TouchedFilesCalculator touchedFilesCalculator, ITgaTrendAdjuster architectureOrCodeScopeAdjuster) throws StorageException {
        Set<String> partitions;
        ParentedCommitDescriptor commit = (ParentedCommitDescriptor)commitWithLogEntry.getFirst();
        RepositoryLogEntryAggregate logEntry = (RepositoryLogEntryAggregate)commitWithLogEntry.getSecond();
        boolean isExecutionOnly = assessmentType == ETgaAssessmentType.EXECUTION_ONLY;
        boolean isExternalAnalysisCommit = false;
        boolean isCodeCommit = false;
        if (logEntry.getCommitTypes() != null) {
            isExternalAnalysisCommit = logEntry.getCommitTypes().contains((Object)ECommitType.EXTERNAL_ANALYSIS);
            isCodeCommit = logEntry.getCommitTypes().contains((Object)ECommitType.CODE_COMMIT);
        }
        if (isExternalAnalysisCommit || commit.isMergeCommit()) {
            Set<MethodLocation> newlyCoveredMethods = touchedFilesCalculator.calculateNewlyCoveredMethodsForCommit((CommitDescriptor)commit);
            newlyCoveredMethods = architectureOrCodeScopeAdjuster.filterTouchedMethodsThatNeedNoUpdate(newlyCoveredMethods);
            ETestGapState coveredState = ETestGapState.TESTED_CHURN;
            if (isExecutionOnly) {
                coveredState = ETestGapState.EXECUTED;
            }
            trendDataCache.methodsHaveBeenCovered(newlyCoveredMethods, coveredState);
        }
        if (!(partitions = touchedFilesCalculator.requiresFullPartitionUpdate(commit, isExecutionOnly)).isEmpty()) {
            TgaPathRequest request = TgaPathRequest.createRequest((CommitDescriptor)commit, TgaTrendComputer.getPartitionsCoverageSource(partitions), timeIntervalParameters, tgaRequestParameters, assessmentType, this.indexLayer, this.projectId);
            AssessedTgaData assessedData = request.fetchAndAssessData();
            List<AssessedTgaData.AssessedMethodData> filteredMethods = assessedData.filterByGrayState(true);
            trendDataCache.methodsHaveBeenCovered(CollectionUtils.map(filteredMethods, AssessedTgaData.AssessedMethodData::getLocation), ETestGapState.EXECUTED);
        }
        if (isCodeCommit) {
            Set<UniformPath> filesThatNeedToBeRecalculated = touchedFilesCalculator.calculateTouchedFilesForCommit((CommitDescriptor)commit);
            filesThatNeedToBeRecalculated = architectureOrCodeScopeAdjuster.adjustFilesThatNeedToBeRecalculated(filesThatNeedToBeRecalculated);
            architectureOrCodeScopeAdjuster.invalidateRemovedFiles();
            TgaFileListRequest request = TgaFileListRequest.createRequest(new ArrayList<UniformPath>(filesThatNeedToBeRecalculated), (CommitDescriptor)commit, coverageParameters, assessmentType, timeIntervalParameters, this.indexLayer, this.projectId, this.projectStorageSystem);
            AssessedTgaData assessedData = request.fetchAndAssessData();
            trendDataCache.invalidateFiles(filesThatNeedToBeRecalculated);
            trendDataCache.addData(assessedData);
        }
    }

    private static @NonNull ITgaCoverageSourceParameter getPartitionsCoverageSource(final Set<String> partitions) {
        return new ITgaCoverageSourceParameter(){

            @Override
            public boolean useAllPartitions() {
                return false;
            }

            @Override
            public List<String> getPartitions() {
                return new ArrayList<String>(partitions);
            }

            @Override
            public List<String> getCrossAnnotationProjectPatterns() {
                return List.of();
            }
        };
    }

    private static @NonNull List<CommitDescriptor> getCodeCommits(PairList<ParentedCommitDescriptor, RepositoryLogEntryAggregate> commitsWithLogEntries) {
        ArrayList<CommitDescriptor> commitsToPreload = new ArrayList<CommitDescriptor>();
        for (Pair commitWithLogEntry : commitsWithLogEntries) {
            ParentedCommitDescriptor commit = (ParentedCommitDescriptor)commitWithLogEntry.getFirst();
            RepositoryLogEntryAggregate logEntry = (RepositoryLogEntryAggregate)commitWithLogEntry.getSecond();
            Set<ECommitType> commitTypes = logEntry.getCommitTypes();
            if (commitTypes == null || !commitTypes.contains((Object)ECommitType.CODE_COMMIT)) continue;
            commitsToPreload.add((CommitDescriptor)commit);
        }
        return commitsToPreload;
    }

    private static @NonNull List<CommitDescriptor> getCoverageOrMergeCommits(PairList<ParentedCommitDescriptor, RepositoryLogEntryAggregate> commitsWithLogEntries) {
        ArrayList<CommitDescriptor> commitsToPreload = new ArrayList<CommitDescriptor>();
        for (Pair commitWithLogEntry : commitsWithLogEntries) {
            ParentedCommitDescriptor commit = (ParentedCommitDescriptor)commitWithLogEntry.getFirst();
            RepositoryLogEntryAggregate logEntry = (RepositoryLogEntryAggregate)commitWithLogEntry.getSecond();
            boolean isExternalAnalysisCommit = false;
            if (logEntry.getCommitTypes() != null) {
                isExternalAnalysisCommit = logEntry.getCommitTypes().contains((Object)ECommitType.EXTERNAL_ANALYSIS);
            }
            if (!isExternalAnalysisCommit && !commit.isMergeCommit()) continue;
            commitsToPreload.add((CommitDescriptor)commit);
        }
        return commitsToPreload;
    }

    public record TgaTrendEntry(long timestamp, Map<ETestGapState, Integer> counts) {
    }
}

