/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.google.common.collect.Sets;
import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.testimpact.PartitionedTestSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public class MethodToTestsMappingUpdater {
    private final Set<String> affectedPartitions = new HashSet<String>();
    private final SetMap<MethodId, PartitionAndPath> addedTestsByMethod = new SetMap();
    private final SetMap<MethodId, PartitionAndPath> removedTestsByMethod = new SetMap();

    public synchronized void markAsNewlyCoveredByTest(MethodId method, PartitionAndPath test) {
        if (this.removedTestsByMethod.contains((Object)method, (Object)test)) {
            throw new IllegalStateException("Method " + String.valueOf(method) + " and " + String.valueOf(test) + " is already contained in the remove operations.");
        }
        this.addedTestsByMethod.add((Object)method, (Object)test);
        this.affectedPartitions.add(test.getPartition());
    }

    public synchronized void markAsNoLongerCoveredByTest(MethodId method, PartitionAndPath test) {
        if (this.addedTestsByMethod.contains((Object)method, (Object)test)) {
            throw new IllegalStateException("Method " + String.valueOf(method) + " and " + String.valueOf(test) + " is already contained in the add operations.");
        }
        this.removedTestsByMethod.add((Object)method, (Object)test);
        this.affectedPartitions.add(test.getPartition());
    }

    public synchronized void applyTo(Map<MethodId, PartitionedTestSet> methodToTestsMapping) {
        methodToTestsMapping.forEach((method, tests) -> {
            tests.addAll((Set)this.addedTestsByMethod.getCollectionOrEmpty(method));
            tests.removeAll((Set)this.removedTestsByMethod.getCollectionOrEmpty(method));
        });
    }

    public synchronized Set<MethodId> getAffectedMethods() {
        return Sets.union((Set)this.addedTestsByMethod.getKeys(), (Set)this.removedTestsByMethod.getKeys());
    }

    public synchronized UnmodifiableSet<String> getAffectedPartitions() {
        return CollectionUtils.asUnmodifiable(this.affectedPartitions);
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }
}

