/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests;

import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

@Index(name="spec-item-test-reference", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class SpecItemTestReferenceIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "spec-item-test-reference";
    private static final String PREFIX_SPEC_ITEM = "spec-item";
    private static final String PREFIX_TEST_REFERENCE = "test-reference";
    private final ValueIndex<HashSet<PartitionAndPath>> delegateIndexBySpecItem;
    private final ValueIndex<HashSet<String>> delegateIndexByTestReference;

    public SpecItemTestReferenceIndex(IStore store) {
        this.delegateIndexBySpecItem = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, PREFIX_SPEC_ITEM));
        this.delegateIndexByTestReference = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, PREFIX_TEST_REFERENCE));
    }

    @VisibleForTesting
    public void addTestReference(String specItemId, Set<PartitionAndPath> testReferences) throws StorageException {
        this.delegateIndexBySpecItem.setOrMergeValue(specItemId, new HashSet<PartitionAndPath>(testReferences), (x$0, xva$1) -> CollectionUtils.unionSet((Collection)x$0, (Collection[])new Collection[]{xva$1}));
        PairList byTestReferences = new PairList();
        testReferences.forEach(testReference -> byTestReferences.add((Object)testReference.toString(), new HashSet<String>(Collections.singleton(specItemId))));
        this.delegateIndexByTestReference.setOrMergeValues(byTestReferences, (x$0, xva$1) -> CollectionUtils.unionSet((Collection)x$0, (Collection[])new Collection[]{xva$1}));
    }

    public void setTestReferences(Map<TeamscaleIssueId, Set<PartitionAndPath>> verifiedTestsBySpecItem) throws StorageException {
        PairList bySpecItems = new PairList();
        HashMap byTestReferences = new HashMap();
        for (TeamscaleIssueId specItemId : verifiedTestsBySpecItem.keySet()) {
            HashSet partitionAndPaths = new HashSet(verifiedTestsBySpecItem.get(specItemId));
            bySpecItems.add((Object)specItemId.toString(), partitionAndPaths);
            partitionAndPaths.forEach(partitionAndPath -> byTestReferences.merge(partitionAndPath.toString(), new HashSet<String>(Collections.singleton(specItemId.toString())), (x$0, xva$1) -> CollectionUtils.unionSet((Collection)x$0, (Collection[])new Collection[]{xva$1})));
        }
        this.delegateIndexBySpecItem.setValues(bySpecItems);
        this.delegateIndexByTestReference.setValues(PairList.fromMap(byTestReferences));
    }

    public @NonNull ArrayList<PartitionAndPath> getTestReference(String specItemId) throws StorageException {
        return new ArrayList<PartitionAndPath>(Objects.requireNonNullElse((HashSet)this.delegateIndexBySpecItem.getValue(specItemId), new HashSet()));
    }

    public List<HashSet<PartitionAndPath>> getTestReferences(List<String> specItemIds) throws StorageException {
        return new ArrayList<HashSet<PartitionAndPath>>(this.delegateIndexBySpecItem.getValues(specItemIds));
    }

    public Map<String, HashSet<PartitionAndPath>> getTestReferencesWithSpecItemIds(List<String> specItemIds) throws StorageException {
        return this.delegateIndexBySpecItem.getValuesByKeys(specItemIds);
    }

    public void removeTestReferences(Collection<PartitionAndPath> deletedPartitionAndPaths) throws StorageException {
        Set testReferencesToDelete = deletedPartitionAndPaths.stream().map(PartitionAndPath::toString).collect(Collectors.toSet());
        List affectedSpecItemIds = this.delegateIndexByTestReference.getValues(new ArrayList(testReferencesToDelete)).stream().filter(Objects::nonNull).flatMap(Collection::stream).toList();
        this.delegateIndexByTestReference.removeValues(testReferencesToDelete);
        HashMap<TeamscaleIssueId, Set<PartitionAndPath>> entriesToReplace = new HashMap<TeamscaleIssueId, Set<PartitionAndPath>>();
        HashSet<String> specItemsToDelete = new HashSet<String>();
        Map affectedEntries = this.delegateIndexBySpecItem.getValuesByKeys(affectedSpecItemIds);
        for (String key : affectedEntries.keySet()) {
            for (PartitionAndPath deletedPartitionAndPath : deletedPartitionAndPaths) {
                SpecItemTestReferenceIndex.computeEntriesToReplaceIfKeyNeedsToBeDeleted(affectedEntries, entriesToReplace, specItemsToDelete, deletedPartitionAndPath, key);
            }
        }
        this.delegateIndexBySpecItem.removeValues(new ArrayList(specItemsToDelete));
        this.setTestReferences(entriesToReplace);
    }

    private static void computeEntriesToReplaceIfKeyNeedsToBeDeleted(Map<String, HashSet<PartitionAndPath>> affectedEntries, Map<TeamscaleIssueId, Set<PartitionAndPath>> entriesToReplace, Set<String> keysToDelete, PartitionAndPath deletedPartitionAndPath, String key) {
        Set<PartitionAndPath> storedPartitionsAndPaths;
        if (keysToDelete.contains(key)) {
            return;
        }
        if (entriesToReplace.containsKey(TeamscaleIssueId.fromInternalId((String)key))) {
            storedPartitionsAndPaths = entriesToReplace.get(TeamscaleIssueId.fromInternalId((String)key));
        } else {
            HashSet<PartitionAndPath> partitionAndPaths = affectedEntries.get(key);
            if (partitionAndPaths == null) {
                return;
            }
            storedPartitionsAndPaths = partitionAndPaths;
            if (!storedPartitionsAndPaths.contains(deletedPartitionAndPath)) {
                return;
            }
        }
        storedPartitionsAndPaths.remove(deletedPartitionAndPath);
        if (storedPartitionsAndPaths.isEmpty()) {
            keysToDelete.add(key);
            entriesToReplace.remove(TeamscaleIssueId.fromInternalId((String)key));
        } else {
            entriesToReplace.put(TeamscaleIssueId.fromInternalId((String)key), storedPartitionsAndPaths);
        }
    }
}

