/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests;

import com.google.common.collect.Lists;
import com.teamscale.index.tests.IQueryableTestHistoryIndex;
import com.teamscale.index.tests.TestHistoryEntry;
import com.teamscale.index.tests.TestHistoryIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IUtilityIndex;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectDescriber;
import org.conqat.engine.persistence.index.keyed.TimedShallowObjectState;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.VisibleForTesting;

public class TestHistoryByPartitionDelegateIndex
implements IQueryableTestHistoryIndex,
IUtilityIndex {
    private static final Set<String> PARTITIONED_COLUMNS = Set.of("duration", "result", "partitions");
    private static final String PATH_PARTITION_SEPARATOR = "\u001d";
    private final TestHistoryIndex testHistoryIndex;

    public TestHistoryByPartitionDelegateIndex(TestHistoryIndex testHistoryIndex) {
        this.testHistoryIndex = testHistoryIndex;
    }

    public IStore getWrappedStore() {
        throw new UnsupportedOperationException("This index does not operate on a raw store");
    }

    @Override
    public List<TestHistoryEntry> getAllObjects() throws StorageException {
        return this.testHistoryIndex.getAllObjects().stream().map(TestHistoryEntry::expandToOnePerPartition).flatMap(Collection::stream).toList();
    }

    public Set<String> getAllIds() throws StorageException {
        return this.testHistoryIndex.mapAllObjects(pair -> {
            ArrayList<String> result = new ArrayList<String>();
            for (String partition : ((TestHistoryEntry)pair.getSecond()).getPartitions()) {
                result.add(TestHistoryByPartitionDelegateIndex.composeId((String)pair.getFirst(), partition));
            }
            return result;
        }).stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public IKeyedObjectDescriber<TestHistoryEntry> getDescriber() {
        return this.testHistoryIndex.getDescriber();
    }

    public TestHistoryEntry getById(String id) throws StorageException {
        PartitionAndPath pathAndPartition = TestHistoryByPartitionDelegateIndex.decomposeId(id);
        String path = pathAndPartition.getUniformPath();
        String partition = pathAndPartition.getPartition();
        return ((TestHistoryEntry)this.testHistoryIndex.getById(path)).copyWithDataForPartitionOnly(partition);
    }

    @Override
    public List<TestHistoryEntry> getByIds(List<String> ids) throws StorageException {
        List<String> pathLevelIds = ids.stream().map(TestHistoryByPartitionDelegateIndex::extractPathPart).toList();
        List<TestHistoryEntry> historyEntriesById = this.testHistoryIndex.getByIds(pathLevelIds).stream().filter(Objects::nonNull).toList();
        List pathLevelTestEntries = historyEntriesById.stream().map(TestHistoryEntry::expandToOnePerPartition).flatMap(Collection::stream).toList();
        Map composedIdToEntryMap = pathLevelTestEntries.stream().map(TestHistoryEntry::expandToOnePerPartitionPaired).flatMap(Collection::stream).map(pair -> Map.entry(TestHistoryByPartitionDelegateIndex.composeId(((TestHistoryEntry)pair.getValue()).getUniformPath(), (String)pair.getKey()), (TestHistoryEntry)pair.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldEntry, newEntry) -> oldEntry, HashMap::new));
        return ids.stream().map(composedIdToEntryMap::get).collect(Collectors.toList());
    }

    public List<TimedShallowObjectState> query(List<String> valueColumns, PairList<String, String> exactValueColumns) throws StorageException {
        return this.query(valueColumns, exactValueColumns, 0x7FFFFFFFFFFFFFFEL);
    }

    private Collection<TimedShallowObjectState> expandToPartitionLevel(TimedShallowObjectState testLevelResult, List<String> allColumnNames) {
        boolean isPartitioned;
        String columnName;
        int finalColumnIndex;
        int columnIndex;
        HashMap partitionLevelResults = new HashMap();
        TimedShallowObjectState partitionIndependentObjectState = new TimedShallowObjectState(testLevelResult.getId(), testLevelResult.columnCount());
        for (columnIndex = 0; columnIndex < testLevelResult.columnCount(); ++columnIndex) {
            finalColumnIndex = columnIndex;
            columnName = allColumnNames.get(columnIndex);
            isPartitioned = PARTITIONED_COLUMNS.contains(columnName);
            testLevelResult.iterateValues(columnIndex, (timestamp, valueAtTimestamp) -> {
                if (isPartitioned) {
                    String[] valueList;
                    for (String value : valueList = valueAtTimestamp.split(",")) {
                        String[] partitionAndItsValue = value.split("=", 2);
                        String partition = partitionAndItsValue[0];
                        TimedShallowObjectState partitionLevelResult = (TimedShallowObjectState)partitionLevelResults.get(partition);
                        if (partitionLevelResult == null) {
                            partitionLevelResult = new TimedShallowObjectState(TestHistoryByPartitionDelegateIndex.composeId(testLevelResult.getId(), partition), testLevelResult.columnCount());
                            partitionLevelResults.put(partition, partitionLevelResult);
                        }
                        partitionLevelResult.insert(finalColumnIndex, timestamp.longValue(), value);
                    }
                } else {
                    partitionIndependentObjectState.insert(finalColumnIndex, timestamp.longValue(), valueAtTimestamp);
                }
            });
        }
        if (partitionLevelResults.isEmpty()) {
            return List.of(partitionIndependentObjectState);
        }
        for (columnIndex = 0; columnIndex < testLevelResult.columnCount(); ++columnIndex) {
            finalColumnIndex = columnIndex;
            columnName = allColumnNames.get(columnIndex);
            isPartitioned = PARTITIONED_COLUMNS.contains(columnName);
            testLevelResult.iterateValues(columnIndex, (value, valueAtTimestamp) -> {
                if (isPartitioned) {
                    return;
                }
                for (Map.Entry partitionEntry : partitionLevelResults.entrySet()) {
                    ((TimedShallowObjectState)partitionEntry.getValue()).insert(finalColumnIndex, value.longValue(), valueAtTimestamp);
                }
            });
        }
        return partitionLevelResults.values();
    }

    public List<TimedShallowObjectState> query(List<String> valueColumns, PairList<String, String> exactValueColumns, long timestamp) throws StorageException {
        List testLevelResults = this.testHistoryIndex.query(valueColumns, exactValueColumns, timestamp);
        LinkedHashSet<String> allColumnNamesOrderedSet = new LinkedHashSet<String>();
        allColumnNamesOrderedSet.addAll(valueColumns);
        allColumnNamesOrderedSet.addAll(exactValueColumns.extractFirstList());
        List<String> allColumnNames = List.copyOf(allColumnNamesOrderedSet);
        ArrayList<TimedShallowObjectState> partitionLevelResults = new ArrayList<TimedShallowObjectState>(testLevelResults.size());
        for (TimedShallowObjectState testLevelResult : testLevelResults) {
            Collection<TimedShallowObjectState> expandedResult = this.expandToPartitionLevel(testLevelResult, allColumnNames);
            partitionLevelResults.addAll(expandedResult);
        }
        return partitionLevelResults;
    }

    public Collection<String> getAlwaysQueryColumns() {
        return Collections.singleton("partitions");
    }

    public PairList<String, EKeyedObjectType> getKnownColumns() throws StorageException {
        return this.testHistoryIndex.getKnownColumns();
    }

    public EKeyedObjectType getColumnType(String columnName) throws StorageException {
        return this.testHistoryIndex.getColumnType(columnName);
    }

    public List<String> getKnownValues(String key) throws StorageException {
        return List.copyOf(this.testHistoryIndex.getKnownValues(key).stream().map(s -> Lists.newArrayList((Object[])s.split(","))).flatMap(Collection::stream).collect(Collectors.toSet()));
    }

    @VisibleForTesting
    public static String composeId(String path, String partition) {
        return path + PATH_PARTITION_SEPARATOR + partition;
    }

    private static PartitionAndPath decomposeId(String identifier) {
        String partition = "";
        String[] separated = identifier.split(PATH_PARTITION_SEPARATOR);
        String path = separated[0];
        if (separated.length == 2) {
            partition = separated[1];
        }
        return new PartitionAndPath(partition, path);
    }

    private static String extractPathPart(String identifier) {
        return TestHistoryByPartitionDelegateIndex.decomposeId(identifier).getUniformPath();
    }
}

