/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests.extractor.mathworks;

import com.teamscale.index.dependencies.TypeIndexCache;
import com.teamscale.index.testimpact.TestImplementation;
import com.teamscale.index.tests.extractor.ITestCaseExtractionStrategy;
import com.teamscale.index.tests.extractor.TokenElementTransformContext;
import com.teamscale.index.tests.extractor.mathworks.MathWorksClassBasedTestCaseExtractionStrategy;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.utils.FileNameUtils;
import org.conqat.lib.commons.collections.PairList;

public class MathWorksFunctionBasedTestCaseExtractionStrategy
implements ITestCaseExtractionStrategy {
    @Override
    public PairList<String, TestImplementation> extractTestCases(TokenElementTransformContext context, TypeIndexCache typeIndex) {
        List<ShallowEntity> functionEntities = context.getShallowEntitiesWithPreprocessorTokens().stream().filter(entity -> entity.getSubtype().equals("function")).toList();
        String mainFunctionName = null;
        ArrayList<ShallowEntity> testFunctions = new ArrayList<ShallowEntity>();
        for (ShallowEntity functionEntity : functionEntities) {
            String functionName = functionEntity.getName();
            if (MathWorksFunctionBasedTestCaseExtractionStrategy.isMainTestFunction(context, functionName)) {
                mainFunctionName = functionName;
                continue;
            }
            if (!MathWorksFunctionBasedTestCaseExtractionStrategy.isTestFunction(functionEntity)) continue;
            testFunctions.add(functionEntity);
        }
        if (mainFunctionName == null) {
            return PairList.emptyPairList();
        }
        PairList result = new PairList();
        for (ShallowEntity testFunction : testFunctions) {
            result.add(MathWorksClassBasedTestCaseExtractionStrategy.extractNameAndTestImplementation(mainFunctionName, context, testFunction));
        }
        return result;
    }

    private static boolean isMainTestFunction(TokenElementTransformContext context, String functionName) {
        return (MathWorksFunctionBasedTestCaseExtractionStrategy.isTestFunctionName(functionName) || functionName.endsWith("Tests")) && FileNameUtils.getBaseName((String)context.getUniformPath()).equals(functionName);
    }

    private static boolean isTestFunction(ShallowEntity functionEntity) {
        if (!MathWorksFunctionBasedTestCaseExtractionStrategy.isTestFunctionName(functionEntity.getName())) {
            return false;
        }
        return LanguageFeatureParser.MATLAB.containsInputParameter(functionEntity, "testCase");
    }

    private static boolean isTestFunctionName(String functionName) {
        String functionNameLowerCase = functionName.toLowerCase();
        return functionNameLowerCase.startsWith("test") || functionNameLowerCase.endsWith("test");
    }
}

