/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests.extractor.pytest_unittest;

import com.teamscale.index.dependencies.TypeIndexCache;
import com.teamscale.index.testimpact.TestImplementation;
import com.teamscale.index.tests.extractor.ITestCaseExtractionStrategy;
import com.teamscale.index.tests.extractor.TestCaseExtractionUtils;
import com.teamscale.index.tests.extractor.TokenElementTransformContext;
import eu.cqse.check.framework.core.xpath.DocumentRootShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Optional;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class PytestAndUnittestTestCaseExtractionStrategy
implements ITestCaseExtractionStrategy {
    private static final String PYTEST_TEST_METHOD_PREFIX = "test_";

    @Override
    public PairList<String, TestImplementation> extractTestCases(TokenElementTransformContext context, TypeIndexCache typeIndex) {
        PairList extractedTestCases = new PairList();
        UnmodifiableList<ShallowEntity> entities = context.getShallowEntitiesWithPreprocessorTokens();
        DocumentRootShallowEntity.wrapWithRootIfNecessary(entities, (String)context.getUniformPath());
        for (ShallowEntity entity : entities) {
            if (entity.getType() == EShallowEntityType.TYPE) {
                extractedTestCases.addAll(PytestAndUnittestTestCaseExtractionStrategy.extractTestCasesFromTestClass(context, entity));
                continue;
            }
            if (entity.getType() != EShallowEntityType.METHOD) continue;
            extractedTestCases.addAll(PytestAndUnittestTestCaseExtractionStrategy.extractTestCasesFromTestMethod(context, "", entity));
        }
        return extractedTestCases;
    }

    private static PairList<String, TestImplementation> extractTestCasesFromTestClass(TokenElementTransformContext context, ShallowEntity classEntity) {
        PairList result = new PairList();
        for (int i = 0; i < classEntity.getChildren().size(); ++i) {
            result.addAll(PytestAndUnittestTestCaseExtractionStrategy.extractTestCasesFromTestMethod(context, classEntity.getName(), (ShallowEntity)classEntity.getChildren().get(i)));
        }
        return result;
    }

    private static PairList<String, TestImplementation> extractTestCasesFromTestMethod(TokenElementTransformContext context, String testClassName, ShallowEntity testEntity) {
        PairList result = new PairList();
        result.addIfPresent(PytestAndUnittestTestCaseExtractionStrategy.extractTestCaseAlwaysUnparameterized(context, testClassName, testEntity));
        return result;
    }

    private static Optional<Pair<String, TestImplementation>> extractTestCaseAlwaysUnparameterized(TokenElementTransformContext context, String testClassName, ShallowEntity entity) {
        if (entity.getName() == null || !entity.getName().startsWith(PYTEST_TEST_METHOD_PREFIX)) {
            return Optional.empty();
        }
        UniformPath testPath = TestCaseExtractionUtils.convertToTestImplementationUniformPath(context.getUniformPath(), testClassName, entity.getName());
        Object testName = entity.getName();
        if (!StringUtils.isEmpty((String)testClassName)) {
            testName = testClassName + UniformPathUtils.SEPARATOR + (String)testName;
        }
        return Optional.of(TestCaseExtractionUtils.buildTestUniformPathWithTestImplementation((String)testName, context, testPath, entity));
    }
}

