/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking;

import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.findings.DerivedFindingsIndex;
import com.teamscale.core.findings.FindingsIndex;
import com.teamscale.core.findings.FindingsIndexBase;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.core.option.project.ProjectOptionRegistry;
import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.code_change.CodeChangeIndex;
import com.teamscale.index.metrics.FindingsCountMetricUtils;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import com.teamscale.index.tracking.FindingChurnCount;
import com.teamscale.index.tracking.FindingChurnList;
import com.teamscale.index.tracking.FindingDeltaUtils;
import com.teamscale.index.tracking.FindingIdManager;
import com.teamscale.index.tracking.PartitionTrackingGroupsOption;
import com.teamscale.index.tracking.algorithm.FindingsTrackingAlgorithm;
import com.teamscale.index.tracking.algorithm.FindingsTrackingResult;
import com.teamscale.index.tracking.algorithm.TrackedElement;
import com.teamscale.index.tracking.algorithm.TrackedFindingWithContext;
import com.teamscale.index.tracking.index.FindingChurnCountIndex;
import com.teamscale.index.tracking.index.FindingChurnListIndex;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.index.tracking.index.TrackedFindingsIndex;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jspecify.annotations.Nullable;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class FindingsTracker
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int DETERMINE_DELETED_KEYS_CHUNK_SIZE = 5000;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ElementHistoryIndex historyIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FindingChurnListIndex findingChurnListIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FindingChurnCountIndex findingChurnCountIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CodeChangeIndex codeChangeIndex;
    @DeltaSource(value=CodeChangeIndex.class)
    private KeyDelta codeChangeDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ProjectOptionIndex projectOptionIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CommitDescriptorIndex commitDescriptorIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MetaIndex projectMetaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="metrics")
    private MetricsIndex metricsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private FindingsIndex plainFindingsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private DerivedFindingsIndex derivedFindingsIndex;
    @DeltaSource(value=FindingsIndex.class)
    private KeyDelta plainFindingsDelta;
    @DeltaSource(value=DerivedFindingsIndex.class)
    private KeyDelta derivedFindingsDelta;
    private ListMap<String, UniformPath> allAddedFindingsKeysByPartition;
    private ListMap<String, UniformPath> allDeletedFindingsKeysByPartition;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private TrackedFindingsIndex trackedFindingsIndex;
    @IndexAccess(value=EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY)
    private List<TrackedFindingsIndex> previousTrackedFindingsIndexes;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private TrackedFindingsByIdIndex trackedFindingsByIdIndex;
    @IndexAccess(value=EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY)
    private List<TrackedFindingsByIdIndex> previousTrackedFindingsByIdIndexes;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    private TokenElementIndex changedContentIndex;
    @IndexAccess(value=EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY, indexName="content")
    private List<TokenElementIndex> baselineContentIndexes;
    private Set<Set<String>> partitionTrackingGroups;
    private final Map<String, String> trackingGroupNameByPartition = new HashMap<String, String>();
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FindingBlacklistIndex blacklistIndex;
    @StepParameterObject
    public final FindingIdManager idManager = new FindingIdManager();

    private void init() throws StorageException {
        this.idManager.init(this.projectMetaIndex.getDefaultBranchName());
        this.allAddedFindingsKeysByPartition = this.unionFindingIndexKeys((List<StorageKey>)this.plainFindingsDelta.getAddedOrChangedKeys(), (List<StorageKey>)this.derivedFindingsDelta.getAddedOrChangedKeys());
        this.allDeletedFindingsKeysByPartition = this.unionFindingIndexKeys((List<StorageKey>)this.plainFindingsDelta.getDeletedKeys(), (List<StorageKey>)this.derivedFindingsDelta.getDeletedKeys());
        ProjectOptionRegistry projectOptionRegistry = ProjectOptionRegistry.getInstance();
        this.partitionTrackingGroups = ((PartitionTrackingGroupsOption)projectOptionRegistry.getOption("<p>", "partition.tracking-groups", null, PartitionTrackingGroupsOption.class, (OptionIndexBase)this.projectOptionIndex)).getPartitionTrackingGroups();
        int groupCount = 0;
        for (Set<String> partitionTrackingGroup : this.partitionTrackingGroups) {
            for (String group : partitionTrackingGroup) {
                this.trackingGroupNameByPartition.put(group, "partition-tracking-group-" + groupCount);
            }
            ++groupCount;
        }
    }

    private ListMap<String, UniformPath> unionFindingIndexKeys(List<StorageKey> findingIndexKeys, List<StorageKey> derivedFindingIndexKeys) throws StorageException {
        ListMap pathsByPartition = new ListMap();
        this.plainFindingsIndex.getPartitionAndPathsForRawKeys(CollectionUtils.map(findingIndexKeys, StorageKey::getKey)).forEach(partitionAndPath -> pathsByPartition.add((Object)partitionAndPath.getPartition(), (Object)partitionAndPath.toUniformPath()));
        this.derivedFindingsIndex.getPartitionAndPathsForRawKeys(CollectionUtils.map(derivedFindingIndexKeys, StorageKey::getKey)).forEach(partitionAndPath -> pathsByPartition.add((Object)partitionAndPath.getPartition(), (Object)partitionAndPath.toUniformPath()));
        return pathsByPartition;
    }

    public void execute() throws StorageException, ExecutionException, InterruptedException {
        this.init();
        SetMap<UniformPath, TrackedFinding> changedFindingsForUniformPath = this.createChangedFindingsForUniformPathMap();
        SetMap<UniformPath, TrackedFinding> baselineFindingsForUniformPath = this.fetchBaselineFindingsForUniformPath();
        SetMap<UniformPath, TrackedFinding> unchangedFindingsForUniformPath = this.filterUnchangedPartitionsForUniformPath(baselineFindingsForUniformPath);
        this.removeUnchangedBaselineFindingsNoPartitionGroup(baselineFindingsForUniformPath, unchangedFindingsForUniformPath);
        Collection baselineFindings = baselineFindingsForUniformPath.getValues();
        Collection changedFindings = changedFindingsForUniformPath.getValues();
        List<Collection<TrackedFinding>> baselineFindingsByBranch = this.getBaselineFindingsByBranch(changedFindingsForUniformPath, baselineFindings);
        FindingsTrackingAlgorithm trackingAlgorithm = this.createTrackingAlgorithm();
        this.getProfilingMonitor().startProfiling("tracking");
        FindingsTrackingResult trackingResult = trackingAlgorithm.performTracking(baselineFindingsByBranch, changedFindings, this.getParallelTaskExecutor());
        PairList<TrackedFindingWithContext, TrackedFindingWithContext> trackedWithContext = trackingResult.trackingResult();
        this.getProfilingMonitor().stopProfiling("tracking");
        PairList<TrackedFinding, TrackedFinding> tracked = trackedWithContext.map(TrackedFindingWithContext::getFinding, TrackedFindingWithContext::getFinding);
        tracked = FindingsTracker.removeDuplicateIds(tracked);
        FindingsTracker.synchronizeLocationAndTimestamp(tracked);
        for (UniformPath uniformPath : unchangedFindingsForUniformPath.getKeys()) {
            ((Set)baselineFindingsForUniformPath.getCollectionOrEmpty((Object)uniformPath)).removeAll(unchangedFindingsForUniformPath.getCollectionOrEmpty((Object)uniformPath));
        }
        FindingChurnList churnList = this.createChurnList(tracked, (UnmodifiableList<TrackedFindingWithContext>)trackedWithContext.getFirstList(), unchangedFindingsForUniformPath.getValues(), changedFindings, baselineFindings);
        this.updateIdsAndPersistTrackedFindings(changedFindingsForUniformPath, unchangedFindingsForUniformPath, trackingAlgorithm, tracked, churnList, trackingResult.changedElements());
    }

    private void updateIdsAndPersistTrackedFindings(SetMap<UniformPath, TrackedFinding> changedFindingsForUniformPath, SetMap<UniformPath, TrackedFinding> unchangedFindingsForUniformPath, FindingsTrackingAlgorithm trackingAlgorithm, PairList<TrackedFinding, TrackedFinding> tracked, FindingChurnList churnList, Map<String, TrackedElement> changedElements) throws StorageException, ExecutionException, InterruptedException {
        this.getProfilingMonitor().startProfiling("determine-ids");
        Map<String, String> idMap = this.idManager.determineIds((List<TrackedFinding>)churnList.getAddedFindings(), (List<TrackedFinding>)churnList.getFindingsAddedInBranch(), changedElements, this.getSchedulingCommit(), this.trackedFindingsByIdIndex);
        this.getProfilingMonitor().stopProfiling("determine-ids");
        tracked.forEach((finding1, finding2) -> idMap.putIfAbsent(finding2.getId(), finding1.getId()));
        this.transferFlaggingInformationToBranch(idMap);
        Function<TrackedFinding, TrackedFinding> idUpdater = FindingsTracker.getIdUpdater(idMap);
        churnList = new FindingChurnList(this.getSchedulingCommit(), CollectionUtils.map(churnList.getAddedFindings(), idUpdater), (List<TrackedFinding>)churnList.getFindingsInChangedCode(), (List<TrackedFinding>)churnList.getRemovedFindings(), (List<TrackedFinding>)churnList.getFindingsAddedInBranch(), (List<TrackedFinding>)churnList.getFindingsRemovedInBranch());
        Map<String, TrackedFinding> baselineFindingForChangedId = FindingsTracker.createBaselineFindingForChangedIdMap(tracked, idMap);
        for (UniformPath key : changedFindingsForUniformPath.getKeys()) {
            Set findingsForUniformPath = (Set)changedFindingsForUniformPath.getCollectionOrEmpty((Object)key);
            List findingsToUpdate = CollectionUtils.filter((Collection)findingsForUniformPath, finding -> idMap.containsKey(finding.getId()));
            CollectionUtils.removeAll((Set)findingsForUniformPath, (List)findingsToUpdate);
            findingsForUniformPath.addAll(CollectionUtils.map((Collection)findingsToUpdate, idUpdater));
        }
        SetMap<UniformPath, TrackedFinding> updatedChangedFindingsForUniformPath = this.integrateTrackingInformation(changedFindingsForUniformPath, baselineFindingForChangedId);
        this.getProfilingMonitor().startProfiling("persist");
        this.persistResults(baselineFindingForChangedId.keySet(), churnList, updatedChangedFindingsForUniformPath, unchangedFindingsForUniformPath, trackingAlgorithm);
        this.getProfilingMonitor().stopProfiling("persist");
    }

    private void transferFlaggingInformationToBranch(Map<String, String> idMap) throws StorageException {
        if (FindingsTracker.isForkOrMergeCommit(this.commitDescriptorIndex.getCommit(this.getSchedulingCommit()))) {
            this.idManager.transferAllCrossBranchBlacklist(this.blacklistIndex, this.trackedFindingsByIdIndex, this.getSchedulingCommit().getTimestamp(), new HashSet<String>(idMap.values()));
        } else {
            this.idManager.transferBlacklistIfNeeded(new ArrayList<String>(idMap.values()), this.blacklistIndex, this.getSchedulingCommit().getTimestamp());
        }
    }

    private static boolean isForkOrMergeCommit(@Nullable ParentedCommitDescriptor commitDescriptor) {
        return commitDescriptor != null && (commitDescriptor.isMergeCommit() || CollectionUtils.allMatch((Collection)commitDescriptor.getParentCommits(), parent -> !parent.getBranchName().equals(commitDescriptor.getBranchName())));
    }

    private static PairList<TrackedFinding, TrackedFinding> removeDuplicateIds(PairList<TrackedFinding, TrackedFinding> trackedFindings) {
        HashSet idsInUse = new HashSet();
        return (PairList)trackedFindings.stream().filter(findingsPair -> idsInUse.add(((TrackedFinding)findingsPair.getFirst()).getId())).collect(PairList.toPairList());
    }

    private List<Collection<TrackedFinding>> getBaselineFindingsByBranch(SetMap<UniformPath, TrackedFinding> changedFindingsForUniformPath, Collection<TrackedFinding> baselineFindings) throws StorageException {
        ArrayList<Collection<TrackedFinding>> baselineFindingsByBranch = new ArrayList<Collection<TrackedFinding>>();
        baselineFindingsByBranch.add(baselineFindings);
        for (int branchIndex = 1; branchIndex < this.previousTrackedFindingsIndexes.size(); ++branchIndex) {
            List<TrackedFinding> filteredBaselineFindingsForBranch = this.fetchBaselineFindingsForBranch(changedFindingsForUniformPath, this.previousTrackedFindingsIndexes.get(branchIndex), baselineFindings);
            baselineFindingsByBranch.add(filteredBaselineFindingsForBranch);
        }
        return baselineFindingsByBranch;
    }

    private List<TrackedFinding> fetchBaselineFindingsForBranch(SetMap<UniformPath, TrackedFinding> changedFindingsForUniformPath, TrackedFindingsIndex trackedFindingsIndexOnBranch, Collection<TrackedFinding> baselineFindings) throws StorageException {
        ArrayList<UniformPath> affectedUniformPaths = new ArrayList<UniformPath>((Collection<UniformPath>)changedFindingsForUniformPath.getKeys());
        List<List<TrackedFinding>> parentFindingsLists = trackedFindingsIndexOnBranch.getFindings(affectedUniformPaths);
        List<TrackedFinding> parentFindings = parentFindingsLists.stream().filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        List<TrackedFinding> findingsOnMainBranch = this.trackedFindingsByIdIndex.getFindings(CollectionUtils.map(parentFindings, TrackedFinding::getId));
        HashSet<TrackedFinding> excluded = new HashSet<TrackedFinding>(baselineFindings);
        Set findingsLiveOnMainBranch = findingsOnMainBranch.stream().filter(finding -> finding != null && finding.getDeathCommit() == null && !excluded.contains(finding)).collect(Collectors.toSet());
        parentFindings.removeIf(findingsLiveOnMainBranch::contains);
        return parentFindings;
    }

    private void removeUnchangedBaselineFindingsNoPartitionGroup(SetMap<UniformPath, TrackedFinding> baselineFindingsForUniformPath, SetMap<UniformPath, TrackedFinding> unchangedFindingsForUniformPath) {
        Set groupedPartitions = this.partitionTrackingGroups.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        for (UniformPath uniformPath : unchangedFindingsForUniformPath.getKeys()) {
            List findingsToBeRemoved = CollectionUtils.filter((Collection)unchangedFindingsForUniformPath.getCollectionOrEmpty((Object)uniformPath), finding -> !groupedPartitions.contains(finding.getFindingIndexPartition()));
            CollectionUtils.removeAll((Set)((Set)baselineFindingsForUniformPath.getCollectionOrEmpty((Object)uniformPath)), (List)findingsToBeRemoved);
        }
    }

    private static Function<TrackedFinding, TrackedFinding> getIdUpdater(Map<String, String> idMap) {
        return oldFinding -> FindingsTracker.updateId(idMap, oldFinding);
    }

    private static TrackedFinding updateId(Map<String, String> idMap, TrackedFinding oldFinding) {
        String newId = idMap.get(oldFinding.getId());
        if (newId == null) {
            return oldFinding;
        }
        return TrackedFinding.Builder.from((TrackedFinding)oldFinding).withId(newId).build();
    }

    private static List<TrackedFinding> findingsDifference(Collection<TrackedFinding> baseFindings, Collection<TrackedFinding> findingsToRemove) {
        HashSet idsToRemove = new HashSet(CollectionUtils.map(findingsToRemove, TrackedFinding::getId));
        return CollectionUtils.filter(baseFindings, finding -> !idsToRemove.contains(finding.getId()));
    }

    private FindingsTrackingAlgorithm createTrackingAlgorithm() {
        return FindingsTrackingAlgorithm.createTrackingAlgorithm(this.getSchedulingCommit(), this.trackingGroupNameByPartition, this.changedContentIndex, this.baselineContentIndexes, this.historyIndex, this.getProfilingMonitor(), this.getProjectId());
    }

    private SetMap<UniformPath, TrackedFinding> createChangedFindingsForUniformPathMap() throws StorageException {
        SetMap<UniformPath, TrackedFinding> changedPlainFindings = this.computeChangedFindingsForUniformPath((FindingsIndexBase)this.plainFindingsIndex, this.plainFindingsDelta, null);
        Map<String, List<TrackedFinding>> groupedPlainFindings = ((Set)changedPlainFindings.getValues()).stream().collect(Collectors.groupingBy(this::makeGroupingKey, Collectors.toList()));
        SetMap<UniformPath, TrackedFinding> changedDerivedFindings = this.computeChangedFindingsForUniformPath((FindingsIndexBase)this.derivedFindingsIndex, this.derivedFindingsDelta, groupedPlainFindings);
        return new SetMap(new SetMap[]{changedPlainFindings, changedDerivedFindings});
    }

    private SetMap<UniformPath, TrackedFinding> fetchBaselineFindingsForUniformPath() throws StorageException {
        Set codeChangePaths = CollectionUtils.mapToSet((Collection)this.codeChangeDelta.getAddedOrChangedKeysAsStrings(), UniformPathCompatibilityUtil::convert);
        ArrayList<UniformPath> allUniformPaths = new ArrayList<UniformPath>(CollectionUtils.unionSet((Collection)codeChangePaths, (Collection[])new Collection[]{this.allAddedFindingsKeysByPartition.getValues(), this.allDeletedFindingsKeysByPartition.getValues()}));
        return FindingsCountMetricUtils.createPathToFindingsMap(this.trackedFindingsIndex, allUniformPaths);
    }

    private SetMap<UniformPath, TrackedFinding> filterUnchangedPartitionsForUniformPath(SetMap<UniformPath, TrackedFinding> baselineFindingsForUniformPath) {
        ListMap uniformPathsForPartitionList = new ListMap(this.allAddedFindingsKeysByPartition);
        uniformPathsForPartitionList.addAll(this.allDeletedFindingsKeysByPartition);
        SetMap changedPartitionsForUniformPath = new SetMap();
        for (String partition : uniformPathsForPartitionList.getKeys()) {
            List uniformPaths = (List)uniformPathsForPartitionList.getCollectionOrEmpty((Object)partition);
            for (UniformPath uniformPath : uniformPaths) {
                changedPartitionsForUniformPath.add((Object)uniformPath, (Object)partition);
            }
        }
        SetMap findingsInUnchangedPartitionsForUniformPath = new SetMap(SetMap.ESetFactory.IDENTITY_HASHSET);
        for (UniformPath uniformPath : baselineFindingsForUniformPath.getKeys()) {
            Set baselineFindings = (Set)baselineFindingsForUniformPath.getCollection((Object)uniformPath);
            if (baselineFindings == null) continue;
            List findingsInUnchangedPartitions = CollectionUtils.filter((Collection)baselineFindings, finding -> !((Set)changedPartitionsForUniformPath.getCollectionOrEmpty((Object)uniformPath)).contains(finding.getFindingIndexPartition()));
            findingsInUnchangedPartitionsForUniformPath.addAll((Object)uniformPath, (Collection)findingsInUnchangedPartitions);
        }
        return findingsInUnchangedPartitionsForUniformPath;
    }

    private FindingChurnList createChurnList(PairList<TrackedFinding, TrackedFinding> trackedFindings, UnmodifiableList<TrackedFindingWithContext> trackedFindingsWithContext, Collection<TrackedFinding> unchangedFindings, Collection<TrackedFinding> changedFindings, Collection<TrackedFinding> baselineFindings) throws StorageException {
        CommitDescriptor schedulingCommit = this.getSchedulingCommit();
        FindingChurnList churnList = new FindingChurnList(schedulingCommit);
        churnList.addAddedFindings(FindingsTracker.findingsDifference(changedFindings, (Collection<TrackedFinding>)trackedFindings.getSecondList()));
        churnList.addRemovedFindings(FindingsTracker.findingsDifference(baselineFindings, (Collection<TrackedFinding>)trackedFindings.getFirstList()));
        List findingsAddedInBranch = CollectionUtils.filterAndMap(trackedFindingsWithContext, findingWithContext -> findingWithContext.getBranchIndex() > 0, TrackedFindingWithContext::getFinding);
        churnList.addFindingsAddedInBranch(findingsAddedInBranch);
        ParentedCommitDescriptor commit = this.commitDescriptorIndex.getCommit(schedulingCommit);
        if (commit != null && !commit.isMergeCommit()) {
            churnList.addFindingsInChangedCode(this.codeChangeIndex.reduceToFindingsInChangedCode(trackedFindings.getFirstList(), schedulingCommit.getTimestamp()));
            churnList.addFindingsInChangedCode(this.codeChangeIndex.reduceToFindingsInChangedCode(unchangedFindings, schedulingCommit.getTimestamp()));
        }
        this.trackFindingsRemovedInBranch(churnList);
        churnList.getRemovedFindings().forEach(finding -> finding.setDeathCommit(schedulingCommit));
        return churnList;
    }

    private static void synchronizeLocationAndTimestamp(PairList<TrackedFinding, TrackedFinding> trackedFindings) {
        trackedFindings.forEach((baselineFinding, changedFinding) -> {
            baselineFinding.setLocation(changedFinding.getLocation());
            baselineFinding.setAnalysisTimestamp(changedFinding.getAnalysisTimestamp());
            baselineFinding.setMessage(changedFinding.getMessage());
            baselineFinding.setAssessment(changedFinding.getAssessment());
            baselineFinding.setProperties(changedFinding.getProperties());
        });
    }

    private static Map<String, TrackedFinding> createBaselineFindingForChangedIdMap(PairList<TrackedFinding, TrackedFinding> tracked, Map<String, String> idMap) {
        return tracked.stream().collect(Collectors.toMap(pair -> {
            String oldId = ((TrackedFinding)pair.getSecond()).getId();
            return idMap.getOrDefault(oldId, oldId);
        }, ImmutablePair::getFirst));
    }

    private void trackFindingsRemovedInBranch(FindingChurnList churnList) throws StorageException {
        PairList tracked = new PairList();
        for (int branchIndex = 1; branchIndex < this.previousTrackedFindingsIndexes.size(); ++branchIndex) {
            UnmodifiableList<TrackedFinding> removedFindings = churnList.getRemovedFindings();
            List removedIds = CollectionUtils.map(removedFindings, TrackedFinding::getId);
            if (new HashSet(removedIds).size() < removedIds.size()) {
                LOGGER.error("Had duplicate removed finding IDs! Will skip tracking of findings removed in this branch.");
                Set duplicates = CollectionUtils.getDuplicates((List)removedIds);
                for (TrackedFinding finding2 : CollectionUtils.filter(removedFindings, finding -> duplicates.contains(finding.getId()))) {
                    LOGGER.error("Duplicate: " + String.valueOf(finding2));
                }
                continue;
            }
            List allPreviousFindings = CollectionUtils.filterNullEntries(this.previousTrackedFindingsByIdIndexes.get(branchIndex).getFindings(removedIds));
            PairList<TrackedFinding, TrackedFinding> findingsRemovedInBranch = FindingsTracker.correlateRemovedFindingsById(allPreviousFindings, removedFindings);
            tracked.addAll(findingsRemovedInBranch);
            churnList.registerFindingsRemovedInBranch(findingsRemovedInBranch);
        }
        FindingsTracker.synchronizeLocationAndTimestamp((PairList<TrackedFinding, TrackedFinding>)tracked);
    }

    private static PairList<TrackedFinding, TrackedFinding> correlateRemovedFindingsById(Collection<TrackedFinding> removedInBranch, Collection<TrackedFinding> removedInMerge) {
        Map removedInBranchById = removedInBranch.stream().collect(Collectors.toMap(TrackedFinding::getId, Functions.identity()));
        PairList result = new PairList();
        for (TrackedFinding removedInMergeFinding : removedInMerge) {
            TrackedFinding removedInBranchFinding = (TrackedFinding)removedInBranchById.get(removedInMergeFinding.getId());
            if (removedInBranchFinding == null || removedInBranchFinding.getDeathCommit() == null) continue;
            removedInMergeFinding.setDeathCommit(removedInBranchFinding.getDeathCommit());
            result.add((Object)removedInBranchFinding, (Object)removedInMergeFinding);
        }
        return result;
    }

    private SetMap<UniformPath, TrackedFinding> integrateTrackingInformation(SetMap<UniformPath, TrackedFinding> changedFindingsForUniformPath, Map<String, TrackedFinding> baselineFindingForChangedId) throws StorageException {
        SetMap updatedChangedFindingsForUniformPath = new SetMap(new SetMap[]{changedFindingsForUniformPath});
        for (UniformPath uniformPath : changedFindingsForUniformPath.getKeys()) {
            Set findingsList = (Set)changedFindingsForUniformPath.getCollectionOrEmpty((Object)uniformPath);
            SupplierWithException codeScope = SupplierWithException.memoize(() -> this.getCodeScopeName(uniformPath));
            for (TrackedFinding changedFinding : findingsList) {
                if (!baselineFindingForChangedId.containsKey(changedFinding.getId())) continue;
                TrackedFinding baselineFinding = baselineFindingForChangedId.get(changedFinding.getId());
                if (!changedFinding.getFindingIndexPartition().equals(baselineFinding.getFindingIndexPartition())) {
                    LOGGER.error("May only match findings from same partition in finding index!");
                    continue;
                }
                TrackedFinding updatedFinding = new TrackedFinding((IndexFinding)changedFinding, baselineFinding.getId(), baselineFinding.getBirthCommit(), changedFinding.getFindingIndexPartition(), (CodeScopeName)codeScope.get());
                updatedChangedFindingsForUniformPath.remove((Object)uniformPath, (Object)changedFinding);
                updatedChangedFindingsForUniformPath.add((Object)uniformPath, (Object)updatedFinding);
            }
        }
        return updatedChangedFindingsForUniformPath;
    }

    private CodeScopeName getCodeScopeName(UniformPath uniformPath) throws StorageException {
        TokenElementInfo tokenElement = this.changedContentIndex.getTokenElement(uniformPath.resolveToCodePath());
        if (tokenElement == null) {
            LOGGER.error("Could not find TokenElementInfo for {}. Falling back to '{}' code scope.", (Object)uniformPath, (Object)CodeScopeName.DEFAULT);
            return CodeScopeName.DEFAULT;
        }
        return CodeScopeDetail.getCodeScopeNameFromTokenElement(tokenElement);
    }

    private SetMap<UniformPath, TrackedFinding> computeChangedFindingsForUniformPath(FindingsIndexBase findingsIndex, KeyDelta findingsDelta, Map<String, List<TrackedFinding>> groupedPlainFindings) throws StorageException {
        SetMap changedFindingsForUniformPath = new SetMap(SetMap.ESetFactory.IDENTITY_HASHSET);
        if (findingsDelta.isEmpty()) {
            return changedFindingsForUniformPath;
        }
        for (String partition : this.allAddedFindingsKeysByPartition.getKeys()) {
            List uniformPaths = (List)this.allAddedFindingsKeysByPartition.getCollectionOrEmpty((Object)partition);
            List changedIndexFindingsForUniformPath = findingsIndex.getFindingsForUniformPath(partition, uniformPaths);
            for (int i = 0; i < changedIndexFindingsForUniformPath.size(); ++i) {
                UniformPath path = (UniformPath)uniformPaths.get(i);
                ArrayList changedIndexFindings = (ArrayList)changedIndexFindingsForUniformPath.get(i);
                if (changedIndexFindings == null) continue;
                if (changedIndexFindings.isEmpty()) {
                    changedFindingsForUniformPath.addAll((Object)path, Collections.emptyList());
                    continue;
                }
                Collection<TrackedFinding> changedTrackedFindings = this.filterDuplicatesAndConvertToTrackedFindings(changedIndexFindings, partition, this.getCodeScopeName(path));
                changedFindingsForUniformPath.addAll((Object)path, changedTrackedFindings);
                if (CollectionUtils.isNullOrEmpty(groupedPlainFindings)) continue;
                FindingsTracker.attachReverseSibling(groupedPlainFindings, changedTrackedFindings);
            }
        }
        return changedFindingsForUniformPath;
    }

    private static void attachReverseSibling(Map<String, List<TrackedFinding>> groupedPlainFindings, Collection<TrackedFinding> findings) {
        for (TrackedFinding finding : findings) {
            Object originPartition = finding.getProperties().get("origin-partition");
            if (!(originPartition instanceof String) || finding.getSiblingLocations().isEmpty()) continue;
            for (String groupingKey : CollectionUtils.map((Collection)finding.getSiblingLocations(), siblingLocation -> FindingsTracker.makeGroupingKey((String)originPartition, finding.getTypeId(), siblingLocation.toString()))) {
                if (!groupedPlainFindings.containsKey(groupingKey)) continue;
                groupedPlainFindings.get(groupingKey).stream().filter(origin -> FindingDeltaUtils.getNormalizedFindingMessage((IndexFinding)finding).endsWith(FindingDeltaUtils.getNormalizedFindingMessage((IndexFinding)origin))).forEach(origin -> origin.addSiblingLocation(finding.getLocation()));
            }
        }
    }

    private static String makeGroupingKey(String partition, String findingTypeId, String locationString) {
        return partition + ":" + findingTypeId + ":" + locationString;
    }

    private String makeGroupingKey(TrackedFinding finding) {
        String partition = finding.getFindingIndexPartition();
        return FindingsTracker.makeGroupingKey(this.trackingGroupNameByPartition.getOrDefault(partition, partition), finding.getTypeId(), finding.getLocationString());
    }

    private Collection<TrackedFinding> filterDuplicatesAndConvertToTrackedFindings(Collection<? extends IndexFinding> indexFindings, String findingIndexPartition, CodeScopeName codeScope) {
        HashMap<CallSite, TrackedFinding> trackedFindings = new HashMap<CallSite, TrackedFinding>();
        for (IndexFinding indexFinding : indexFindings) {
            String findingKey = FindingDeltaUtils.getNormalizedFindingMessage(indexFinding) + ":" + FindingIdManager.getFindingLocationDescription(indexFinding) + ":" + indexFinding.getTypeId() + ":" + String.valueOf(indexFinding.getProperties().get("external-id"));
            if (!trackedFindings.containsKey(findingKey)) {
                trackedFindings.put((CallSite)((Object)findingKey), new TrackedFinding(indexFinding, this.idManager.getNextTempId(), this.getSchedulingCommit(), findingIndexPartition, codeScope));
                continue;
            }
            List siblingLocations = indexFinding.getSiblingLocations();
            ((TrackedFinding)trackedFindings.get(findingKey)).addSiblingLocations((Collection)siblingLocations);
        }
        return trackedFindings.values();
    }

    private void persistResults(Collection<String> findingsIdsToDelete, FindingChurnList churnList, SetMap<UniformPath, TrackedFinding> newOrUpdatedFindingsForUniformPath, SetMap<UniformPath, TrackedFinding> unaffectedFindingsForUniformPath, FindingsTrackingAlgorithm trackingAlgorithm) throws StorageException, ExecutionException, InterruptedException {
        Set<UniformPath> deletedKeys = this.determineDeletedKeys();
        SetMap findingsToPersistForUniformPath = new SetMap(new SetMap[]{newOrUpdatedFindingsForUniformPath, unaffectedFindingsForUniformPath});
        this.persistFindingsInTrackedFindingsIndex((SetMap<UniformPath, TrackedFinding>)findingsToPersistForUniformPath, deletedKeys);
        this.persistFindingsInFindingsByIdIndex((SetMap<UniformPath, TrackedFinding>)findingsToPersistForUniformPath, findingsIdsToDelete, churnList);
        this.findingChurnListIndex.setEntry(churnList);
        this.findingChurnCountIndex.setEntry(new FindingChurnCount(churnList));
        FindingsCountMetricUtils.persistMetrics(this.metricsIndex, this.blacklistIndex, deletedKeys, (SetMap<UniformPath, TrackedFinding>)findingsToPersistForUniformPath);
        Map<String, TrackedElement> trackedElements = trackingAlgorithm.loadElements(findingsToPersistForUniformPath.getValues(), this.getParallelTaskExecutor());
        this.idManager.persistFindingsCharacteristics((SetMap<UniformPath, TrackedFinding>)findingsToPersistForUniformPath, trackedElements);
    }

    private void persistFindingsInFindingsByIdIndex(SetMap<UniformPath, TrackedFinding> findingsToPersistForUniformPath, Collection<String> findingsToDelete, FindingChurnList churnList) throws StorageException {
        this.trackedFindingsByIdIndex.removeFindings(findingsToDelete);
        HashMap idToFinding = new HashMap();
        ((Set)findingsToPersistForUniformPath.getValues()).forEach(finding -> idToFinding.put(finding.getId(), finding));
        churnList.getRemovedFindings().forEach(finding -> idToFinding.put(finding.getId(), finding));
        churnList.getFindingsRemovedInBranch().forEach(finding -> idToFinding.put(finding.getId(), finding));
        this.trackedFindingsByIdIndex.insertOrUpdateFindings(new ArrayList<TrackedFinding>(idToFinding.values()));
    }

    private void persistFindingsInTrackedFindingsIndex(SetMap<UniformPath, TrackedFinding> findingsToPersist, Set<UniformPath> deletedKeys) throws StorageException {
        FindingsTracker.findAndLogDuplicateFindingIds(findingsToPersist);
        this.trackedFindingsIndex.removeFindings(deletedKeys);
        PairList<UniformPath, List<TrackedFinding>> findingsToPersistForUniformPath = FindingsTracker.convertToPairList(findingsToPersist);
        this.trackedFindingsIndex.setFindings(findingsToPersistForUniformPath);
    }

    private static void findAndLogDuplicateFindingIds(SetMap<UniformPath, TrackedFinding> findingsToPersist) {
        for (UniformPath uniformPath : findingsToPersist.getKeys()) {
            Set findings = (Set)findingsToPersist.getCollectionOrEmpty((Object)uniformPath);
            CounterSet findingIdCount = new CounterSet();
            findings.forEach(finding -> findingIdCount.inc((Object)finding.getId()));
            for (Pair idAndCount : findingIdCount) {
                FindingsTracker.logDuplicateFindingIds(uniformPath, findings, (Pair<String, Integer>)idAndCount);
            }
        }
    }

    private static void logDuplicateFindingIds(UniformPath uniformPath, Set<TrackedFinding> findings, Pair<String, Integer> idAndCount) {
        if ((Integer)idAndCount.getSecond() > 1) {
            List trackedFindings = CollectionUtils.filter(findings, finding -> finding.getId().equals(idAndCount.getFirst()));
            LOGGER.warn("Finding ID " + (String)idAndCount.getFirst() + " occurs " + String.valueOf(idAndCount.getSecond()) + " times in findings for " + String.valueOf(uniformPath) + ":\n" + StringUtils.concat((Iterable)trackedFindings, (String)"\n"));
        }
    }

    private static PairList<UniformPath, List<TrackedFinding>> convertToPairList(SetMap<UniformPath, TrackedFinding> findingsToPersist) {
        PairList pairList = new PairList();
        for (UniformPath uniformPath : findingsToPersist.getKeys()) {
            Set findings = (Set)findingsToPersist.getCollection((Object)uniformPath);
            pairList.add((Object)uniformPath, new ArrayList(CollectionUtils.sort((Collection)findings)));
        }
        return pairList;
    }

    private Set<UniformPath> determineDeletedKeys() throws StorageException {
        HashSet deletedKeys = new HashSet();
        for (String partition : this.allDeletedFindingsKeysByPartition.getKeys()) {
            deletedKeys.addAll(this.allDeletedFindingsKeysByPartition.getCollectionOrEmpty((Object)partition));
        }
        HashSet<UniformPath> toBeDeleted = new HashSet<UniformPath>();
        for (List uniformPaths : Lists.partition(new ArrayList(deletedKeys), (int)5000)) {
            List keys = CollectionUtils.map((Collection)uniformPaths, UniformPath::toString);
            Set<String> containedKeys = this.changedContentIndex.getContainedUniformPaths(keys);
            keys.stream().filter(Predicate.not(containedKeys::contains)).map(UniformPathCompatibilityUtil::convert).forEach(toBeDeleted::add);
        }
        return toBeDeleted;
    }
}

