/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.usage_data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.usage_data.CommitterIdentifiers;
import java.util.Objects;
import java.util.Set;
import org.conqat.lib.commons.collections.ListMap;

public final class CommitterDisplayName {
    private static final String USERNAME_PROPERTY = "username";
    private static final String FULLNAME_PROPERTY = "fullname";
    private static final String ALIASES_PROPERTY = "aliases";
    private static final String EMAILS_PROPERTY = "emails";
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="fullname")
    private final String fullname;
    @JsonProperty(value="aliases")
    private final Set<String> aliases;
    @JsonProperty(value="emails")
    private final Set<String> emailAddresses;
    @JsonIgnore
    private final CommitterIdentifiers committerIdentifiers;

    @JsonCreator
    public CommitterDisplayName(@JsonProperty(value="username") String username, @JsonProperty(value="fullname") String fullname, @JsonProperty(value="aliases") Set<String> aliases, @JsonProperty(value="emails") Set<String> emailAddresses) {
        this.username = username;
        this.fullname = fullname;
        this.aliases = aliases;
        this.emailAddresses = emailAddresses;
        this.committerIdentifiers = new CommitterIdentifiers(username, fullname, aliases, emailAddresses);
    }

    public String getUsername() {
        return this.username;
    }

    public String getFullname() {
        return this.fullname;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public Set<String> getEmailAddresses() {
        return this.emailAddresses;
    }

    public Set<String> getIdentifiers() {
        return this.committerIdentifiers.getIdentifiers();
    }

    public ListMap<String, CommitterDisplayName> getIdentifierMap() {
        ListMap ids = new ListMap();
        for (String id : this.committerIdentifiers.getIdentifiers()) {
            ids.add((Object)id, (Object)this);
        }
        return ids;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CommitterDisplayName that = (CommitterDisplayName)obj;
        return Objects.equals(this.username, that.username) && Objects.equals(this.fullname, that.fullname) && Objects.equals(this.aliases, that.aliases) && Objects.equals(this.emailAddresses, that.emailAddresses);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.fullname, this.aliases, this.emailAddresses);
    }
}

