/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.user;

import com.teamscale.core.utils.TimestampedInteraction;
import com.teamscale.index.user.UserRecentInteractionIndex;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Index(name="user-dashboard-favorites", options={EStorageOption.BACKUP}, valueClasses={TimestampedInteraction.class})
public class UserDashboardFavoritesIndex
implements IGlobalIndex {
    private final UserRecentInteractionIndex delegate;
    private static final Pattern UUID_PATTERN = Pattern.compile("^[0-9A-Fa-f]{8}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{12}$");
    public static final String INDEX_NAME = "user-dashboard-favorites";

    public UserDashboardFavoritesIndex(IStore store) {
        this.delegate = new UserRecentInteractionIndex(store, Integer.MAX_VALUE);
    }

    public void setDashboardFavorite(String userName, UUID dashboardId) throws StorageException {
        this.delegate.registerItemInteraction(userName, dashboardId.toString());
    }

    public void unsetDashboardFavorite(String userName, UUID dashboardId) throws StorageException {
        this.delegate.removeItemInteraction(userName, dashboardId.toString());
    }

    public Set<UUID> getDashboardFavorites(String userName) throws StorageException {
        List dashboardUuids = CollectionUtils.filter(this.delegate.getRecentItems(userName), UserDashboardFavoritesIndex::isUuidIdFormat);
        return CollectionUtils.mapToSet((Collection)dashboardUuids, UUID::fromString);
    }

    private static boolean isUuidIdFormat(String id) {
        return UUID_PATTERN.matcher(id).matches();
    }
}

