/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.user;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.index.CommitAssociationIndexBase;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.user.UserRecentlyInteractedBranchesIndex;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;

public class UserRecentlyCommittedBranchesSynchronizer
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private RepositoryLogIndex repositoryLogIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private UserRecentlyInteractedBranchesIndex userRecentlyInteractedBranchesIndex;
    @DeltaSource(value=RepositoryLogIndex.class)
    private KeyDelta delta;

    public void execute() throws Exception {
        List commits = CommitAssociationIndexBase.deltaToCommits((KeyDelta)this.delta);
        if (commits.isEmpty()) {
            return;
        }
        for (CommitDescriptor commit : commits) {
            String author;
            RepositoryLogEntryAggregate entry = (RepositoryLogEntryAggregate)this.repositoryLogIndex.getEntry(commit);
            if (entry == null || "Teamscale import".equals(author = entry.getAuthor())) continue;
            this.userRecentlyInteractedBranchesIndex.registerInteractedBranch(author, commit.getBranchName(), entry.getTimestamp());
        }
    }
}

