/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.client.model;

import com.microsoft.alm.client.utils.StringUtil;

public abstract class VssException
extends RuntimeException {
    private int errorCode;
    private boolean logException;
    private int eventId;
    private String helpLink;

    public VssException() {
    }

    public VssException(int errorCode) {
        this(errorCode, false);
    }

    public VssException(int errorCode, boolean logException) {
        this.errorCode = errorCode;
        this.logException = logException;
    }

    public VssException(String message, int errorCode, boolean logException) {
        super(StringUtil.scrubPassword(message));
        this.errorCode = errorCode;
        this.logException = logException;
    }

    public VssException(String message) {
        this(message, 0, false);
    }

    public VssException(String message, int errorCode) {
        this(message, errorCode, false);
    }

    public VssException(String message, boolean logException) {
        this(message, 0, logException);
    }

    public VssException(String message, int errorCode, boolean logException, Exception innerException) {
        super(StringUtil.scrubPassword(message), innerException);
        this.errorCode = errorCode;
        this.logException = logException;
    }

    public VssException(String message, Exception innerException) {
        this(StringUtil.scrubPassword(message), 0, false, innerException);
    }

    public VssException(String message, int errorCode, Exception innerException) {
        this(StringUtil.scrubPassword(message), errorCode, false, innerException);
    }

    public VssException(String message, boolean logException, Exception innerException) {
        this(StringUtil.scrubPassword(message), 0, logException, innerException);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public boolean getLogException() {
        return this.logException;
    }

    public void setLogException(boolean logException) {
        this.logException = logException;
    }

    public int getEventId() {
        return this.eventId;
    }

    public void setEventId(int eventId) {
        this.eventId = eventId;
    }

    public String getHelpLink() {
        return this.helpLink;
    }

    public void setHelpLink(String helpLink) {
        this.helpLink = helpLink;
    }
}

