/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.teamfoundation.build.webapi;

import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.utils.ArgumentUtility;
import com.microsoft.alm.teamfoundation.build.webapi.Build;
import com.microsoft.alm.teamfoundation.build.webapi.BuildDefinition;
import com.microsoft.alm.teamfoundation.build.webapi.BuildDefinitionReference;
import com.microsoft.alm.teamfoundation.build.webapi.BuildHttpClientBase;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;

public class BuildHttpClient
extends BuildHttpClientBase {
    public BuildHttpClient(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    public ArrayList<BuildDefinitionReference> getDefinitions(String projectName) {
        return super.getDefinitions(projectName, null, null, null, null, null, null, null, null, null, null, null);
    }

    public ArrayList<BuildDefinitionReference> getDefinitions(UUID projectId) {
        return super.getDefinitions(projectId, null, null, null, null, null, null, null, null, null, null, null);
    }

    public BuildDefinition addDefinition(BuildDefinition definition) {
        ArgumentUtility.checkForNull(definition, "definition");
        ArgumentUtility.checkForNull(definition.getProject(), "definition.Project");
        return super.createDefinition(definition, definition.getProject().getId(), null, null);
    }

    public BuildDefinition addDefinition(BuildDefinition definition, int definitionToCloneId) {
        ArgumentUtility.checkForNull(definition, "definition");
        ArgumentUtility.checkForNull(definition.getProject(), "definition.Project");
        return super.createDefinition(definition, definition.getProject().getId(), (Integer)definitionToCloneId, null);
    }

    public BuildDefinition addDefinition(BuildDefinition definition, int definitionToCloneId, int definitionToCloneRevision) {
        ArgumentUtility.checkForNull(definition, "definition");
        ArgumentUtility.checkForNull(definition.getProject(), "definition.Project");
        return super.createDefinition(definition, definition.getProject().getId(), (Integer)definitionToCloneId, (Integer)definitionToCloneRevision);
    }

    public Build getBuild(String project, int buildId) {
        return super.getBuild(project, buildId, null);
    }

    public Build getBuild(UUID project, int buildId) {
        return super.getBuild(project, buildId, null);
    }

    public Build queueBuild(Build build) {
        ArgumentUtility.checkForNull(build, "build");
        return super.queueBuild(build, null, null);
    }

    public Build queueBuild(Build build, boolean ignoreWarnings) {
        ArgumentUtility.checkForNull(build, "build");
        return super.queueBuild(build, ignoreWarnings, null);
    }

    @Override
    public Build updateBuild(Build build, int buildId) {
        ArgumentUtility.checkForNull(build, "build");
        ArgumentUtility.checkForNull(build.getProject(), "build.Project");
        return super.updateBuild(build, build.getProject().getId(), buildId);
    }

    public BuildDefinition updateDefinition(BuildDefinition definition, int definitionId) {
        ArgumentUtility.checkForNull(definition, "definition");
        ArgumentUtility.checkForNull(definition.getProject(), "definition.Project");
        return super.updateDefinition(definition, definition.getProject().getId(), definitionId, null, null);
    }
}

