/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.teamfoundation.core.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.teamfoundation.core.webapi.ConnectedServiceKind;
import com.microsoft.alm.teamfoundation.core.webapi.IdentityData;
import com.microsoft.alm.teamfoundation.core.webapi.Process;
import com.microsoft.alm.teamfoundation.core.webapi.ProjectState;
import com.microsoft.alm.teamfoundation.core.webapi.Proxy;
import com.microsoft.alm.teamfoundation.core.webapi.TeamProject;
import com.microsoft.alm.teamfoundation.core.webapi.TeamProjectCollection;
import com.microsoft.alm.teamfoundation.core.webapi.TeamProjectCollectionReference;
import com.microsoft.alm.teamfoundation.core.webapi.TeamProjectReference;
import com.microsoft.alm.teamfoundation.core.webapi.WebApiConnectedService;
import com.microsoft.alm.teamfoundation.core.webapi.WebApiConnectedServiceDetails;
import com.microsoft.alm.teamfoundation.core.webapi.WebApiTeam;
import com.microsoft.alm.visualstudio.services.operations.OperationReference;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import com.microsoft.alm.visualstudio.services.webapi.IdentityRef;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public abstract class CoreHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected CoreHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public WebApiConnectedService createConnectedService(WebApiConnectedServiceDetails connectedServiceCreationData, String projectId) {
        UUID locationId = UUID.fromString("b4f70219-e18b-42c5-abe3-98b07d35525e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("projectId", projectId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, connectedServiceCreationData, "application/json", "application/json");
        return super.sendRequest(httpRequest, WebApiConnectedService.class);
    }

    public WebApiConnectedServiceDetails getConnectedServiceDetails(String projectId, String name) {
        UUID locationId = UUID.fromString("b4f70219-e18b-42c5-abe3-98b07d35525e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("projectId", projectId);
        routeValues.put("name", name);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, WebApiConnectedServiceDetails.class);
    }

    public ArrayList<WebApiConnectedService> getConnectedServices(String projectId, ConnectedServiceKind kind) {
        UUID locationId = UUID.fromString("b4f70219-e18b-42c5-abe3-98b07d35525e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("projectId", projectId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("kind", kind);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WebApiConnectedService>>(){});
    }

    public void createIdentityMru(IdentityData mruData, String mruName) {
        UUID locationId = UUID.fromString("5ead0b70-2572-4697-97e9-f341069a783a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("mruName", mruName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, mruData, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteIdentityMru(IdentityData mruData, String mruName) {
        UUID locationId = UUID.fromString("5ead0b70-2572-4697-97e9-f341069a783a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("mruName", mruName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public ArrayList<IdentityRef> getIdentityMru(String mruName) {
        UUID locationId = UUID.fromString("5ead0b70-2572-4697-97e9-f341069a783a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("mruName", mruName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<IdentityRef>>(){});
    }

    public void updateIdentityMru(IdentityData mruData, String mruName) {
        UUID locationId = UUID.fromString("5ead0b70-2572-4697-97e9-f341069a783a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("mruName", mruName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, mruData, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }

    public ArrayList<IdentityRef> getTeamMembers(String projectId, String teamId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("294c494c-2600-4d7e-b76c-3dd50c3c95be");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("projectId", projectId);
        routeValues.put("teamId", teamId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<IdentityRef>>(){});
    }

    public Process getProcessById(UUID processId) {
        UUID locationId = UUID.fromString("93878975-88c5-4e6a-8abb-7ddd77a8a7d8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("processId", processId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, Process.class);
    }

    public ArrayList<Process> getProcesses() {
        UUID locationId = UUID.fromString("93878975-88c5-4e6a-8abb-7ddd77a8a7d8");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Process>>(){});
    }

    public TeamProjectCollection getProjectCollection(String collectionId) {
        UUID locationId = UUID.fromString("8031090f-ef1d-4af6-85fc-698cd75d42bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("collectionId", collectionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamProjectCollection.class);
    }

    public ArrayList<TeamProjectCollectionReference> getProjectCollections(Integer top, Integer skip) {
        UUID locationId = UUID.fromString("8031090f-ef1d-4af6-85fc-698cd75d42bf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TeamProjectCollectionReference>>(){});
    }

    public ArrayList<TeamProjectReference> getProjectHistory(Integer minRevision) {
        UUID locationId = UUID.fromString("6488a877-4749-4954-82ea-7340d36be9f2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("minRevision", minRevision);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TeamProjectReference>>(){});
    }

    public TeamProject getProject(String projectId, Boolean includeCapabilities, Boolean includeHistory) {
        UUID locationId = UUID.fromString("603fe2ac-9723-48b9-88ad-09305aa6c6e1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("projectId", projectId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCapabilities", includeCapabilities);
        queryParameters.addIfNotNull("includeHistory", includeHistory);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TeamProject.class);
    }

    public ArrayList<TeamProjectReference> getProjects(ProjectState stateFilter, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("603fe2ac-9723-48b9-88ad-09305aa6c6e1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("stateFilter", stateFilter);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TeamProjectReference>>(){});
    }

    public OperationReference queueCreateProject(TeamProject projectToCreate) {
        UUID locationId = UUID.fromString("603fe2ac-9723-48b9-88ad-09305aa6c6e1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, projectToCreate, "application/json", "application/json");
        return super.sendRequest(httpRequest, OperationReference.class);
    }

    public OperationReference queueDeleteProject(UUID projectId) {
        UUID locationId = UUID.fromString("603fe2ac-9723-48b9-88ad-09305aa6c6e1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("projectId", projectId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, OperationReference.class);
    }

    public OperationReference updateProject(TeamProject projectUpdate, UUID projectId) {
        UUID locationId = UUID.fromString("603fe2ac-9723-48b9-88ad-09305aa6c6e1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("projectId", projectId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, projectUpdate, "application/json", "application/json");
        return super.sendRequest(httpRequest, OperationReference.class);
    }

    public ArrayList<Proxy> getProxies(String proxyUrl) {
        UUID locationId = UUID.fromString("ec1f4311-f2b4-4c15-b2b8-8990b80d2908");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("proxyUrl", proxyUrl);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Proxy>>(){});
    }

    public WebApiTeam createTeam(WebApiTeam team, String projectId) {
        UUID locationId = UUID.fromString("d30a3dd1-f8ba-442a-b86a-bd0c0c383e59");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("projectId", projectId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, team, "application/json", "application/json");
        return super.sendRequest(httpRequest, WebApiTeam.class);
    }

    public void deleteTeam(String projectId, String teamId) {
        UUID locationId = UUID.fromString("d30a3dd1-f8ba-442a-b86a-bd0c0c383e59");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("projectId", projectId);
        routeValues.put("teamId", teamId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public WebApiTeam getTeam(String projectId, String teamId) {
        UUID locationId = UUID.fromString("d30a3dd1-f8ba-442a-b86a-bd0c0c383e59");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("projectId", projectId);
        routeValues.put("teamId", teamId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, WebApiTeam.class);
    }

    public ArrayList<WebApiTeam> getTeams(String projectId, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("d30a3dd1-f8ba-442a-b86a-bd0c0c383e59");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("projectId", projectId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WebApiTeam>>(){});
    }

    public WebApiTeam updateTeam(WebApiTeam teamData, String projectId, String teamId) {
        UUID locationId = UUID.fromString("d30a3dd1-f8ba-442a-b86a-bd0c0c383e59");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("projectId", projectId);
        routeValues.put("teamId", teamId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, teamData, "application/json", "application/json");
        return super.sendRequest(httpRequest, WebApiTeam.class);
    }
}

