/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.visualstudio.services.security.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.visualstudio.services.security.AccessControlEntry;
import com.microsoft.alm.visualstudio.services.security.AccessControlList;
import com.microsoft.alm.visualstudio.services.security.PermissionEvaluationBatch;
import com.microsoft.alm.visualstudio.services.security.SecurityNamespaceDescription;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import com.microsoft.alm.visualstudio.services.webapi.VssJsonCollectionWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class SecurityHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected SecurityHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public boolean removeAccessControlEntries(UUID securityNamespaceId, String token, String descriptors) {
        UUID locationId = UUID.fromString("ac08c8ff-4323-4b08-af90-bcd018d380ce");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("securityNamespaceId", securityNamespaceId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("token", token);
        queryParameters.addIfNotEmpty("descriptors", descriptors);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, Boolean.TYPE);
    }

    public ArrayList<AccessControlEntry> setAccessControlEntries(ObjectNode container, UUID securityNamespaceId) {
        UUID locationId = UUID.fromString("ac08c8ff-4323-4b08-af90-bcd018d380ce");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("securityNamespaceId", securityNamespaceId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, container, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<AccessControlEntry>>(){});
    }

    public ArrayList<AccessControlList> queryAccessControlLists(UUID securityNamespaceId, String token, String descriptors, Boolean includeExtendedInfo, Boolean recurse) {
        UUID locationId = UUID.fromString("18a2ad18-7571-46ae-bec7-0c7da1495885");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("securityNamespaceId", securityNamespaceId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("token", token);
        queryParameters.addIfNotEmpty("descriptors", descriptors);
        queryParameters.addIfNotNull("includeExtendedInfo", includeExtendedInfo);
        queryParameters.addIfNotNull("recurse", recurse);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<AccessControlList>>(){});
    }

    public boolean removeAccessControlLists(UUID securityNamespaceId, String tokens, Boolean recurse) {
        UUID locationId = UUID.fromString("18a2ad18-7571-46ae-bec7-0c7da1495885");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("securityNamespaceId", securityNamespaceId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("tokens", tokens);
        queryParameters.addIfNotNull("recurse", recurse);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, Boolean.TYPE);
    }

    public void setAccessControlLists(VssJsonCollectionWrapper<List<AccessControlList>> accessControlLists, UUID securityNamespaceId) {
        UUID locationId = UUID.fromString("18a2ad18-7571-46ae-bec7-0c7da1495885");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("securityNamespaceId", securityNamespaceId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, accessControlLists, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }

    public PermissionEvaluationBatch hasPermissionsBatch(PermissionEvaluationBatch evalBatch) {
        UUID locationId = UUID.fromString("cf1faa59-1b63-4448-bf04-13d981a46f5d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, evalBatch, "application/json", "application/json");
        return super.sendRequest(httpRequest, PermissionEvaluationBatch.class);
    }

    public ArrayList<Boolean> hasPermissions(UUID securityNamespaceId, Integer permissions, String tokens, Boolean alwaysAllowAdministrators, String delimiter) {
        UUID locationId = UUID.fromString("dd3b8bd6-c7fc-4cbd-929a-933d9c011c9d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("securityNamespaceId", securityNamespaceId);
        routeValues.put("permissions", permissions);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("tokens", tokens);
        queryParameters.addIfNotNull("alwaysAllowAdministrators", alwaysAllowAdministrators);
        queryParameters.addIfNotEmpty("delimiter", delimiter);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Boolean>>(){});
    }

    public AccessControlEntry removePermission(UUID securityNamespaceId, Integer permissions, String token, String descriptor) {
        UUID locationId = UUID.fromString("dd3b8bd6-c7fc-4cbd-929a-933d9c011c9d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("securityNamespaceId", securityNamespaceId);
        routeValues.put("permissions", permissions);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("token", token);
        queryParameters.addIfNotEmpty("descriptor", descriptor);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, AccessControlEntry.class);
    }

    public ArrayList<SecurityNamespaceDescription> querySecurityNamespaces(UUID securityNamespaceId, Boolean localOnly) {
        UUID locationId = UUID.fromString("ce7b9f95-fde9-4be8-a86d-83b366f0b87a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("securityNamespaceId", securityNamespaceId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("localOnly", localOnly);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<SecurityNamespaceDescription>>(){});
    }

    public void setInheritFlag(ObjectNode container, UUID securityNamespaceId) {
        UUID locationId = UUID.fromString("ce7b9f95-fde9-4be8-a86d-83b366f0b87a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("securityNamespaceId", securityNamespaceId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, container, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }
}

