/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core;

import com.microsoft.tfs.core.FrameworkServerDataProvider;
import com.microsoft.tfs.core.TFSConnection;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.framework.ServerDataProvider;
import com.microsoft.tfs.core.clients.framework.catalog.ICatalogService;
import com.microsoft.tfs.core.clients.framework.configuration.TFSEntitySession;
import com.microsoft.tfs.core.clients.framework.configuration.entities.TeamFoundationServerEntity;
import com.microsoft.tfs.core.clients.framework.configuration.internal.TFSEntitySessionFactory;
import com.microsoft.tfs.core.clients.framework.location.ConnectOptions;
import com.microsoft.tfs.core.clients.framework.location.ILocationService;
import com.microsoft.tfs.core.clients.registration.RegistrationClient;
import com.microsoft.tfs.core.config.ConnectionAdvisor;
import com.microsoft.tfs.core.config.DefaultConnectionAdvisor;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TFSConfigurationServer
extends TFSConnection {
    private static final Log log = LogFactory.getLog(TFSConfigurationServer.class);
    private ServerDataProvider serverDataProvider;
    private final Object serverDataProviderLock = new Object();
    private TFSEntitySession configurationSession;
    private final Object configurationSessionLock = new Object();
    private final Map<String, TFSTeamProjectCollection> collections = new HashMap<String, TFSTeamProjectCollection>();
    private final Object collectionsLock = new Object();

    public TFSConfigurationServer(URI serverURI, Credentials credentials) {
        this(serverURI, credentials, (ConnectionAdvisor)new DefaultConnectionAdvisor(Locale.getDefault(), TimeZone.getDefault()));
        String messageFormat = "Using {0} for TFSConfigurationServer, which is undesirable for Team Foundation Server client applications";
        String message = MessageFormat.format("Using {0} for TFSConfigurationServer, which is undesirable for Team Foundation Server client applications", DefaultConnectionAdvisor.class.getName());
        log.warn((Object)message);
    }

    public TFSConfigurationServer(URI serverURI, Credentials credentials, ConnectionAdvisor advisor) {
        this(serverURI, new AtomicReference<Credentials>(credentials), advisor);
    }

    protected TFSConfigurationServer(URI serverURI, AtomicReference<Credentials> credentialsHolder, ConnectionAdvisor advisor) {
        super(serverURI, credentialsHolder, advisor, "/TeamFoundation/Administration/v3.0/LocationService.asmx");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFSTeamProjectCollection getTeamProjectCollection(GUID collectionID) {
        this.checkNotClosed();
        Check.notNull(collectionID, "collectionID");
        String collectionLocation = this.getServerDataProvider().findServerLocation(collectionID);
        TFSTeamProjectCollection ret = null;
        Object object = this.collectionsLock;
        synchronized (object) {
            if (collectionLocation != null) {
                if (this.collections.containsKey(collectionLocation)) {
                    ret = this.collections.get(collectionLocation);
                } else {
                    URI collectionLocationURI;
                    try {
                        collectionLocationURI = new URI(collectionLocation);
                    }
                    catch (URISyntaxException e) {
                        throw new IllegalArgumentException(e.getLocalizedMessage(), e);
                    }
                    ret = new TFSTeamProjectCollection(collectionLocationURI, this.getCredentialsHolder(), this.getConnectionAdvisor());
                    ret.setHTTPClientReference(this.getHTTPClientReference());
                    this.collections.put(collectionLocation, ret);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFSEntitySession getConfigurationSession(boolean refresh) {
        this.checkNotClosed();
        Object object = this.configurationSessionLock;
        synchronized (object) {
            if (this.configurationSession == null || refresh) {
                this.configurationSession = TFSEntitySessionFactory.newEntitySession(this);
            }
            return this.configurationSession;
        }
    }

    public TeamFoundationServerEntity getTeamFoundationServerEntity(boolean refresh) {
        this.checkNotClosed();
        TFSEntitySession configurationSession = this.getConfigurationSession(refresh);
        if (configurationSession == null || configurationSession.getOrganizationalRoot() == null) {
            log.warn((Object)MessageFormat.format("Could not load configuration session for instance id {0}", this.getInstanceID()));
            return null;
        }
        TeamFoundationServerEntity serverEntity = configurationSession.getOrganizationalRoot().getTeamFoundationServer();
        if (serverEntity == null) {
            log.warn((Object)MessageFormat.format("Could not load Team Foundation Server entity for instance id {0}", this.getInstanceID()));
        }
        return serverEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerDataProvider getServerDataProvider() {
        this.checkNotClosed();
        Object object = this.serverDataProviderLock;
        synchronized (object) {
            if (this.serverDataProvider == null) {
                try {
                    FrameworkServerDataProvider tempFrameworkProvider = new FrameworkServerDataProvider(this);
                    if (!tempFrameworkProvider.hasLocalCacheDataForConnection()) {
                        tempFrameworkProvider.connect(ConnectOptions.INCLUDE_SERVICES);
                    }
                    this.serverDataProvider = tempFrameworkProvider;
                }
                catch (RuntimeException e) {
                    log.warn((Object)"Error getting data provider", (Throwable)e);
                    throw e;
                }
            }
            return this.serverDataProvider;
        }
    }

    @Override
    public ICatalogService getCatalogService() {
        this.checkNotClosed();
        return (ICatalogService)this.getClient(ICatalogService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAuthenticated() {
        ServerDataProvider serverDataProvider;
        this.checkNotClosed();
        Object object = this.serverDataProviderLock;
        synchronized (object) {
            serverDataProvider = this.serverDataProvider;
        }
        return serverDataProvider != null ? serverDataProvider.hasAuthenticated() : false;
    }

    public void reactToPossibleServerUpdate(int locationServiceLastChangeId) {
        this.checkNotClosed();
        this.getServerDataProvider().reactToPossibleServerUpdate(locationServiceLastChangeId);
    }

    @Override
    public RegistrationClient getRegistrationClient() {
        this.checkNotClosed();
        return null;
    }

    public ILocationService getLocationService() {
        this.checkNotClosed();
        return (ILocationService)this.getClient(ILocationService.class);
    }
}

