/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.checkinpolicies;

import com.microsoft.tfs.core.checkinpolicies.PolicyContext;
import com.microsoft.tfs.core.checkinpolicies.PolicyEvaluationCancelledException;
import com.microsoft.tfs.core.checkinpolicies.PolicyExceptionFailure;
import com.microsoft.tfs.core.checkinpolicies.PolicyFailure;
import com.microsoft.tfs.core.checkinpolicies.PolicyInstance;
import com.microsoft.tfs.core.checkinpolicies.PolicyType;
import com.microsoft.tfs.core.checkinpolicies.events.PolicyStateChangedEvent;
import com.microsoft.tfs.core.checkinpolicies.events.PolicyStateChangedListener;
import com.microsoft.tfs.core.memento.Memento;
import com.microsoft.tfs.core.pendingcheckin.PendingCheckin;
import com.microsoft.tfs.core.pendingcheckin.filters.FilterPendingCheckin;
import com.microsoft.tfs.core.pendingcheckin.filters.ScopeFilter;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Closable;
import com.microsoft.tfs.util.listeners.ListenerList;
import com.microsoft.tfs.util.listeners.ListenerRunnable;
import com.microsoft.tfs.util.listeners.StandardListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PolicyEvaluationStatus
implements Closable {
    private static final Log log = LogFactory.getLog(PolicyEvaluationStatus.class);
    private PolicyInstance policy;
    private PolicyFailure[] failures = new PolicyFailure[0];
    private String[] scopeExpressions;
    private int priority;
    private final ListenerList policyStateChangedEventListeners = new StandardListenerList();
    private final PolicyStateChangedListener savedPolicyStateChangedListener = new PolicyStateChangedListener(){

        @Override
        public void onPolicyStateChanged(PolicyStateChangedEvent e) {
            PolicyEvaluationStatus.this.onPolicyStateChanged(e);
        }
    };

    public PolicyEvaluationStatus(PolicyInstance policy, int priority, String[] scopeExpressions) {
        Check.notNull(policy, "policy");
        Check.notNull(scopeExpressions, "scopeExpressions");
        this.policy = policy;
        this.priority = priority;
        this.scopeExpressions = scopeExpressions;
        this.policy.addPolicyStateChangedListener(this.savedPolicyStateChangedListener);
    }

    public void addPolicyStateChangedEventListener(PolicyStateChangedListener listener) {
        this.policyStateChangedEventListeners.addListener(listener);
    }

    public void removePolicyStateChangedEventListener(PolicyStateChangedListener listener) {
        this.policyStateChangedEventListeners.removeListener(listener);
    }

    private synchronized void onPolicyStateChanged(final PolicyStateChangedEvent e) {
        final PolicyFailure[] newFailures = e.getFailures();
        this.failures = new PolicyFailure[newFailures.length];
        for (int i = 0; i < this.failures.length; ++i) {
            this.failures[i] = newFailures[i];
        }
        this.policyStateChangedEventListeners.foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((PolicyStateChangedListener)listener).onPolicyStateChanged(new PolicyStateChangedEvent(e.getEventSource(), newFailures, e.getPolicy()));
                return true;
            }
        });
    }

    public synchronized void initialize(PendingCheckin pendingCheckin, PolicyContext context) {
        Check.notNull(pendingCheckin, "pendingCheckin");
        Check.notNull(context, "context");
        if (this.policy == null) {
            throw new IllegalStateException("This PolicyEvaluationStatus object has been closed.");
        }
        if (this.scopeExpressions.length > 0) {
            pendingCheckin = new FilterPendingCheckin(pendingCheckin, new ScopeFilter(this.scopeExpressions));
        }
        this.policy.initialize(pendingCheckin, context);
    }

    public synchronized void evaluate(PolicyContext policyContext) throws PolicyEvaluationCancelledException {
        Check.notNull(policyContext, "policyContext");
        if (this.policy == null) {
            throw new IllegalStateException("This PolicyEvaluationStatus object has been closed.");
        }
        try {
            PolicyFailure[] failures = this.policy.evaluate(policyContext);
            this.failures = failures != null ? failures : new PolicyFailure[]{};
            for (int i = 0; i < this.failures.length; ++i) {
                if (this.failures[i] != null) continue;
                this.failures[i] = new PolicyFailure("Policy Internal Error: Policy returned a null failure", this.policy);
            }
        }
        catch (PolicyEvaluationCancelledException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"Error in checkin policy", (Throwable)e);
            this.failures = new PolicyFailure[]{new PolicyExceptionFailure(this.policy, policyContext, e)};
        }
    }

    public synchronized PolicyFailure[] getFailures() {
        return this.failures;
    }

    public synchronized PolicyType getPolicyType() {
        if (this.policy == null) {
            throw new IllegalStateException("This PolicyEvaluationStatus object has been closed.");
        }
        return this.policy.getPolicyType();
    }

    @Override
    public synchronized void close() {
        if (this.policy != null) {
            this.policy.removePolicyStateChangedListener(this.savedPolicyStateChangedListener);
            this.policy.close();
            this.policy = null;
        }
    }

    public synchronized void update(int priority, String[] scopeExpressions, Memento configurationMemento) {
        if (this.policy == null) {
            throw new IllegalStateException("This PolicyEvaluationStatus object has been closed.");
        }
        this.priority = priority;
        this.scopeExpressions = scopeExpressions;
        this.policy.loadConfiguration(configurationMemento);
    }

    public synchronized PolicyInstance getPolicy() {
        if (this.policy == null) {
            throw new IllegalStateException("This PolicyEvaluationStatus object has been closed.");
        }
        return this.policy;
    }

    public synchronized int getPriority() {
        return this.priority;
    }

    public String[] getScopeExpressions() {
        return this.scopeExpressions;
    }
}

