/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build;

import com.microsoft.tfs.core.clients.build.IBuildInformation;
import com.microsoft.tfs.core.clients.build.IBuildInformationNode;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDetail;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildInformationNode;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServer;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.CommonInformationHelper;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.InformationAddRequest;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.InformationChangeRequest;
import java.util.List;

public class InformationNodeConverters {
    public static int getChangesetID(IBuildInformation buildInformation) {
        return InformationNodeConverters.getChangesetID(buildInformation, -1);
    }

    public static int getChangesetID(IBuildInformation buildInformation, int requestId) {
        return InformationNodeConverters.getChangesetID(buildInformation, requestId, true);
    }

    public static int getChangesetID(IBuildInformation buildInformation, int requestId, boolean returnFirstIfNotFound) {
        IBuildInformationNode[] nodes = buildInformation.getNodesByType("CheckInOutcome", true);
        if (nodes.length == 0) {
            return -1;
        }
        int changesetId = -1;
        for (IBuildInformationNode node : nodes) {
            int requestId2 = CommonInformationHelper.getInt(node.getFields(), "RequestId", -1);
            if (requestId2 == -1 || requestId2 != requestId) continue;
            changesetId = CommonInformationHelper.getInt(node.getFields(), "ChangesetId", -1);
            return changesetId;
        }
        if (returnFirstIfNotFound) {
            changesetId = CommonInformationHelper.getInt(nodes[0].getFields(), "ChangesetId", -1);
        }
        return changesetId;
    }

    public static void bulkUpdateInformationNodes(BuildDetail build, List<InformationChangeRequest> requests) {
        if (requests.size() > 0) {
            InformationChangeRequest[] requestsArray = new InformationChangeRequest[requests.size()];
            BuildServer buildServer = (BuildServer)build.getBuildServer();
            BuildInformationNode[] outNodes = buildServer.getBuildServerVersion().isV2() ? buildServer.getBuild2008Helper().updateBuildInformation(requests.toArray(requestsArray)) : (buildServer.getBuildServerVersion().isV3() ? buildServer.getBuild2010Helper().updateBuildInformation(requests.toArray(requestsArray)) : buildServer.getBuildService().updateBuildInformation(requests.toArray(requestsArray)));
            for (int i = 0; i < requestsArray.length; ++i) {
                if (!(requestsArray[i] instanceof InformationAddRequest)) continue;
                ((InformationAddRequest)requests.get(i)).getNode().setID(outNodes[i].getNodeID());
            }
        }
    }
}

