/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.flags;

import com.microsoft.tfs.util.BitField;
import ms.tfs.build.buildservice._04._QueueStatus;

public final class QueueStatus
extends BitField
implements Comparable<QueueStatus> {
    public static final QueueStatus NONE = new QueueStatus(0, _QueueStatus._QueueStatus_Flag.None);
    public static final QueueStatus IN_PROGRESS = new QueueStatus(1, _QueueStatus._QueueStatus_Flag.InProgress);
    public static final QueueStatus RETRY = new QueueStatus(2, _QueueStatus._QueueStatus_Flag.Retry);
    public static final QueueStatus QUEUED = new QueueStatus(4, _QueueStatus._QueueStatus_Flag.Queued);
    public static final QueueStatus POSTPONED = new QueueStatus(8, _QueueStatus._QueueStatus_Flag.Postponed);
    public static final QueueStatus COMPLETED = new QueueStatus(16, _QueueStatus._QueueStatus_Flag.Completed);
    public static final QueueStatus CANCELED = new QueueStatus(32, _QueueStatus._QueueStatus_Flag.Canceled);
    public static final QueueStatus ALL = new QueueStatus(63, _QueueStatus._QueueStatus_Flag.All);

    private QueueStatus(int flags, _QueueStatus._QueueStatus_Flag flag) {
        super(flags);
        QueueStatus.registerStringValue(this.getClass(), flags, flag.toString());
    }

    private QueueStatus(int flags) {
        super(flags);
    }

    public _QueueStatus getWebServiceObject() {
        return new _QueueStatus(this.toFullStringValues());
    }

    public static QueueStatus fromWebServiceObject(_QueueStatus queueStatus) {
        if (queueStatus == null) {
            return NONE;
        }
        return new QueueStatus(QueueStatus.webServiceObjectToFlags(queueStatus));
    }

    private static int webServiceObjectToFlags(_QueueStatus queueStatus) {
        _QueueStatus._QueueStatus_Flag[] flagArray = queueStatus.getFlags();
        String[] flagStrings = new String[flagArray.length];
        for (int i = 0; i < flagArray.length; ++i) {
            flagStrings[i] = flagArray[i].toString();
        }
        return QueueStatus.fromStringValues(flagStrings, QueueStatus.class);
    }

    public static QueueStatus combine(QueueStatus[] queueStatus) {
        return new QueueStatus(BitField.combine(queueStatus));
    }

    public boolean containsAll(QueueStatus other) {
        return this.containsAllInternal(other);
    }

    public boolean contains(QueueStatus other) {
        return this.containsInternal(other);
    }

    public boolean containsAny(QueueStatus other) {
        return this.containsAnyInternal(other);
    }

    public QueueStatus remove(QueueStatus other) {
        return new QueueStatus(this.removeInternal(other));
    }

    public QueueStatus retain(QueueStatus other) {
        return new QueueStatus(this.retainInternal(other));
    }

    public QueueStatus combine(QueueStatus other) {
        return new QueueStatus(this.combineInternal(other));
    }

    @Override
    public int compareTo(QueueStatus other) {
        int thisSortPos = this.getSortPosition(this);
        int otherSortPos = this.getSortPosition(other);
        return thisSortPos - otherSortPos;
    }

    private int getSortPosition(QueueStatus status) {
        if (status.contains(QUEUED)) {
            return 0;
        }
        if (status.contains(IN_PROGRESS)) {
            return 2;
        }
        if (status.contains(POSTPONED)) {
            return 1;
        }
        if (status.contains(COMPLETED)) {
            return 3;
        }
        if (status.contains(CANCELED)) {
            return 4;
        }
        return 0;
    }
}

