/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.favorites;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.json.JSONEncoder;
import com.microsoft.tfs.util.json.JSONObject;

public class FavoriteItem {
    private static final String JSON_ID = "id";
    private static final String JSON_PARENT_ID = "parentId";
    private static final String JSON_NAME = "name";
    private static final String JSON_TYPE = "type";
    private static final String JSON_DATA = "data";
    private GUID id = GUID.EMPTY;
    private GUID parentID = GUID.EMPTY;
    private String name;
    private String type;
    private String data;

    public GUID getID() {
        return this.id;
    }

    public void setID(GUID id) {
        Check.notNull(id, JSON_ID);
        this.id = id;
    }

    public GUID getParentID() {
        return this.parentID;
    }

    public void setParentID(GUID parentID) {
        Check.notNull(parentID, "parentID");
        this.parentID = parentID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public boolean isFolder() {
        return this.type == null || this.type.length() == 0;
    }

    public String serialize() {
        JSONObject o = new JSONObject();
        if (!GUID.EMPTY.equals(this.id)) {
            o.put(JSON_ID, this.id.getGUIDString());
        }
        if (!GUID.EMPTY.equals(this.parentID)) {
            o.put(JSON_PARENT_ID, this.parentID.getGUIDString());
        }
        if (this.name != null) {
            o.put(JSON_NAME, this.name);
        }
        if (this.type != null) {
            o.put(JSON_TYPE, this.type);
        }
        if (this.data != null) {
            o.put(JSON_DATA, this.data);
        }
        return JSONEncoder.encodeObject(o);
    }

    public static FavoriteItem deserialize(String value) {
        String parentID;
        Check.notNullOrEmpty(value, "value");
        JSONObject o = JSONEncoder.decodeObject(value);
        FavoriteItem item = new FavoriteItem();
        String id = o.get(JSON_ID);
        if (id != null && id.length() > 0) {
            item.id = new GUID(id);
        }
        if ((parentID = o.get(JSON_PARENT_ID)) != null && parentID.length() > 0) {
            item.parentID = new GUID(parentID);
        }
        item.name = o.get(JSON_NAME);
        item.type = o.get(JSON_TYPE);
        item.data = o.get(JSON_DATA);
        return item;
    }
}

