/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.catalog;

import com.microsoft.tfs.core.clients.framework.catalog.CatalogNode;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogResourceType;
import com.microsoft.tfs.core.clients.framework.location.ILocationService;
import com.microsoft.tfs.core.clients.framework.location.ServiceDefinition;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.util.GUID;
import java.util.HashMap;
import ms.ws._CatalogResource;
import ms.ws._CatalogServiceReference;
import ms.ws._KeyValueOfStringString;

public class CatalogResource
extends WebServiceObjectWrapper {
    private CatalogResourceType resourceType;
    private HashMap<String, ServiceDefinition> serviceReferences;
    private HashMap<String, String> properties;
    private CatalogNode[] nodeReferences;

    public CatalogResource(_CatalogResource catalogResource) {
        super(catalogResource);
    }

    public _CatalogResource getWebServiceObject() {
        return (_CatalogResource)this.webServiceObject;
    }

    public String getIdentifier() {
        return this.getWebServiceObject().getIdentifier();
    }

    public String getResourceTypeIdentifier() {
        return this.getWebServiceObject().getResourceTypeIdentifier();
    }

    public String getDisplayName() {
        return this.getWebServiceObject().getDisplayName();
    }

    public String getDescription() {
        return this.getWebServiceObject().getDescription();
    }

    public boolean isMatchedQuery() {
        return this.getWebServiceObject().isMatchedQuery();
    }

    public CatalogResourceType getResourceType() {
        return this.resourceType;
    }

    public HashMap<String, ServiceDefinition> getServiceReferences() {
        return this.serviceReferences;
    }

    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public CatalogNode[] getNodeReferences() {
        return this.nodeReferences;
    }

    public void initializeFromWebService(HashMap<String, CatalogResourceType> typeMap, HashMap<String, CatalogNode> nodeMap, ILocationService locationService) {
        this.resourceType = typeMap.get(this.getWebServiceObject().getResourceTypeIdentifier());
        String[] nodeReferencePaths = this.getWebServiceObject().getNodeReferencePaths();
        this.nodeReferences = new CatalogNode[nodeReferencePaths.length];
        for (int i = 0; i < nodeReferencePaths.length; ++i) {
            CatalogNode node = nodeMap.get(nodeReferencePaths[i]);
            node.setCatalogResource(this);
            this.nodeReferences[i] = node;
        }
        _CatalogServiceReference[] references = this.getWebServiceObject().getCatalogServiceReferences();
        this.serviceReferences = new HashMap();
        for (int i = 0; i < references.length; ++i) {
            _CatalogServiceReference serviceReference = references[i];
            ServiceDefinition serviceDefinition = null;
            if (serviceReference.getServiceDefinition() != null) {
                String serviceType = serviceReference.getServiceDefinition().getServiceType();
                GUID serviceIdentifier = new GUID(serviceReference.getServiceDefinition().getIdentifier());
                serviceDefinition = locationService.findServiceDefinition(serviceType, serviceIdentifier);
            }
            this.serviceReferences.put(serviceReference.getAssociationKey(), serviceDefinition);
        }
        this.properties = new HashMap();
        _KeyValueOfStringString[] propertyPairs = this.getWebServiceObject().getProperties();
        for (int i = 0; i < propertyPairs.length; ++i) {
            this.properties.put(propertyPairs[i].getKey(), propertyPairs[i].getValue());
        }
    }
}

