/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.catalog;

import com.microsoft.tfs.core.TFSConfigurationServer;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogChangeContext;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogData;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogDataProcessedResult;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogNode;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogNodeDependency;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogQueryOptions;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogResource;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogResourceProperty;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogResourceType;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogRoots;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogTree;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogWebServiceProxy;
import com.microsoft.tfs.core.clients.framework.catalog.ICatalogService;
import com.microsoft.tfs.core.clients.framework.catalog.exceptions.CatalogMethodNotImplementedException;
import com.microsoft.tfs.core.clients.framework.catalog.exceptions.CatalogNodeDoesNotExistException;
import com.microsoft.tfs.core.clients.framework.catalog.exceptions.CatalogResourceTypeDoesNotExistException;
import com.microsoft.tfs.core.clients.framework.location.ILocationService;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.util.ArrayList;
import java.util.HashMap;

public class CatalogService
implements ICatalogService {
    private final TFSConfigurationServer connection;
    private final ILocationService locationService;
    private final CatalogWebServiceProxy catalogProxy;
    private boolean resourceTypesLoaded = false;
    private final Object mapResourceTypesLock = new Object();
    private final HashMap<GUID, CatalogResourceType> mapResourceTypes = new HashMap();

    public CatalogService(TFSConfigurationServer connection) {
        this.connection = connection;
        this.locationService = (ILocationService)connection.getClient(ILocationService.class);
        this.catalogProxy = new CatalogWebServiceProxy(connection);
    }

    @Override
    public ILocationService getLocationService() {
        return this.locationService;
    }

    @Override
    public CatalogResourceType[] queryResourceTypes(GUID[] resourceTypeIdentifiers) {
        this.ensureResourceTypesLoaded();
        if (resourceTypeIdentifiers == null || resourceTypeIdentifiers.length == 0 || resourceTypeIdentifiers[0].equals(GUID.EMPTY)) {
            return this.mapResourceTypes.values().toArray(new CatalogResourceType[this.mapResourceTypes.size()]);
        }
        ArrayList<CatalogResourceType> list = new ArrayList<CatalogResourceType>();
        for (int i = 0; i < resourceTypeIdentifiers.length; ++i) {
            GUID id = resourceTypeIdentifiers[i];
            if (!this.mapResourceTypes.containsKey(id)) {
                throw new CatalogResourceTypeDoesNotExistException(id);
            }
            list.add(this.mapResourceTypes.get(id));
        }
        return list.toArray(new CatalogResourceType[list.size()]);
    }

    @Override
    public CatalogResource[] queryResources(GUID[] resourceIdentifiers, CatalogQueryOptions queryOptions) {
        CatalogData data = this.catalogProxy.queryResources(resourceIdentifiers, queryOptions.toIntFlags());
        CatalogDataProcessedResult result = this.processCatalogData(data, queryOptions);
        return result.getMatchingResources();
    }

    @Override
    public CatalogResource[] queryResourcesByType(GUID[] resourceTypeIdentifiers, CatalogQueryOptions queryOptions) {
        return this.queryResources(resourceTypeIdentifiers, null, queryOptions);
    }

    @Override
    public CatalogResource[] queryResources(GUID[] resourceTypeIdentifiers, CatalogResourceProperty[] propertyFilters, CatalogQueryOptions queryOptions) {
        CatalogData data = this.catalogProxy.queryResourcesByType(resourceTypeIdentifiers, propertyFilters, queryOptions.toIntFlags());
        CatalogDataProcessedResult result = this.processCatalogData(data, queryOptions);
        return result.getMatchingResources();
    }

    @Override
    public CatalogNode[] getRootNodes() {
        String[] pathSpecs = new String[]{"*"};
        CatalogData data = this.catalogProxy.queryNodes(pathSpecs, null, null, CatalogQueryOptions.NONE.toIntFlags());
        CatalogDataProcessedResult result = this.processCatalogData(data, CatalogQueryOptions.NONE);
        return result.getMatchingNodes();
    }

    @Override
    public CatalogNode queryRootNode(CatalogTree tree) {
        String[] pathSpecs = new String[]{CatalogRoots.determinePath(tree)};
        CatalogData data = this.catalogProxy.queryNodes(pathSpecs, null, null, CatalogQueryOptions.NONE.toIntFlags());
        CatalogDataProcessedResult result = this.processCatalogData(data, CatalogQueryOptions.NONE);
        CatalogNode[] matchingNodes = result.getMatchingNodes();
        if (matchingNodes.length != 1) {
            throw new CatalogNodeDoesNotExistException();
        }
        return matchingNodes[0];
    }

    @Override
    public CatalogNode[] queryNodes(String[] pathSpecs, GUID[] resourceTypeFilters, CatalogQueryOptions queryOptions) {
        return this.queryNodes(pathSpecs, resourceTypeFilters, null, queryOptions);
    }

    @Override
    public CatalogNode[] queryNodes(String[] pathSpecs, GUID[] resourceTypeFilters, CatalogResourceProperty[] propertyFilters, CatalogQueryOptions queryOptions) {
        CatalogData data = this.catalogProxy.queryNodes(pathSpecs, resourceTypeFilters, propertyFilters, queryOptions.toIntFlags());
        CatalogDataProcessedResult result = this.processCatalogData(data, queryOptions);
        return result.getMatchingNodes();
    }

    @Override
    public CatalogNode[] queryParents(GUID resourceIdentifier, String[] pathFilters, GUID[] resourceTypeFilters, boolean recurseToRoot, CatalogQueryOptions queryOptions) {
        CatalogData data = this.catalogProxy.queryParents(resourceIdentifier, pathFilters, resourceTypeFilters, recurseToRoot, queryOptions.toIntFlags());
        CatalogDataProcessedResult result = this.processCatalogData(data, queryOptions);
        return result.getMatchingNodes();
    }

    @Override
    public CatalogNode[] queryUpTree(String path, GUID[] resourceTypeFilters, CatalogQueryOptions queryOptions) {
        throw new CatalogMethodNotImplementedException("QueryUpTree");
    }

    @Override
    public CatalogChangeContext createChangeContext() {
        throw new CatalogMethodNotImplementedException("CreateChangeContext");
    }

    @Override
    public void saveDelete(CatalogNode node, Boolean recurse) {
        throw new CatalogMethodNotImplementedException("SaveDelete");
    }

    @Override
    public void saveMove(CatalogNode nodeToMove, CatalogNode newParent) {
        throw new CatalogMethodNotImplementedException("SaveMove");
    }

    @Override
    public void saveNode(CatalogNode node) {
        throw new CatalogMethodNotImplementedException("SaveNode");
    }

    @Override
    public void saveResource(CatalogResource resource) {
        throw new CatalogMethodNotImplementedException("SaveResource");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureResourceTypesLoaded() {
        if (this.resourceTypesLoaded) {
            return;
        }
        Object object = this.mapResourceTypesLock;
        synchronized (object) {
            if (this.resourceTypesLoaded) {
                return;
            }
            this.mapResourceTypes.clear();
            CatalogResourceType[] resourceTypes = this.catalogProxy.queryResourceTypes(null);
            for (int i = 0; i < resourceTypes.length; ++i) {
                CatalogResourceType resourceType = resourceTypes[i];
                this.mapResourceTypes.put(new GUID(resourceType.getIdentifier()), resourceType);
            }
            this.resourceTypesLoaded = true;
        }
    }

    private CatalogDataProcessedResult processCatalogData(CatalogData data, CatalogQueryOptions queryOptions) {
        int i;
        this.connection.reactToPossibleServerUpdate(data.getLocationServiceLastChangeID());
        ArrayList<CatalogNode> matchingNodes = new ArrayList<CatalogNode>();
        ArrayList<CatalogResource> matchingResources = new ArrayList<CatalogResource>();
        CatalogResourceType[] resourceTypes = data.getCatalogResourceTypes();
        CatalogNode[] catalogNodes = data.getCatalogNodes();
        CatalogResource[] catalogResources = data.getCatalogResources();
        HashMap<String, CatalogResourceType> typeTable = new HashMap<String, CatalogResourceType>();
        for (int i2 = 0; i2 < resourceTypes.length; ++i2) {
            CatalogResourceType resourceType = resourceTypes[i2];
            typeTable.put(resourceType.getIdentifier(), resourceType);
        }
        HashMap<String, CatalogNode> nodeTable = new HashMap<String, CatalogNode>();
        for (i = 0; i < catalogNodes.length; ++i) {
            CatalogNode catalogNode = catalogNodes[i];
            catalogNode.initializeFromWebService(this);
            nodeTable.put(catalogNode.getFullPath(), catalogNode);
            if (!catalogNode.isMatchedQuery()) continue;
            matchingNodes.add(catalogNode);
        }
        if (!CatalogQueryOptions.NONE.equals(queryOptions)) {
            for (i = 0; i < catalogNodes.length; ++i) {
                CatalogNode node = catalogNodes[i];
                if (queryOptions.contains(CatalogQueryOptions.EXPAND_DEPENDENCIES)) {
                    Check.isTrue(node.isNodeDependenciesIncluded(), "node.isNodeDependenciesIncluded()");
                    CatalogNodeDependency[] dependencies = node.getNodeDependencies();
                    for (int j = 0; j < dependencies.length; ++j) {
                        CatalogNodeDependency dependency = dependencies[j];
                        String requiredNodeFullPath = dependency.getRequiredNodeFullPath();
                        String associationKey = dependency.getAssociationKey();
                        if (dependency.isSingleton()) {
                            node.getDependencyGroup().setSingletonDependency(associationKey, nodeTable.get(requiredNodeFullPath));
                            continue;
                        }
                        node.getDependencyGroup().addSetDependency(associationKey, nodeTable.get(requiredNodeFullPath));
                    }
                }
                if (!queryOptions.contains(CatalogQueryOptions.INCLUDE_PARENTS) || node.getParentPath() == null || node.getParentPath().length() == 0) continue;
                node.setParentNode(nodeTable.get(node.getParentPath()));
            }
        }
        for (i = 0; i < catalogResources.length; ++i) {
            CatalogResource resource = catalogResources[i];
            resource.initializeFromWebService(typeTable, nodeTable, this.locationService);
            if (!resource.isMatchedQuery()) continue;
            matchingResources.add(resource);
        }
        CatalogResource[] matchingResourcesArray = matchingResources.toArray(new CatalogResource[matchingResources.size()]);
        CatalogNode[] matchingNodesArray = matchingNodes.toArray(new CatalogNode[matchingNodes.size()]);
        return new CatalogDataProcessedResult(matchingResourcesArray, matchingNodesArray);
    }
}

