/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.catalog;

import com.microsoft.tfs.core.TFSConfigurationServer;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogData;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogResourceProperty;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogResourceType;
import com.microsoft.tfs.core.exceptions.mappers.CatalogExceptionMapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.core.ws.runtime.exceptions.ProxyException;
import com.microsoft.tfs.util.GUID;
import ms.ws._CatalogData;
import ms.ws._CatalogWebServiceSoap;
import ms.ws._KeyValueOfStringString;

public class CatalogWebServiceProxy {
    _CatalogWebServiceSoap webService;

    public CatalogWebServiceProxy(TFSConfigurationServer server) {
        this.webService = (_CatalogWebServiceSoap)server.getWebService(_CatalogWebServiceSoap.class);
    }

    public CatalogResourceType[] queryResourceTypes(GUID[] resourceTypeIdentifiers) {
        try {
            Object[] resourceTypes = this.webService.queryResourceTypes(GUID.toStringArray(resourceTypeIdentifiers));
            return (CatalogResourceType[])WrapperUtils.wrap(CatalogResourceType.class, resourceTypes);
        }
        catch (ProxyException e) {
            throw CatalogExceptionMapper.map(e);
        }
    }

    public CatalogData queryNodes(String[] pathSpecs, GUID[] resourceTypeFilters, CatalogResourceProperty[] propertyFilters, int queryOptions) {
        try {
            String[] types = GUID.toStringArray(resourceTypeFilters);
            _KeyValueOfStringString[] properties = CatalogResourceProperty.toKeyValueOfStringStringArray(propertyFilters);
            _CatalogData data = this.webService.queryNodes(pathSpecs, types, properties, queryOptions);
            return new CatalogData(data);
        }
        catch (ProxyException e) {
            throw CatalogExceptionMapper.map(e);
        }
    }

    public CatalogData queryResources(GUID[] resourceTypeFilters, int queryOptions) {
        try {
            _CatalogData data = this.webService.queryResources(GUID.toStringArray(resourceTypeFilters), queryOptions);
            return new CatalogData(data);
        }
        catch (ProxyException e) {
            throw CatalogExceptionMapper.map(e);
        }
    }

    public CatalogData queryResourcesByType(GUID[] resourceTypeFilters, CatalogResourceProperty[] propertyFilters, int queryOptions) {
        try {
            String[] types = GUID.toStringArray(resourceTypeFilters);
            _KeyValueOfStringString[] properties = CatalogResourceProperty.toKeyValueOfStringStringArray(propertyFilters);
            _CatalogData data = this.webService.queryResourcesByType(types, properties, queryOptions);
            return new CatalogData(data);
        }
        catch (ProxyException e) {
            throw CatalogExceptionMapper.map(e);
        }
    }

    public CatalogData queryDependents(String path, int queryOptions) {
        try {
            _CatalogData data = this.webService.queryDependents(path, queryOptions);
            return new CatalogData(data);
        }
        catch (ProxyException e) {
            throw CatalogExceptionMapper.map(e);
        }
    }

    public CatalogData queryParents(GUID resourceIdentifier, String[] pathFilters, GUID[] resourceTypeFilters, boolean recurseToRoot, int queryOptions) {
        try {
            String id = resourceIdentifier.getGUIDString();
            String[] types = GUID.toStringArray(resourceTypeFilters);
            _CatalogData data = this.webService.queryParents(id, pathFilters, types, recurseToRoot, queryOptions);
            return new CatalogData(data);
        }
        catch (ProxyException e) {
            throw CatalogExceptionMapper.map(e);
        }
    }
}

