/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.configuration.compatibility;

import com.microsoft.tfs.core.clients.commonstructure.CommonStructureClient;
import com.microsoft.tfs.core.clients.commonstructure.ProjectInfo;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogResourceTypes;
import com.microsoft.tfs.core.clients.framework.configuration.TFSEntity;
import com.microsoft.tfs.core.clients.framework.configuration.compatibility.ReportingFolderCompatibilityEntity;
import com.microsoft.tfs.core.clients.framework.configuration.compatibility.TFSCompatibilityEntity;
import com.microsoft.tfs.core.clients.framework.configuration.compatibility.TeamProjectCompatibilityEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.OrganizationalRootEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ProjectCollectionEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ReportingConfigurationEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ReportingFolderEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.TeamProjectEntity;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProjectCollectionCompatibilityEntity
extends TFSCompatibilityEntity
implements ProjectCollectionEntity {
    private static final Log log = LogFactory.getLog(ProjectCollectionCompatibilityEntity.class);
    private final Object lock = new Object();
    private TeamProjectCompatibilityEntity[] teamProjects;
    private ReportingFolderEntity reportingFolder;

    public ProjectCollectionCompatibilityEntity(TFSCompatibilityEntity parent) {
        super(parent);
    }

    @Override
    public GUID getResourceID() {
        return CatalogResourceTypes.PROJECT_COLLECTION;
    }

    @Override
    public String getDisplayName() {
        return this.getConnection().getName();
    }

    @Override
    public GUID getInstanceID() {
        return GUID.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TeamProjectEntity[] getTeamProjects() {
        Object object = this.lock;
        synchronized (object) {
            if (this.teamProjects == null) {
                CommonStructureClient cssClient = (CommonStructureClient)this.getConnection().getClient(CommonStructureClient.class);
                ProjectInfo[] projects = cssClient.listProjects();
                this.teamProjects = new TeamProjectCompatibilityEntity[projects.length];
                for (int i = 0; i < projects.length; ++i) {
                    this.teamProjects[i] = new TeamProjectCompatibilityEntity(this, projects[i]);
                }
            }
            return this.teamProjects;
        }
    }

    @Override
    public TeamProjectEntity getTeamProject(GUID projectId) {
        Check.notNull(projectId, "projectId");
        TeamProjectEntity[] projects = this.getTeamProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!projectId.equals(projects[i].getProjectID())) continue;
            return projects[i];
        }
        return null;
    }

    @Override
    public ReportingConfigurationEntity getReportingConfiguration() {
        TFSEntity ancestor = this.getParent();
        if (ancestor != null && (ancestor = ancestor.getParent()) != null && ancestor instanceof OrganizationalRootEntity) {
            return ((OrganizationalRootEntity)ancestor).getReportingConfiguration();
        }
        log.warn((Object)"Compatibility configuration hierarchy unbalanced");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportingFolderEntity getReportingFolder() {
        Object object = this.lock;
        synchronized (object) {
            if (this.reportingFolder == null) {
                this.reportingFolder = new ReportingFolderCompatibilityEntity(this, "");
            }
            return this.reportingFolder;
        }
    }
}

