/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.security;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.TFSConnection;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.registration.RegistrationClient;
import com.microsoft.tfs.core.clients.registration.RegistrationEntry;
import com.microsoft.tfs.core.clients.security.FrameworkSecurityNamespace;
import com.microsoft.tfs.core.clients.security.ISecurityService;
import com.microsoft.tfs.core.clients.security.SecurityNamespace;
import com.microsoft.tfs.core.clients.security.SecurityNamespaceDescription;
import com.microsoft.tfs.core.clients.security.exceptions.SecurityServiceException;
import com.microsoft.tfs.util.GUID;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import ms.ws._SecurityNamespaceDescription;
import ms.ws._SecurityWebServiceSoap;

public class SecurityService
implements ISecurityService {
    private final TFSConnection connection;
    private final Map<GUID, SecurityNamespace> namespaces = new HashMap<GUID, SecurityNamespace>();
    private volatile boolean namespacesLoaded;
    private final ReadWriteLock accessLock = new ReentrantReadWriteLock();
    private final _SecurityWebServiceSoap m_securityProxy;

    public SecurityService(TFSConnection connection) {
        this.connection = connection;
        if (connection instanceof TFSTeamProjectCollection) {
            RegistrationClient registrationService = (RegistrationClient)connection.getClient(RegistrationClient.class);
            RegistrationEntry frameworkEntry = registrationService.getRegistrationEntry("Framework");
            if (frameworkEntry == null) {
                throw new SecurityServiceException(Messages.getString("SecurityService.ServiceNotSupportedPreFramework"));
            }
        } else {
            throw new SecurityServiceException(Messages.getString("SecurityService.ServiceNotSupportedPreFramework"));
        }
        this.m_securityProxy = (_SecurityWebServiceSoap)connection.getWebService(_SecurityWebServiceSoap.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecurityNamespace createSecurityNamespace(SecurityNamespaceDescription description) {
        if (this.m_securityProxy == null) {
            throw new SecurityServiceException(Messages.getString("SecurityService.OperationNotSuportedPreFramework"));
        }
        boolean locked = false;
        try {
            this.ensureNamespacesLoaded();
            this.m_securityProxy.createSecurityNamespace(description.getWebServiceObject());
            this.accessLock.writeLock().lock();
            locked = true;
            FrameworkSecurityNamespace securityNamespace = new FrameworkSecurityNamespace(this.connection, description);
            this.namespaces.put(((SecurityNamespace)securityNamespace).getDescription().getNamespaceId(), securityNamespace);
            FrameworkSecurityNamespace frameworkSecurityNamespace = securityNamespace;
            return frameworkSecurityNamespace;
        }
        finally {
            if (locked) {
                this.accessLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteSecurityNamespace(GUID namespaceId) {
        if (this.m_securityProxy == null) {
            throw new SecurityServiceException(Messages.getString("SecurityService.OperationNotSuportedPreFramework"));
        }
        boolean locked = false;
        try {
            this.ensureNamespacesLoaded();
            this.m_securityProxy.deleteSecurityNamespace(namespaceId.getGUIDString());
            this.accessLock.writeLock().lock();
            locked = true;
            if (this.namespaces.remove(namespaceId) != null) {
                this.accessLock.writeLock().unlock();
                locked = false;
                this.m_securityProxy.deleteSecurityNamespace(namespaceId.getGUIDString());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (locked) {
                this.accessLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecurityNamespace getSecurityNamespace(GUID namespaceId) {
        boolean locked = false;
        try {
            SecurityNamespace securityNamespace;
            this.ensureNamespacesLoaded();
            this.accessLock.readLock().lock();
            locked = true;
            SecurityNamespace securityNamespace2 = securityNamespace = this.namespaces.get(namespaceId);
            return securityNamespace2;
        }
        finally {
            if (locked) {
                this.accessLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecurityNamespace[] getSecurityNamespaces() {
        boolean locked = false;
        try {
            this.ensureNamespacesLoaded();
            this.accessLock.readLock().lock();
            locked = true;
            Collection<SecurityNamespace> values = this.namespaces.values();
            SecurityNamespace[] securityNamespaceArray = values.toArray(new SecurityNamespace[values.size()]);
            return securityNamespaceArray;
        }
        finally {
            if (locked) {
                this.accessLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureNamespacesLoaded() {
        if (this.namespacesLoaded) {
            return;
        }
        boolean locked = false;
        try {
            this.accessLock.writeLock().lock();
            locked = true;
            if (this.m_securityProxy != null) {
                _SecurityNamespaceDescription[] descriptions;
                for (_SecurityNamespaceDescription description : descriptions = this.m_securityProxy.querySecurityNamespaces(GUID.EMPTY.getGUIDString())) {
                    FrameworkSecurityNamespace securityNamespace = new FrameworkSecurityNamespace(this.connection, new SecurityNamespaceDescription(description));
                    this.namespaces.put(((SecurityNamespace)securityNamespace).getDescription().getNamespaceId(), securityNamespace);
                }
                this.namespacesLoaded = true;
            } else if (this.connection instanceof TFSTeamProjectCollection) {
                throw new SecurityServiceException(Messages.getString("SecurityService.OperationNotSuportedPreFramework"));
            }
        }
        finally {
            if (locked) {
                this.accessLock.writeLock().unlock();
            }
        }
    }
}

