/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.sharepoint;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.sharepoint.WSSDocumentLibrary;
import com.microsoft.tfs.core.clients.sharepoint.WSSNode;
import com.microsoft.tfs.core.ws.runtime.client.SOAPService;
import com.microsoft.tfs.core.ws.runtime.types.DOMAnyContentType;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.xml.DOMCreateUtils;
import com.microsoft.tfs.util.xml.DOMUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import ms.wss._ListsSoap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSClient {
    private final _ListsSoap webService;
    private final TFSTeamProjectCollection connection;

    public WSSClient(TFSTeamProjectCollection connection, _ListsSoap webService, String projectName) {
        Check.notNull(connection, "connection");
        Check.notNull(webService, "webService");
        Check.notNullOrEmpty(projectName, "projectName");
        this.connection = connection;
        this.webService = webService;
    }

    public String getFixedURI(String uri) {
        try {
            String url = this.connection.getRegistrationClient().getServiceInterfaceURL("Wss", "BaseSiteUrl");
            if (url == null || url.length() == 0) {
                return uri;
            }
            URI registeredEndpointUri = new URI(url);
            URI passedUri = new URI(uri);
            if (passedUri.getScheme().equals(registeredEndpointUri.getScheme()) && passedUri.getHost().equals(registeredEndpointUri.getHost()) && passedUri.getPort() == registeredEndpointUri.getPort()) {
                URI endpointUri = ((SOAPService)((Object)this.webService)).getEndpoint();
                URI fixedUri = new URI(endpointUri.getScheme(), endpointUri.getHost(), passedUri.getPath(), passedUri.getQuery(), passedUri.getFragment());
                return fixedUri.toASCIIString();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return uri;
    }

    public WSSDocumentLibrary[] getDocumentLibraries(boolean refresh) {
        ArrayList<WSSDocumentLibrary> docLibs = new ArrayList<WSSDocumentLibrary>();
        Element[] messageElement = ((DOMAnyContentType)this.webService.getListCollection(new DOMAnyContentType())).getElements();
        Element[] elements = DOMUtils.getChildElements(messageElement[0]);
        for (int i = 0; i < elements.length; ++i) {
            WSSDocumentLibrary docLib;
            Element element = elements[i];
            if (!"101".equals(element.getAttribute("ServerTemplate")) || (docLib = new WSSDocumentLibrary(this.connection, element)).isHidden() || !docLib.isValid()) continue;
            docLib.addChildren(this.getListItems(docLib, this.webService));
            docLibs.add(docLib);
        }
        Collections.sort(docLibs);
        return docLibs.toArray(new WSSDocumentLibrary[docLibs.size()]);
    }

    private List getListItems(WSSDocumentLibrary docLib, _ListsSoap proxy) {
        DOMAnyContentType query = this.getListItemQuery(docLib);
        DOMAnyContentType fields = this.getFields();
        DOMAnyContentType options = this.getQueryOptions();
        DOMAnyContentType anyContent = (DOMAnyContentType)proxy.getListItems(docLib.getGUID(), null, query, fields, "50000", options, null, new DOMAnyContentType());
        if (anyContent != null && anyContent.getElements() != null && anyContent.getElements().length > 0) {
            return this.buildHierarchy(docLib, anyContent.getElements()[0]);
        }
        return new LinkedList();
    }

    private LinkedList buildHierarchy(WSSDocumentLibrary parent, Element listData) {
        WSSNode node;
        Element data = DOMUtils.getChildElements(listData)[0];
        int items = Integer.parseInt(data.getAttribute("ItemCount"));
        LinkedList<WSSNode> list = new LinkedList<WSSNode>();
        HashMap<String, WSSNode> folders = new HashMap<String, WSSNode>(items);
        String rootFolder = null;
        Element[] elements = DOMUtils.getChildElements(data);
        for (int i = 0; i < elements.length; ++i) {
            node = WSSNode.buildWSSNode(elements[i]);
            if ("1".equals(node.getWSSObjectType())) {
                folders.put(node.getFullPath(), node);
            }
            if (rootFolder == null || node.getPath().length() < rootFolder.length()) {
                rootFolder = node.getPath();
            }
            node.setParent(parent);
            list.addFirst(node);
        }
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            node = (WSSNode)it.next();
            if (folders.containsKey(node.getPath())) {
                ((WSSNode)folders.get(node.getPath())).addChild(node);
                it.remove();
                continue;
            }
            if (node.getPath().length() == rootFolder.length()) continue;
            it.remove();
        }
        return list;
    }

    public DOMAnyContentType getListItemQuery(WSSDocumentLibrary docLib) {
        Check.notNull(docLib, "docLib");
        Document document = DOMCreateUtils.newDocument("Query");
        Element query = document.getDocumentElement();
        Element where = DOMUtils.appendChild(query, "Where");
        Element contains = DOMUtils.appendChild(where, "Contains");
        DOMUtils.appendChild(contains, "FieldRef").setAttribute("Name", "FileRef");
        Element value = DOMUtils.appendChildWithText(contains, "Value", "/" + docLib.getASCIIName() + "/");
        value.setAttribute("Type", "Text");
        Element orderBy = DOMUtils.appendChild(where, "OrderBy");
        Element fieldRef2 = DOMUtils.appendChild(orderBy, "FieldRef");
        fieldRef2.setAttribute("Name", "FileDirRef");
        fieldRef2.setAttribute("Ascending", "true");
        return new DOMAnyContentType(new Element[]{query});
    }

    public DOMAnyContentType getFields() {
        Document document = DOMCreateUtils.newDocument("ViewFields");
        Element root = document.getDocumentElement();
        Element viewFields = DOMUtils.appendChild(root, "ViewFields");
        DOMUtils.appendChild(viewFields, "FieldRef").setAttribute("Name", "ID");
        DOMUtils.appendChild(viewFields, "FieldRef").setAttribute("Name", "FSObjType");
        DOMUtils.appendChild(viewFields, "FieldRef").setAttribute("Name", "FileRef");
        DOMUtils.appendChild(viewFields, "FieldRef").setAttribute("Name", "FileLeafRef");
        return new DOMAnyContentType(new Element[]{root});
    }

    public DOMAnyContentType getQueryOptions() {
        Document document = DOMCreateUtils.newDocument("QueryOptions");
        Element root = document.getDocumentElement();
        DOMUtils.appendChildWithText(root, "IncludeMandatoryColumns", "false");
        DOMUtils.appendChild(root, "ViewAttributes").setAttribute("Scope", "RecursiveAll");
        return new DOMAnyContentType(new Element[]{root});
    }
}

