/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol;

import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.util.Check;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;

public class PropertiesMergeSummary {
    private int totalConflicts = 0;
    private int totalTheirChanges = 0;
    private int totalYourChanges = 0;
    private boolean isRedundant = true;
    private PropertyValue[] mergedProperties;

    private PropertiesMergeSummary() {
    }

    public int getTotalConflicts() {
        return this.totalConflicts;
    }

    public int getTotalTheirChanges() {
        return this.totalTheirChanges;
    }

    public int getTotalYourChanges() {
        return this.totalYourChanges;
    }

    public boolean isRedundant() {
        return this.isRedundant;
    }

    public PropertyValue[] getMergedProperties() {
        return this.mergedProperties;
    }

    public void setMergedProperties(PropertyValue[] mergedProperties) {
        this.mergedProperties = mergedProperties;
    }

    public static PropertiesMergeSummary calculateSummary(PropertyValue[] baseProperties, PropertyValue[] yourProperties, PropertyValue[] theirProperties) {
        MergedProperty mergedProperty;
        Check.notNull(yourProperties, "yourProperties");
        Check.notNull(theirProperties, "theirProperties");
        TreeMap<String, MergedProperty> mergedProperties = new TreeMap<String, MergedProperty>(String.CASE_INSENSITIVE_ORDER);
        if (baseProperties != null) {
            for (PropertyValue property : baseProperties) {
                mergedProperty = new MergedProperty();
                mergedProperty.setBaseProperty(property);
                mergedProperties.put(property.getPropertyName(), mergedProperty);
            }
        }
        for (PropertyValue property : yourProperties) {
            mergedProperty = (MergedProperty)mergedProperties.get(property.getPropertyName());
            if (mergedProperty == null) {
                mergedProperty = new MergedProperty();
                mergedProperties.put(property.getPropertyName(), mergedProperty);
            }
            mergedProperty.setYourProperty(property);
        }
        for (PropertyValue property : theirProperties) {
            mergedProperty = (MergedProperty)mergedProperties.get(property.getPropertyName());
            if (mergedProperty == null) {
                mergedProperty = new MergedProperty();
                mergedProperties.put(property.getPropertyName(), mergedProperty);
            }
            mergedProperty.setTheirProperty(property);
        }
        PropertiesMergeSummary mergeSummary = new PropertiesMergeSummary();
        ArrayList<PropertyValue> mergeResult = new ArrayList<PropertyValue>();
        for (MergedProperty mergedProperty2 : mergedProperties.values()) {
            mergeSummary.totalYourChanges = mergeSummary.totalYourChanges + (mergedProperty2.isYoursChanged() ? 1 : 0);
            mergeSummary.totalTheirChanges = mergeSummary.totalTheirChanges + (mergedProperty2.isTheirsChanged() ? 1 : 0);
            if (mergedProperty2.isRedundant()) {
                mergeSummary.isRedundant = true;
            }
            if (mergedProperty2.isConflicting()) {
                ++mergeSummary.totalConflicts;
                mergeResult = null;
                continue;
            }
            if (mergeResult == null || mergedProperty2.getMergeResult() == null) continue;
            mergeResult.add(mergedProperty2.getMergeResult());
        }
        mergeSummary.setMergedProperties(mergeResult == null ? null : mergeResult.toArray(new PropertyValue[mergeResult.size()]));
        return mergeSummary;
    }

    private static class MergedProperty {
        private PropertyValue baseProperty;
        private PropertyValue yourProperty;
        private PropertyValue theirProperty;
        private Boolean isYoursChanged;
        private Boolean isTheirsChanged;
        private Boolean isConflicting;
        private Boolean isRedundant;

        private MergedProperty() {
        }

        public void setBaseProperty(PropertyValue baseProperty) {
            this.baseProperty = baseProperty;
        }

        public void setYourProperty(PropertyValue yourProperty) {
            this.yourProperty = yourProperty;
        }

        public void setTheirProperty(PropertyValue theirProperty) {
            this.theirProperty = theirProperty;
        }

        public boolean isYoursChanged() {
            if (this.isYoursChanged == null) {
                this.isYoursChanged = !MergedProperty.propertiesAreEqual(this.baseProperty, this.yourProperty);
            }
            return this.isYoursChanged;
        }

        public boolean isTheirsChanged() {
            if (this.isTheirsChanged == null) {
                this.isTheirsChanged = !MergedProperty.propertiesAreEqual(this.baseProperty, this.theirProperty);
            }
            return this.isTheirsChanged;
        }

        public boolean isConflicting() {
            if (this.isConflicting == null) {
                this.isConflicting = !this.isYoursChanged() || !this.isTheirsChanged() ? Boolean.valueOf(false) : Boolean.valueOf(!MergedProperty.propertiesAreEqual(this.yourProperty, this.theirProperty));
            }
            return this.isConflicting;
        }

        public boolean isRedundant() {
            if (this.isRedundant == null) {
                this.isRedundant = MergedProperty.propertiesAreEqual(this.yourProperty, this.theirProperty);
            }
            return this.isRedundant;
        }

        public PropertyValue getMergeResult() {
            if (this.isConflicting()) {
                return null;
            }
            return this.isYoursChanged() ? this.yourProperty : this.theirProperty;
        }

        private static boolean propertiesAreEqual(PropertyValue property1, PropertyValue property2) {
            if (property1 == null && property2 == null) {
                return true;
            }
            if (property1 == null || property2 == null) {
                return false;
            }
            if (property1.getPropertyType() != property2.getPropertyType()) {
                return false;
            }
            if (byte[].class.equals(property1.getPropertyType())) {
                return Arrays.equals((byte[])property1.getPropertyValue(), (byte[])property2.getPropertyValue());
            }
            if (property1.getPropertyValue() == null) {
                return property2.getPropertyValue() == null;
            }
            return property1.getPropertyValue().equals(property2.getPropertyValue());
        }
    }
}

