/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.checkinpolicies.PolicyDefinition;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Failure;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.SeverityType;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;

public class TeamProject {
    private final Item item;
    private final VersionControlClient client;

    public TeamProject(Item item, VersionControlClient client) {
        Check.notNull(item, "item");
        Check.notNull(client, "client");
        this.item = item;
        this.client = client;
    }

    public static TeamProject[] fromItems(Item[] items, VersionControlClient client) {
        Check.notNull(items, "items");
        Check.notNull(client, "client");
        TeamProject[] ret = new TeamProject[items.length];
        for (int i = 0; i < items.length; ++i) {
            ret[i] = new TeamProject(items[i], client);
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TeamProject)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TeamProject other = (TeamProject)obj;
        if (this.getVersionControlClient().getServerGUID().equals(other.getVersionControlClient().getServerGUID())) {
            return this.getName().equals(other.getName());
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + this.getVersionControlClient().getServerGUID().hashCode();
        result = result * 37 + this.getName().hashCode();
        return result;
    }

    public String getServerItem() {
        return this.item.getServerItem();
    }

    public String getName() {
        return ServerPath.getTeamProjectName(this.getServerItem());
    }

    public VersionControlClient getVersionControlClient() {
        return this.client;
    }

    public int getItemID() {
        return this.item.getItemID();
    }

    public PolicyDefinition[] getCheckinPolicies() {
        return this.getVersionControlClient().getCheckinPoliciesForServerPaths(new String[]{this.getServerItem()});
    }

    public static Failure validateChange(String serverItem, ItemType type) {
        Check.notNullOrEmpty(serverItem, "serverItem");
        Check.notNull(type, "type");
        if (ServerPath.isRootFolder(serverItem)) {
            return new Failure(Messages.getString("TeamProject.CanNotChangeRootFolderException"), "CannotChangeRootFolderException", SeverityType.ERROR, serverItem);
        }
        if (ServerPath.isTeamProject(serverItem)) {
            if (type == ItemType.FILE) {
                return new Failure(Messages.getString("TeamProject.CannotCreateFilesInRootException"), "CannotCreateFilesInRootException", SeverityType.ERROR, serverItem);
            }
            return new Failure(MessageFormat.format(Messages.getString("TeamProject.InvalidProjectPendingChangeExceptionFormat"), serverItem), "InvalidProjectPendingChangeException", SeverityType.ERROR, serverItem);
        }
        return null;
    }
}

