/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;

public class UploadedBaselinesCollection {
    private final Map<String, UploadedBaseline> uploadedBaselines = new TreeMap<String, UploadedBaseline>(String.CASE_INSENSITIVE_ORDER);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUploadedBaseline(String targetLocalItem, byte[] baselineFileGuid, long uncompressedLength) {
        Map<String, UploadedBaseline> map = this.uploadedBaselines;
        synchronized (map) {
            this.uploadedBaselines.put(targetLocalItem, new UploadedBaseline(baselineFileGuid, uncompressedLength));
        }
    }

    public byte[] getUploadedBaseline(String targetLocalItem, AtomicLong outUncompressedLength) {
        outUncompressedLength.set(-1L);
        UploadedBaseline toReturn = this.uploadedBaselines.get(targetLocalItem);
        if (toReturn != null) {
            outUncompressedLength.set(toReturn.uncompressedLength);
            return toReturn.baselineFileGUID;
        }
        return null;
    }

    public void removeUploadedBaseline(String targetLocalItem) {
        this.uploadedBaselines.remove(targetLocalItem);
    }

    public int getCount() {
        return this.uploadedBaselines.size();
    }

    private class UploadedBaseline {
        public final byte[] baselineFileGUID;
        public final long uncompressedLength;

        public UploadedBaseline(byte[] baselineFileGUID, long uncompressedLength) {
            this.baselineFileGUID = baselineFileGUID;
            this.uncompressedLength = uncompressedLength;
        }
    }
}

