/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspacePermissions;
import com.microsoft.tfs.core.clients.versioncontrol.events.ChangesetReconciledEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.events.FolderContentChangedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkspaceCacheFileReloadedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkspaceEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkspaceUpdatedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkstationNonFatalErrorEvent;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalItemExclusionCache;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ServerSettings;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.KeyValuePair;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.InternalWorkspaceConflictInfo;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkspaceInfo;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkstationType;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.internal.InternalCache;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.internal.InternalCacheLoader;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.internal.InternalServerInfo;
import com.microsoft.tfs.core.config.persistence.PersistenceStoreProvider;
import com.microsoft.tfs.core.persistence.FilesystemPersistenceStore;
import com.microsoft.tfs.core.util.SpecialFolders;
import com.microsoft.tfs.core.util.notifications.Notification;
import com.microsoft.tfs.core.util.notifications.NotificationListener;
import com.microsoft.tfs.core.util.notifications.NotificationManager;
import com.microsoft.tfs.jni.PlatformMiscUtils;
import com.microsoft.tfs.jni.helpers.LocalHost;
import com.microsoft.tfs.util.CLRHashUtil;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.Platform;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Workstation {
    private static final Log log = LogFactory.getLog(Workstation.class);
    private static final String NON_WINDOWS_OFFLINE_STORAGE_CHILD_NAME = "TFS-Offline";
    private static Map<PersistenceStoreProvider, Workstation> currentWorkstation = new HashMap<PersistenceStoreProvider, Workstation>();
    private final WorkstationType type;
    private final boolean cacheEnabled;
    private final File cacheDirectory;
    private final File workspaceCacheFile;
    private final Object cacheMutex = new Object();
    private InternalCache workspaceCache;
    private boolean cacheFileChanged;
    private final Map<String, Long> workspacesLoadedTable = new HashMap<String, Long>();
    private final boolean configurationEnabled;
    private final File configurationDirectory;
    private final File localItemExclusionCacheFile;
    private final Object configurationMutex = new Object();
    private LocalItemExclusionCache localItemExclusionCache;
    private NotificationManager notificationManager;
    private final Object notificationManagerLock = new Object();
    private final NotificationListener notificationListener = new NotificationListener(){

        @Override
        public void notificationReceived(Notification notification, long param1, long param2) {
            Workstation.this.handleNotification(notification, param1, param2);
        }
    };
    private final List<VersionControlClient> workstationEventListeners = new ArrayList<VersionControlClient>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Workstation(WorkstationType type, PersistenceStoreProvider persistenceProvider) {
        Check.notNull(type, "type");
        this.type = type;
        if (type == WorkstationType.CURRENT) {
            Check.notNull(persistenceProvider, "persistenceProvider");
            Object object = this.cacheMutex;
            synchronized (object) {
                this.cacheDirectory = Workstation.getCacheDirectory(persistenceProvider);
                this.cacheEnabled = this.cacheDirectory != null ? Workstation.ensureLocalPathIsUsable(this.cacheDirectory, "VersionControl.config") : false;
                this.workspaceCacheFile = this.cacheEnabled ? new File(this.cacheDirectory, "VersionControl.config") : null;
                AtomicReference<InternalWorkspaceConflictInfo[]> conflictingWorkspaces = new AtomicReference<InternalWorkspaceConflictInfo[]>();
                this.workspaceCache = InternalCacheLoader.loadConfig(null, this.cacheEnabled, conflictingWorkspaces, this.cacheMutex, this.workspaceCacheFile);
                Check.isTrue(conflictingWorkspaces.get().length == 0, "conflictingWorkspaces.get().length == 0");
            }
            object = this.configurationMutex;
            synchronized (object) {
                this.configurationDirectory = Workstation.getConfigurationDirectory(persistenceProvider);
                this.configurationEnabled = this.configurationDirectory != null ? Workstation.ensureLocalPathIsUsable(this.configurationDirectory, "LocalItemExclusions.config") : false;
                this.localItemExclusionCacheFile = this.configurationEnabled ? new File(this.configurationDirectory, "LocalItemExclusions.config") : null;
            }
        }
        this.cacheDirectory = null;
        this.cacheEnabled = false;
        this.workspaceCacheFile = null;
        this.configurationDirectory = null;
        this.configurationEnabled = false;
        this.localItemExclusionCacheFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Workstation getCurrent(PersistenceStoreProvider persistenceProvider) {
        Check.notNull(persistenceProvider, "persistenceProvider");
        Map<PersistenceStoreProvider, Workstation> map = currentWorkstation;
        synchronized (map) {
            Workstation w = currentWorkstation.get(persistenceProvider);
            if (w == null) {
                w = new Workstation(WorkstationType.CURRENT, persistenceProvider);
                currentWorkstation.put(persistenceProvider, w);
            }
            return w;
        }
    }

    public void addWorkstationEventListener(VersionControlClient client) {
        this.workstationEventListeners.add(client);
    }

    public void removeWorkstationEventListener(VersionControlClient client) {
        this.workstationEventListeners.remove(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationManager setNotificationManager(NotificationManager newManager) {
        Object object = this.notificationManagerLock;
        synchronized (object) {
            if (this.notificationManager == newManager) {
                return this.notificationManager;
            }
            NotificationManager oldManager = this.notificationManager;
            if (oldManager != null) {
                oldManager.removeListener(this.notificationListener);
            }
            this.notificationManager = newManager;
            if (newManager != null) {
                this.notificationManager.addListener(this.notificationListener);
            }
            return oldManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationManager getNotificationManager() {
        Object object = this.notificationManagerLock;
        synchronized (object) {
            return this.notificationManager;
        }
    }

    private void handleNotification(Notification notification, long param1, long param2) {
        Check.notNull(notification, "notification");
        if (notification.getValue() <= Notification.VERSION_CONTROL_NOTIFICATION_BEGIN.getValue() || notification.getValue() >= Notification.VERSION_CONTROL_NOTIFICATION_END.getValue()) {
            return;
        }
        log.trace((Object)MessageFormat.format("Received notification {0} ({1}, {2})", notification, Long.toHexString(param1), Long.toHexString(param2)));
        if (Notification.VERSION_CONTROL_WORKSPACE_CREATED == notification || Notification.VERSION_CONTROL_WORKSPACE_CHANGED == notification) {
            this.reloadCache();
        }
        if (notification == Notification.VERSION_CONTROL_WORKSPACE_CREATED || notification == Notification.VERSION_CONTROL_WORKSPACE_DELETED || notification == Notification.VERSION_CONTROL_WORKSPACE_CHANGED || notification == Notification.VERSION_CONTROL_PENDING_CHANGES_CHANGED || notification == Notification.VERSION_CONTROL_GET_COMPLETED || notification == Notification.VERSION_CONTROL_LOCAL_WORKSPACE_SCAN) {
            int collectionHashCode = (int)param1;
            int workspaceHashCode = (int)param2;
            for (WorkspaceInfo wsInfo : this.getAllLocalWorkspaceInfo()) {
                if (!this.matchesNotification(wsInfo, collectionHashCode, workspaceHashCode)) continue;
                for (VersionControlClient client : this.workstationEventListeners) {
                    if (!client.getServerGUID().equals(wsInfo.getServerGUID())) continue;
                    WorkspaceEvent event = new WorkspaceEvent(EventSource.newFromHere(), client.getWorkspace(wsInfo), WorkspaceEvent.WorkspaceEventSource.EXTERNAL);
                    if (notification == Notification.VERSION_CONTROL_WORKSPACE_CREATED) {
                        client.getEventEngine().fireWorkspaceCreated(event);
                        continue;
                    }
                    if (notification == Notification.VERSION_CONTROL_WORKSPACE_DELETED) {
                        client.getEventEngine().fireWorkspaceDeleted(event);
                        continue;
                    }
                    if (notification == Notification.VERSION_CONTROL_WORKSPACE_CHANGED) {
                        client.getEventEngine().fireWorkspaceUpdated(new WorkspaceUpdatedEvent(event.getEventSource(), event.getWorkspace(), null, null, event.getWorkspaceSource()));
                        continue;
                    }
                    if (notification == Notification.VERSION_CONTROL_PENDING_CHANGES_CHANGED) {
                        client.getEventEngine().firePendingChangesChangedEvent(event);
                        continue;
                    }
                    if (notification == Notification.VERSION_CONTROL_GET_COMPLETED) {
                        client.getEventEngine().fireGetCompletedEvent(event);
                        continue;
                    }
                    if (notification != Notification.VERSION_CONTROL_LOCAL_WORKSPACE_SCAN) continue;
                    client.getEventEngine().fireLocalWorkspaceScanEvent(event);
                }
            }
        } else if (notification == Notification.VERSION_CONTROL_CHANGESET_RECONCILED || notification == Notification.VERSION_CONTROL_FOLDER_CONTENT_CHANGED) {
            int collectionHashCode = (int)param1;
            int changesetID = (int)param2;
            for (VersionControlClient client : this.workstationEventListeners) {
                if (!this.matchesNotification(client, collectionHashCode)) continue;
                if (notification == Notification.VERSION_CONTROL_CHANGESET_RECONCILED) {
                    client.getEventEngine().fireChangesetReconciledEvent(new ChangesetReconciledEvent(EventSource.newFromHere(), changesetID));
                    continue;
                }
                if (notification != Notification.VERSION_CONTROL_FOLDER_CONTENT_CHANGED) continue;
                client.getEventEngine().fireFolderContentChangedEvent(new FolderContentChangedEvent(EventSource.newFromHere(), client, changesetID));
            }
        }
        if (Notification.VERSION_CONTROL_WORKSPACE_DELETED == notification) {
            this.reloadCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyForWorkspace(Workspace workspace, Notification notification) {
        Check.notNull(workspace, "workspace");
        Check.notNull(notification, "notification");
        Object object = this.notificationManagerLock;
        synchronized (object) {
            if (this.notificationManager != null) {
                this.notificationManager.sendNotification(notification, this.getNotificationHashCode(workspace.getClient().getServerGUID()), this.getNotificationHashCode(workspace));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyForChangesetReconciled(VersionControlClient client, int changesetID) {
        Check.notNull(client, "client");
        Object object = this.notificationManagerLock;
        synchronized (object) {
            if (this.notificationManager != null) {
                this.notificationManager.sendNotification(Notification.VERSION_CONTROL_CHANGESET_RECONCILED, this.getNotificationHashCode(client.getServerGUID()), changesetID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyForFolderContentChanged(VersionControlClient client) {
        Check.notNull(client, "client");
        Object object = this.notificationManagerLock;
        synchronized (object) {
            if (this.notificationManager != null) {
                this.notificationManager.sendNotification(Notification.VERSION_CONTROL_FOLDER_CONTENT_CHANGED, this.getNotificationHashCode(client.getServerGUID()), -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyForFolderContentChanged(VersionControlClient client, int changesetID) {
        Check.notNull(client, "client");
        Object object = this.notificationManagerLock;
        synchronized (object) {
            if (this.notificationManager != null) {
                this.notificationManager.sendNotification(Notification.VERSION_CONTROL_FOLDER_CONTENT_CHANGED, this.getNotificationHashCode(client.getServerGUID()), changesetID);
            }
        }
    }

    private boolean matchesNotification(WorkspaceInfo workspaceInfo, int collectionHashCode, int workspaceHashCode) {
        return this.notificationMatchesCollectionAndWorkspace(collectionHashCode, workspaceHashCode, workspaceInfo.getServerGUID(), this.getNotificationWorkspaceSpec(workspaceInfo));
    }

    private boolean matchesNotification(VersionControlClient client, int collectionHashCode) {
        return this.notificationMatchesCollection(collectionHashCode, client.getServerGUID());
    }

    private boolean notificationMatchesCollection(int collectionHashCode, GUID collectionGUID) {
        return this.getNotificationHashCode(collectionGUID) == collectionHashCode;
    }

    private boolean notificationMatchesCollectionAndWorkspace(int collectionHashCode, int workspaceHashCode, GUID collectionGUID, String workspaceSpecString) {
        if (!this.notificationMatchesCollection(collectionHashCode, collectionGUID)) {
            return false;
        }
        return this.getNotificationHashCode(workspaceSpecString) == workspaceHashCode;
    }

    private String getNotificationWorkspaceSpec(WorkspaceInfo workspaceInfo) {
        return this.getNotificationWorkspaceSpec(workspaceInfo.getName(), workspaceInfo.getOwnerName());
    }

    private String getNotificationWorkspaceSpec(Workspace workspace) {
        return this.getNotificationWorkspaceSpec(workspace.getName(), workspace.getOwnerName());
    }

    private String getNotificationWorkspaceSpec(String workspaceName, String workspaceOwner) {
        return workspaceName + ";" + workspaceOwner;
    }

    private int getNotificationHashCode(Workspace workspace) {
        return this.getNotificationHashCode(this.getNotificationWorkspaceSpec(workspace));
    }

    private int getNotificationHashCode(String workspaceNotificationParam) {
        return CLRHashUtil.getStringHashOrcas64(workspaceNotificationParam);
    }

    private int getNotificationHashCode(GUID collectionGUID) {
        return CLRHashUtil.getStringHashOrcas64(collectionGUID.getGUIDString(GUID.GUIDStringFormat.DASHED).toUpperCase(Locale.ENGLISH));
    }

    private void onCacheFileReloaded() {
        for (VersionControlClient client : this.workstationEventListeners) {
            client.getRuntimeWorkspaceCache().invalidateAllWorkspaces();
            client.getEventEngine().fireWorkspaceCacheFileReloaded(new WorkspaceCacheFileReloadedEvent(EventSource.newFromHere(), this));
        }
    }

    private void onNonFatalError(InternalWorkspaceConflictInfo[] conflictingWorkspaces) {
        for (InternalWorkspaceConflictInfo iwci : conflictingWorkspaces) {
            this.onNonFatalError(new WorkstationNonFatalErrorEvent(EventSource.newFromHere(), iwci));
        }
    }

    private void onNonFatalError(WorkstationNonFatalErrorEvent event) {
        for (VersionControlClient client : this.workstationEventListeners) {
            client.getEventEngine().fireWorkstationNonFatalError(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkspaceInfo[] getAllLocalWorkspaceInfo() {
        Object object = this.cacheMutex;
        synchronized (object) {
            return this.getCache().getAllWorkspaces();
        }
    }

    public WorkspaceInfo getLocalWorkspaceInfo(VersionControlClient client, String workspaceName, String workspaceOwner) {
        return this.getLocalWorkspaceInfo(client.getServerGUID(), workspaceName, workspaceOwner);
    }

    public WorkspaceInfo getLocalWorkspaceInfo(GUID repositoryGuid, String workspaceName, String workspaceOwner) {
        Check.notNull(workspaceName, "workspaceName");
        Check.notNull(workspaceOwner, "workspaceOwner");
        this.requireFullyQualifiedUserName(workspaceOwner, "workspaceOwner");
        return this.getCache().getWorkspace(repositoryGuid, workspaceName, workspaceOwner);
    }

    public WorkspaceInfo getLocalWorkspaceInfo(String path) {
        Check.notNullOrEmpty(path, "path");
        path = LocalPath.canonicalize(path);
        return this.getCache().getWorkspace(path);
    }

    public WorkspaceInfo[] getLocalWorkspaceInfoRecursively(String path) {
        Check.notNullOrEmpty(path, "path");
        path = LocalPath.canonicalize(path);
        ArrayList<WorkspaceInfo> infoList = new ArrayList<WorkspaceInfo>();
        block0: for (WorkspaceInfo ws : this.getCache().getAllWorkspaces()) {
            for (String mappedPath : ws.getMappedPaths()) {
                if (!LocalPath.isChild(path, mappedPath)) continue;
                infoList.add(ws);
                continue block0;
            }
        }
        return infoList.toArray(new WorkspaceInfo[infoList.size()]);
    }

    public WorkspaceInfo[] queryLocalWorkspaceInfo(VersionControlClient client, String workspaceName, String workspaceOwner) {
        if (workspaceOwner == ".") {
            if (client != null) {
                workspaceOwner = client.getConnection().getAuthorizedAccountName();
            } else {
                this.requireFullyQualifiedUserName(workspaceOwner, "workspaceOwner");
            }
        }
        ArrayList<WorkspaceInfo> list = new ArrayList<WorkspaceInfo>();
        for (WorkspaceInfo workspaceInfo : this.getCache().getAllWorkspaces()) {
            if (client != null && !client.getServerGUID().equals(workspaceInfo.getServerGUID()) || workspaceName != null && !Workspace.matchName(workspaceInfo.getName(), workspaceName) || workspaceOwner != null && !workspaceInfo.ownerNameMatches(workspaceOwner)) continue;
            list.add(workspaceInfo);
        }
        return list.toArray(new WorkspaceInfo[list.size()]);
    }

    public boolean isMapped(String path) {
        Check.notNullOrEmpty(path, "path");
        path = LocalPath.canonicalize(path);
        return this.getCache().getMapping(path) != null;
    }

    public boolean isExplicitlyMapped(String path) {
        Check.notNullOrEmpty(path, "path");
        path = LocalPath.canonicalize(path);
        String mappedPath = this.getCache().getMapping(path);
        return mappedPath != null && LocalPath.equals(mappedPath, path);
    }

    public void ensureUpdateWorkspaceInfoCache(VersionControlClient client, String ownerName) {
        this.ensureUpdateWorkspaceInfoCache(client, ownerName, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureUpdateWorkspaceInfoCache(VersionControlClient client, String ownerName, long maxAgeMillis) {
        boolean needRefresh;
        String key;
        Check.notNull(client, "client");
        Check.notNullOrEmpty(ownerName, "ownerName");
        Object object = this.cacheMutex;
        synchronized (object) {
            key = this.createLoadWorkspacesTableKey(client, ownerName);
            needRefresh = !this.workspacesLoadedTable.containsKey(key) || System.currentTimeMillis() - this.workspacesLoadedTable.get(key) > maxAgeMillis;
        }
        if (needRefresh) {
            this.updateWorkspaceInfoCache(key, client, ownerName);
        }
    }

    public void updateServerURIReferences(VersionControlClient client, URI uri) {
        Check.notNull(client, "client");
        Check.notNull(uri, "uri");
        this.getCache().updateServerURI(client.getServerGUID(), uri);
        this.saveConfigIfDirty();
    }

    public void updateWorkspaceInfoCache(VersionControlClient client, String ownerName) {
        this.updateWorkspaceInfoCache(client, ownerName, new AtomicReference<Workspace[]>());
    }

    public void updateWorkspaceInfoCache(VersionControlClient client, String ownerName, AtomicReference<Workspace[]> workspaces) {
        Check.notNull(client, "client");
        Check.notNullOrEmpty(ownerName, "ownerName");
        Check.notNull(workspaces, "workspaces");
        String key = this.createLoadWorkspacesTableKey(client, ownerName);
        workspaces.set(this.updateWorkspaceInfoCache(key, client, ownerName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Workspace[] updateWorkspaceInfoCache(String key, VersionControlClient client, String ownerName) {
        Check.notNullOrEmpty(ownerName, "ownerName");
        ownerName = client.resolveUserUniqueName(ownerName);
        Workspace[] workspaces = null;
        workspaces = client.isAuthorizedUser(ownerName) ? client.queryWorkspaces(null, ownerName, this.getName(), WorkspacePermissions.READ.combine(WorkspacePermissions.USE)) : client.queryWorkspaces(null, ownerName, this.getName());
        client.refreshServerGUID();
        ArrayList<InternalWorkspaceConflictInfo> warningList = new ArrayList<InternalWorkspaceConflictInfo>();
        ArrayList<KeyValuePair<VersionControlException, Workspace>> errorList = new ArrayList<KeyValuePair<VersionControlException, Workspace>>();
        TreeSet<String> keysUpdated = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        keysUpdated.add(key);
        Object object = this.cacheMutex;
        synchronized (object) {
            List<WorkspaceInfo> list = this.removeCachedWorkspaceInfo(client, workspaces, false);
            list.addAll(this.removeCachedWorkspaceInfo(client, ownerName, false));
            for (Workspace workspace : workspaces) {
                try {
                    AtomicReference<InternalWorkspaceConflictInfo[]> cws1 = new AtomicReference<InternalWorkspaceConflictInfo[]>();
                    WorkspaceInfo info = this.getCache().insertWorkspace(workspace, cws1);
                    for (InternalWorkspaceConflictInfo iwci : cws1.get()) {
                        warningList.add(iwci);
                    }
                    this.copyLocalMetadata(info, list);
                    keysUpdated.addAll(this.createLoadWorkspacesTableKeys(client, workspace));
                }
                catch (VersionControlException exception) {
                    errorList.add(new KeyValuePair<VersionControlException, Workspace>(exception, workspace));
                }
            }
            AtomicReference<InternalWorkspaceConflictInfo[]> cws2 = new AtomicReference<InternalWorkspaceConflictInfo[]>();
            InternalCacheLoader.saveConfigIfDirty(this.getCache(), cws2, this.cacheMutex, this.workspaceCacheFile);
            for (InternalWorkspaceConflictInfo iwci : cws2.get()) {
                warningList.add(iwci);
            }
            Long now = System.currentTimeMillis();
            for (String updatedKey : keysUpdated) {
                this.workspacesLoadedTable.put(updatedKey, now);
            }
        }
        for (InternalWorkspaceConflictInfo internalWorkspaceConflictInfo : warningList) {
            this.onNonFatalError(new WorkstationNonFatalErrorEvent(EventSource.newFromHere(), internalWorkspaceConflictInfo));
        }
        for (KeyValuePair keyValuePair : errorList) {
            this.onNonFatalError(new WorkstationNonFatalErrorEvent(EventSource.newFromHere(), (Exception)keyValuePair.getKey(), (Workspace)keyValuePair.getValue()));
        }
        return workspaces;
    }

    private void copyLocalMetadata(WorkspaceInfo info, List<WorkspaceInfo> infoRemovedList) {
        for (WorkspaceInfo removedInfo : infoRemovedList) {
            if (!removedInfo.equals(info)) continue;
            info.copyLocalMetadata(removedInfo);
            break;
        }
    }

    private List<String> createLoadWorkspacesTableKeys(VersionControlClient client, Workspace workspace) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(this.createLoadWorkspacesTableKey(client, workspace.getOwnerName()));
        keys.add(this.createLoadWorkspacesTableKey(client, workspace.getOwnerDisplayName()));
        for (String alias : workspace.getOwnerAliases()) {
            keys.add(this.createLoadWorkspacesTableKey(client, alias));
        }
        return keys;
    }

    private String createLoadWorkspacesTableKey(VersionControlClient client, String ownerName) {
        return ownerName + '@' + client.getConnection().getBaseURI().toString();
    }

    public WorkspaceInfo insertWorkspaceIntoCache(Workspace localWorkspace) {
        AtomicReference<InternalWorkspaceConflictInfo[]> conflictingWorkspaces = new AtomicReference<InternalWorkspaceConflictInfo[]>();
        WorkspaceInfo workspaceInfo = this.getCache().insertWorkspace(localWorkspace, conflictingWorkspaces);
        this.onNonFatalError(conflictingWorkspaces.get());
        return workspaceInfo;
    }

    public WorkspaceInfo[] removeCachedWorkspaceInfo(VersionControlClient client) {
        Check.notNull(client, "client");
        List<WorkspaceInfo> ret = this.removeCachedWorkspaceInfo(client, client.getConnection().getAuthorizedAccountName(), true);
        return ret.toArray(new WorkspaceInfo[ret.size()]);
    }

    public WorkspaceInfo[] removeCachedWorkspaceInfo(VersionControlClient client, String ownerName) {
        Check.notNull(client, "client");
        Check.notNullOrEmpty(ownerName, "ownerName");
        ownerName = client.resolveUserUniqueName(ownerName);
        List<WorkspaceInfo> ret = this.removeCachedWorkspaceInfo(client, ownerName, true);
        return ret.toArray(new WorkspaceInfo[ret.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WorkspaceInfo> removeCachedWorkspaceInfo(VersionControlClient client, String ownerName, boolean saveConfigFile) {
        if (ownerName.equals(".")) {
            ownerName = client.getConnection().getAuthorizedAccountName();
        }
        ArrayList<WorkspaceInfo> infoRemovedList = new ArrayList<WorkspaceInfo>();
        Object object = this.cacheMutex;
        synchronized (object) {
            WorkspaceInfo[] allWorkspaceInfo;
            for (WorkspaceInfo workspaceInfo : allWorkspaceInfo = this.getAllLocalWorkspaceInfo()) {
                if (ownerName != null && !workspaceInfo.ownerNameMatches(ownerName) || !Workspace.matchServerURI(workspaceInfo.getServerURI(), client.getConnection().getBaseURI()) && !workspaceInfo.getServerGUID().equals(client.getServerGUID())) continue;
                this.getCache().removeWorkspace(workspaceInfo);
                infoRemovedList.add(workspaceInfo);
            }
            if (saveConfigFile) {
                this.saveConfigIfDirty();
            }
        }
        return infoRemovedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WorkspaceInfo> removeCachedWorkspaceInfo(VersionControlClient client, Workspace[] workspaces, boolean saveConfigFile) {
        TreeMap<String, Workspace> workspacesDict = new TreeMap<String, Workspace>(String.CASE_INSENSITIVE_ORDER);
        for (Workspace toBeRemoved : workspaces) {
            workspacesDict.put(toBeRemoved.getQualifiedName(), toBeRemoved);
        }
        ArrayList<WorkspaceInfo> infoRemovedList = new ArrayList<WorkspaceInfo>();
        Object object = this.cacheMutex;
        synchronized (object) {
            WorkspaceInfo[] allWorkspaceInfo;
            for (WorkspaceInfo workspaceInfo : allWorkspaceInfo = this.getAllLocalWorkspaceInfo()) {
                if (!Workspace.matchServerURI(workspaceInfo.getServerURI(), client.getConnection().getBaseURI()) && !workspaceInfo.getServerGUID().equals(client.getServerGUID()) || !workspacesDict.containsKey(workspaceInfo.getQualifiedName()) && workspaceInfo.getServerGUID().equals(client.getServerGUID())) continue;
                this.getCache().removeWorkspace(workspaceInfo);
                infoRemovedList.add(workspaceInfo);
            }
            if (saveConfigFile) {
                this.saveConfigIfDirty();
            }
        }
        return infoRemovedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkspaceInfo[] removeCachedWorkspaceInfo(URI serverUri, String workspaceName, String workspaceOwner) {
        ArrayList<WorkspaceInfo> infoRemovedList = new ArrayList<WorkspaceInfo>();
        Object object = this.cacheMutex;
        synchronized (object) {
            for (WorkspaceInfo workspaceInfo : this.getAllLocalWorkspaceInfo()) {
                if (serverUri != null && !Workspace.matchServerURI(workspaceInfo.getServerURI(), serverUri) || workspaceName != null && workspaceName.length() != 0 && !Workspace.matchName(workspaceInfo.getName(), workspaceName) || workspaceOwner != null && workspaceOwner.length() != 0 && !workspaceInfo.ownerNameMatches(workspaceOwner)) continue;
                this.getCache().removeWorkspace(workspaceInfo);
                infoRemovedList.add(workspaceInfo);
            }
            if (this.isCacheEnabled()) {
                this.saveConfigIfDirty();
            }
        }
        return infoRemovedList.toArray(new WorkspaceInfo[infoRemovedList.size()]);
    }

    private void requireFullyQualifiedUserName(String userName, String paramName) {
        Check.notNull(userName, "userName");
        if (".".equals(userName)) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("Workstation.FullyQualifiedUserNameRequiredFormat"), userName));
        }
    }

    public void saveConfigIfDirty() {
        if (this.isCacheEnabled()) {
            AtomicReference<InternalWorkspaceConflictInfo[]> conflictingWorkspaces = new AtomicReference<InternalWorkspaceConflictInfo[]>();
            InternalCacheLoader.saveConfigIfDirty(this.getCache(), conflictingWorkspaces, this.cacheMutex, this.workspaceCacheFile);
            this.onNonFatalError(conflictingWorkspaces.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalCache getCache() {
        InternalCache ret;
        boolean cacheReloaded = false;
        AtomicReference<InternalWorkspaceConflictInfo[]> outConflictingWorkspaces = new AtomicReference<InternalWorkspaceConflictInfo[]>();
        Object object = this.cacheMutex;
        synchronized (object) {
            cacheReloaded = this.ensureCacheLoaded(outConflictingWorkspaces);
            ret = this.workspaceCache;
        }
        if (cacheReloaded) {
            this.onNonFatalError(outConflictingWorkspaces.get());
            this.onCacheFileReloaded();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadCache() {
        boolean cacheReloaded = false;
        AtomicReference<InternalWorkspaceConflictInfo[]> outConflictingWorkspaces = new AtomicReference<InternalWorkspaceConflictInfo[]>();
        Object object = this.cacheMutex;
        synchronized (object) {
            if (this.cacheEnabled) {
                this.cacheFileChanged = true;
                cacheReloaded = this.ensureCacheLoaded(outConflictingWorkspaces);
            }
        }
        if (cacheReloaded) {
            this.onNonFatalError(outConflictingWorkspaces.get());
            this.onCacheFileReloaded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureCacheLoaded(AtomicReference<InternalWorkspaceConflictInfo[]> outConflictingWorkspaces) {
        Object object = this.cacheMutex;
        synchronized (object) {
            if (this.cacheFileChanged) {
                this.cacheFileChanged = false;
                this.workspaceCache = InternalCacheLoader.loadConfig(this.workspaceCache, this.cacheEnabled, outConflictingWorkspaces, this.cacheMutex, this.workspaceCacheFile);
                return true;
            }
            return false;
        }
    }

    public void removeLocalItemExclusion(VersionControlClient client, String exclusion) {
        Check.notNullOrEmpty(exclusion, "exclusion");
        InternalServerInfo serverInfo = this.getCache().getServerInfoByGUID(client.getServerGUID(), client.getConnection().getBaseURI());
        this.getLocalItemExclusionCache().removeExclusion(serverInfo, exclusion);
    }

    public String[] getLocalItemExclusions(VersionControlClient client) {
        InternalServerInfo serverInfo = this.getCache().getServerInfoByGUID(client.getServerGUID(), client.getConnection().getBaseURI());
        return this.getLocalItemExclusionCache().getExclusions(serverInfo);
    }

    public void setLocalItemExclusions(VersionControlClient client, String[] exclusions) {
        InternalServerInfo serverInfo = this.getCache().getServerInfoByGUID(client.getServerGUID(), client.getConnection().getBaseURI());
        this.getLocalItemExclusionCache().setDefaultExclusions(serverInfo, exclusions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForLocalItemExclusionUpdates(VersionControlClient client, boolean force) {
        InternalServerInfo serverInfo = this.getCache().getServerInfoByGUID(client.getServerGUID(), client.getConnection().getBaseURI());
        Object object = this.configurationMutex;
        synchronized (object) {
            AtomicBoolean fallbackUsed;
            ServerSettings settings;
            if (!force) {
                Calendar lastUpdatePlusSevenDays = this.getLocalItemExclusionCache().getLastDefaultExclusionUpdate(serverInfo);
                lastUpdatePlusSevenDays.add(5, 7);
                if (lastUpdatePlusSevenDays.after(Calendar.getInstance())) {
                    return;
                }
            }
            if ((settings = client.getServerSettingsWithFallback(fallbackUsed = new AtomicBoolean())).getDefaultLocalItemExclusionSet() != null) {
                this.getLocalItemExclusionCache().setDefaultExclusions(serverInfo, settings.getDefaultLocalItemExclusionSet());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalItemExclusionCache getLocalItemExclusionCache() {
        Object object = this.configurationMutex;
        synchronized (object) {
            if (this.localItemExclusionCache == null) {
                this.localItemExclusionCache = new LocalItemExclusionCache(this.localItemExclusionCacheFile, this.configurationEnabled);
            }
            return this.localItemExclusionCache;
        }
    }

    public String getName() {
        if (this.type == WorkstationType.CURRENT) {
            return LocalHost.getShortName();
        }
        throw new RuntimeException("Getting the name of a non-CURRENT Workstations is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCacheEnabled() {
        Object object = this.cacheMutex;
        synchronized (object) {
            return this.cacheEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConfigurationEnabled() {
        Object object = this.configurationMutex;
        synchronized (object) {
            return this.configurationEnabled;
        }
    }

    private static File getCacheDirectory(PersistenceStoreProvider provider) {
        Check.notNull(provider, "provider");
        String defaultDirectory = null;
        if (provider.getCachePersistenceStore() != null) {
            defaultDirectory = provider.getCachePersistenceStore().getStoreFile().getAbsolutePath();
        }
        return Workstation.getProperSettingsDirectory(defaultDirectory, "TFSVC_CACHE_DIR");
    }

    public static File getConfigurationDirectory(PersistenceStoreProvider provider) {
        Check.notNull(provider, "provider");
        String defaultDirectory = null;
        if (provider.getConfigurationPersistenceStore() != null) {
            defaultDirectory = ((FilesystemPersistenceStore)provider.getConfigurationPersistenceStore().getChildStore("VersionControl")).getStoreFile().getAbsolutePath();
        }
        return Workstation.getProperSettingsDirectory(defaultDirectory, "TFSVC_CONFIG_DIR");
    }

    public static File getOfflineMetadataFileRoot(PersistenceStoreProvider provider) {
        Check.notNull(provider, "provider");
        File location = null;
        String envVar = PlatformMiscUtils.getInstance().getEnvironmentVariable("TFS_OFFLINE_METADATA_ROOT");
        if (envVar != null && envVar.length() > 0) {
            location = new File(PlatformMiscUtils.getInstance().expandEnvironmentString(envVar));
        }
        if (location == null && Platform.isCurrentPlatform(Platform.WINDOWS)) {
            String appData = SpecialFolders.getCommonApplicationDataPath();
            Check.notNull(appData, "appData");
            location = new File(appData);
            location = new File(location, "Microsoft Team Foundation Local Workspaces");
        }
        if (location == null) {
            location = ((FilesystemPersistenceStore)provider.getConfigurationPersistenceStore().getChildStore(NON_WINDOWS_OFFLINE_STORAGE_CHILD_NAME)).getStoreFile();
        }
        return location;
    }

    private static File getProperSettingsDirectory(String frameworkPath, String environmentVarOverride) {
        Check.notNull(environmentVarOverride, "environmentVarOverride");
        String settingsDir = PlatformMiscUtils.getInstance().getEnvironmentVariable(environmentVarOverride);
        settingsDir = settingsDir == null || settingsDir.length() == 0 ? frameworkPath : PlatformMiscUtils.getInstance().expandEnvironmentString(settingsDir);
        settingsDir = settingsDir == null || settingsDir.length() == 0 ? null : LocalPath.canonicalize(settingsDir);
        return new File(settingsDir);
    }

    private static boolean ensureLocalPathIsUsable(File directory, String shortFileName) {
        if (directory == null || shortFileName == null || shortFileName.length() == 0) {
            return false;
        }
        if (!directory.exists() && !directory.mkdirs()) {
            log.debug((Object)MessageFormat.format("Could not create directory {0}", directory));
            return false;
        }
        File file = new File(directory, shortFileName);
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    log.debug((Object)MessageFormat.format("Could not create file {0}", shortFileName));
                    return false;
                }
                file.delete();
            }
            catch (IOException e) {
                log.debug((Object)MessageFormat.format("Exception creating file {0}", shortFileName), (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

