/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.conflicts;

import com.microsoft.tfs.core.clients.versioncontrol.conflicts.BothDeletedConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictCategory;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.FilenameConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.LocallyDeletedConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.MergeBothDeletedConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.MergeConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.MergeSourceDeletedConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.MergeTargetDeletedConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.RollbackLocalConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ServerDeletedConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ShelvesetConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.UnknownConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.VersionConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.WritableConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;

public class ConflictDescriptionFactory {
    public static final ConflictDescription getConflictDescription(Workspace workspace, Conflict conflict, ItemSpec[] conflictItemSpecs) {
        return ConflictDescriptionFactory.getConflictDescription(ConflictCategory.getConflictCategory(conflict), workspace, conflict, conflictItemSpecs);
    }

    public static final ConflictDescription getConflictDescription(ConflictCategory category) {
        return ConflictDescriptionFactory.getConflictDescription(category, null, null, null);
    }

    public static final ConflictDescription getConflictDescription(ConflictCategory category, Conflict conflict) {
        return ConflictDescriptionFactory.getConflictDescription(category, null, conflict, null);
    }

    private static final ConflictDescription getConflictDescription(ConflictCategory category, Workspace workspace, Conflict conflict, ItemSpec[] conflictItemSpecs) {
        if (category == ConflictCategory.VERSION) {
            return new VersionConflictDescription(workspace, conflict, conflictItemSpecs);
        }
        if (category == ConflictCategory.MERGE) {
            return new MergeConflictDescription(workspace, conflict, conflictItemSpecs);
        }
        if (category == ConflictCategory.LOCALLY_DELETED) {
            return new LocallyDeletedConflictDescription(workspace, conflict, conflictItemSpecs);
        }
        if (category == ConflictCategory.MERGE_SOURCE_DELETED) {
            return new MergeSourceDeletedConflictDescription(workspace, conflict, conflictItemSpecs);
        }
        if (category == ConflictCategory.SERVER_DELETED) {
            return new ServerDeletedConflictDescription(workspace, conflict, conflictItemSpecs);
        }
        if (category == ConflictCategory.MERGE_TARGET_DELETED) {
            return new MergeTargetDeletedConflictDescription(workspace, conflict, conflictItemSpecs);
        }
        if (category == ConflictCategory.BOTH_DELETED) {
            return new BothDeletedConflictDescription(workspace, conflict, conflictItemSpecs);
        }
        if (category == ConflictCategory.MERGE_BOTH_DELETED) {
            return new MergeBothDeletedConflictDescription(workspace, conflict, conflictItemSpecs);
        }
        if (category == ConflictCategory.FILENAME) {
            return new FilenameConflictDescription(workspace, conflict, conflictItemSpecs);
        }
        if (category == ConflictCategory.WRITABLE) {
            return new WritableConflictDescription(workspace, conflict, conflictItemSpecs);
        }
        if (category == ConflictCategory.SHELVESET) {
            return new ShelvesetConflictDescription(workspace, conflict, conflictItemSpecs);
        }
        if (category == ConflictCategory.ROLLBACK_LOCAL) {
            return new RollbackLocalConflictDescription(workspace, conflict, conflictItemSpecs);
        }
        return new UnknownConflictDescription(workspace, conflict, conflictItemSpecs);
    }

    public static final ConflictDescription[] getConflictDescriptions(Workspace workspace, Conflict[] conflicts, ItemSpec[] conflictItemSpecs) {
        ConflictDescription[] conflictDescriptions = new ConflictDescription[conflicts.length];
        for (int i = 0; i < conflicts.length; ++i) {
            conflictDescriptions[i] = ConflictDescriptionFactory.getConflictDescription(workspace, conflicts[i], conflictItemSpecs);
        }
        return conflictDescriptions;
    }
}

