/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.conflicts;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictCategory;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictDescriptionStrings;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.VersionConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolutionOptions;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.CoreConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.contributors.ConflictResolutionContributor;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Resolution;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import java.text.MessageFormat;
import java.util.ArrayList;

public class MergeConflictDescription
extends VersionConflictDescription {
    protected MergeConflictDescription(Workspace workspace, Conflict conflict, ItemSpec[] conflictItemSpecs) {
        super(workspace, conflict, conflictItemSpecs);
    }

    @Override
    public ConflictCategory getConflictCategory() {
        return ConflictCategory.MERGE;
    }

    @Override
    public String getName() {
        return Messages.getString("MergeConflictDescription.Name");
    }

    @Override
    public String getDescription() {
        Conflict conflict = this.getConflict();
        if (this.filesRenamed() && conflict != null && conflict.getBaseItemType() == ItemType.FOLDER && conflict.getTheirItemType() == ItemType.FOLDER && conflict.getTheirItemType() == ItemType.FOLDER) {
            return Messages.getString("MergeConflictDescription.DescriptionChanged");
        }
        if (this.isBaseless()) {
            return Messages.getString("MergeConflictDescription.BaselessMerge");
        }
        if (this.filesRenamedOnly()) {
            return Messages.getString("MergeConflictDescription.DescriptionRenamedOnly");
        }
        if (this.filesRenamed() && this.isEncodingChange()) {
            return Messages.getString("MergeConflictDescription.DescriptionRenamedAndEncodingChange");
        }
        if (this.filesRenamed()) {
            return Messages.getString("MergeConflictDescription.DescriptionRenamed");
        }
        if (this.isEncodingChange()) {
            return Messages.getString("MergeConflictDescription.DescriptionEncodingChange");
        }
        return Messages.getString("MergeConflictDescription.DescriptionBothHaveChanges");
    }

    @Override
    public String getLocalFileDescription() {
        return Messages.getString("MergeConflictDescription.LocalFileDescription");
    }

    @Override
    public String getRemoteFileDescription() {
        return Messages.getString("MergeConflictDescription.ServerFileDescription");
    }

    @Override
    public String getServerPath() {
        return this.getConflict().getYourServerItemSource();
    }

    @Override
    protected boolean filesRenamed() {
        Conflict conflict = this.getConflict();
        if (conflict != null) {
            return conflict.getYourServerItemSource() != null && !ServerPath.equals(conflict.getYourServerItemSource(), conflict.getYourServerItem());
        }
        return false;
    }

    @Override
    protected boolean targetRenamed() {
        Conflict conflict = this.getConflict();
        if (conflict != null) {
            return conflict.getYourChangeType() == null || conflict.getYourChangeType().contains(ChangeType.RENAME);
        }
        return false;
    }

    @Override
    public ConflictResolution[] getResolutions(ConflictResolutionContributor resolutionContributor) {
        ArrayList<ConflictResolution> resolutionList = new ArrayList<ConflictResolution>();
        if (this.filesRenamedOnly()) {
            resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.RENAME, ConflictDescriptionStrings.RENAME_TOOLTIP, ConflictResolutionOptions.SELECT_NAME, Resolution.ACCEPT_MERGE));
        } else if (this.filesRenamed()) {
            if (this.getConflict().getBaseItemType() == ItemType.FOLDER && this.getConflict().getTheirItemType() == ItemType.FOLDER && this.getConflict().getTheirItemType() == ItemType.FOLDER) {
                resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.RENAME, ConflictDescriptionStrings.RENAME_TOOLTIP, ConflictResolutionOptions.SELECT_NAME, Resolution.ACCEPT_MERGE));
            } else {
                ConflictResolutionOptions resolutionOptions;
                if (this.isEncodingChange()) {
                    resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.RENAME_ENCODING_AND_AUTOMERGE, ConflictDescriptionStrings.RENAME_ENCODING_AND_AUTOMERGE_TOOLTIP, ConflictResolutionOptions.SELECT_NAME.combine(ConflictResolutionOptions.SELECT_ENCODING), Resolution.ACCEPT_MERGE));
                    resolutionOptions = ConflictResolutionOptions.SELECT_NAME.combine(ConflictResolutionOptions.SELECT_ENCODING);
                } else {
                    resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.RENAME_AND_AUTOMERGE, ConflictDescriptionStrings.RENAME_AND_AUTOMERGE_TOOLTIP, ConflictResolutionOptions.SELECT_NAME, Resolution.ACCEPT_MERGE));
                    resolutionOptions = ConflictResolutionOptions.SELECT_NAME;
                }
                resolutionList.addAll(this.loadContributedResolutions(resolutionContributor, resolutionOptions));
            }
        } else if (!this.targetRenamed()) {
            ConflictResolutionOptions resolutionOptions;
            if (this.isEncodingChange()) {
                resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.SELECT_ENCODING_AND_AUTOMERGE, ConflictDescriptionStrings.SELECT_ENCODING_AND_AUTOMERGE_TOOLTIP, ConflictResolutionOptions.SELECT_ENCODING, Resolution.ACCEPT_MERGE));
                resolutionOptions = ConflictResolutionOptions.SELECT_ENCODING;
            } else {
                resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.AUTOMERGE, MessageFormat.format(ConflictDescriptionStrings.AUTOMERGE_TOOLTIP, this.getLocalFileDescription(), this.getRemoteFileDescription()), ConflictResolutionOptions.NONE, Resolution.ACCEPT_MERGE));
                resolutionOptions = ConflictResolutionOptions.NONE;
            }
            if (resolutionContributor != null) {
                resolutionList.addAll(this.loadContributedResolutions(resolutionContributor, resolutionOptions));
            }
        }
        resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.MERGE_ACCEPT_YOURS, ConflictDescriptionStrings.MERGE_ACCEPT_YOURS_TOOLTIP, ConflictResolutionOptions.NONE, Resolution.ACCEPT_YOURS));
        resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.MERGE_ACCEPT_THEIRS, ConflictDescriptionStrings.MERGE_ACCEPT_THEIRS_TOOLTIP, ConflictResolutionOptions.NONE, Resolution.ACCEPT_THEIRS));
        return resolutionList.toArray(new ConflictResolution[resolutionList.size()]);
    }
}

