/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.engines.internal;

import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.AsyncOperation;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.WorkerStatus;
import com.microsoft.tfs.core.clients.versioncontrol.internal.concurrent.AccountingCompletionService;
import com.microsoft.tfs.util.Check;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class BaselineDownloadAsyncOperation
extends AsyncOperation {
    private static final Log log = LogFactory.getLog(BaselineDownloadAsyncOperation.class);

    public static void waitForCompletions(AccountingCompletionService<WorkerStatus> completionService) {
        Check.notNull(completionService, "completionService");
        completionService.waitForCompletions(new AccountingCompletionService.ResultProcessor<WorkerStatus>(){

            @Override
            public void processResult(WorkerStatus result) {
                WorkerStatus status = result;
                if (status.getFinalState() == WorkerStatus.FinalState.ERROR) {
                    log.debug((Object)"Baseline download finished with ERROR");
                } else if (status.getFinalState() == WorkerStatus.FinalState.CANCELED) {
                    log.debug((Object)"Baseline download thread finished with CANCELED");
                }
            }
        }, new AccountingCompletionService.ExecutionExceptionHandler(){

            @Override
            public void handleException(ExecutionException e) {
                log.warn((Object)"Baseline download exception", (Throwable)e);
            }
        });
    }
}

